/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.eclipse.model;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.conversion.AbstractIdeaSpecificSettings;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaModuleExtension;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.java.JpsJavaSdkTypeWrapper;
import org.jetbrains.jps.model.java.LanguageLevel;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsDependenciesList;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsSdkReferencesTable;
import org.jetbrains.jps.model.serialization.JpsMacroExpander;
import org.jetbrains.jps.model.serialization.library.JpsSdkTableSerializer;

class JpsIdeaSpecificSettings
extends AbstractIdeaSpecificSettings<JpsModule, String, JpsSdkType<?>> {
    private JpsMacroExpander myExpander;

    JpsIdeaSpecificSettings(JpsMacroExpander expander) {
        this.myExpander = expander;
    }

    @Override
    protected void readLibraryLevels(Element root, @NotNull Map<String, String> levels) {
        if (levels == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "levels", "org/jetbrains/jps/eclipse/model/JpsIdeaSpecificSettings", "readLibraryLevels"));
        }
        Element levelsElement = root.getChild("levels");
        if (levelsElement != null) {
            for (Element element : levelsElement.getChildren("level")) {
                String libName = element.getAttributeValue("name");
                String libLevel = element.getAttributeValue("value");
                if (libName == null || libLevel == null) continue;
                levels.put(libName, libLevel);
            }
        }
    }

    protected String[] getEntries(JpsModule model) {
        return ArrayUtil.toStringArray((Collection)model.getContentRootsList().getUrls());
    }

    @Override
    protected String createContentEntry(JpsModule model, String url) {
        model.getContentRootsList().addUrl(url);
        return url;
    }

    @Override
    protected void setupLibraryRoots(Element root, JpsModule model) {
    }

    @Override
    protected void setupJdk(Element root, JpsModule model, @Nullable JpsSdkType<?> projectSdkType) {
        String inheritJdk = root.getAttributeValue("inheritJdk");
        JpsDependenciesList dependenciesList = model.getDependenciesList();
        if (inheritJdk != null && Boolean.parseBoolean(inheritJdk)) {
            dependenciesList.addSdkDependency((JpsSdkType)(projectSdkType != null ? projectSdkType : JpsJavaSdkType.INSTANCE));
        } else {
            String jdkName = root.getAttributeValue("jdk");
            if (jdkName != null) {
                String jdkType = root.getAttributeValue("jdk_type");
                JpsSdkType sdkType = null;
                if (jdkType != null) {
                    sdkType = JpsSdkTableSerializer.getSdkType((String)jdkType);
                }
                if (sdkType == null) {
                    sdkType = JpsJavaSdkType.INSTANCE;
                }
                dependenciesList.addSdkDependency(sdkType);
                JpsSdkTableSerializer.setSdkReference((JpsSdkReferencesTable)model.getSdkReferencesTable(), (String)jdkName, (JpsSdkType)sdkType);
                if (sdkType instanceof JpsJavaSdkTypeWrapper) {
                    dependenciesList.addSdkDependency((JpsSdkType)JpsJavaSdkType.INSTANCE);
                }
            }
        }
    }

    @Override
    protected void setupCompilerOutputs(Element root, JpsModule model) {
        String inheritedOutput;
        JpsJavaModuleExtension extension = JpsIdeaSpecificSettings.getService().getOrCreateModuleExtension(model);
        Element testOutputElement = root.getChild("output-test");
        if (testOutputElement != null) {
            extension.setTestOutputUrl(testOutputElement.getAttributeValue("url"));
        }
        if ((inheritedOutput = root.getAttributeValue("inherit-compiler-output")) != null && Boolean.valueOf(inheritedOutput).booleanValue()) {
            extension.setInheritOutput(true);
        }
        extension.setExcludeOutput(root.getChild("exclude-output") != null);
    }

    @Override
    protected void readLanguageLevel(Element root, JpsModule model) {
        String languageLevel = root.getAttributeValue("LANGUAGE_LEVEL");
        JpsJavaModuleExtension extension = JpsIdeaSpecificSettings.getService().getOrCreateModuleExtension(model);
        if (languageLevel != null) {
            extension.setLanguageLevel(LanguageLevel.valueOf((String)languageLevel));
        }
    }

    @Override
    protected void expandElement(Element root, JpsModule model) {
        this.myExpander.substitute(root, SystemInfo.isFileSystemCaseSensitive);
    }

    @Override
    protected void overrideModulesScopes(Element root, JpsModule model) {
    }

    @Override
    public void readContentEntry(Element root, String contentUrl, JpsModule model) {
        for (Element o : root.getChildren("testFolder")) {
            String url = o.getAttributeValue("url");
            JpsModuleSourceRoot folderToBeTest = null;
            for (JpsModuleSourceRoot folder : model.getSourceRoots()) {
                if (!Comparing.strEqual((String)folder.getUrl(), (String)url)) continue;
                folderToBeTest = folder;
                break;
            }
            if (folderToBeTest != null) {
                model.removeSourceRoot(folderToBeTest.getUrl(), (JpsModuleSourceRootType)JavaSourceRootType.SOURCE);
            }
            model.addSourceRoot(url, (JpsModuleSourceRootType)JavaSourceRootType.TEST_SOURCE);
        }
        for (Element o : root.getChildren("excludeFolder")) {
            String excludeUrl = o.getAttributeValue("url");
            if (!FileUtil.isAncestor((File)new File(contentUrl), (File)new File(excludeUrl), (boolean)false)) continue;
            model.getExcludeRootsList().addUrl(excludeUrl);
        }
        Iterator i$ = root.getChildren("packagePrefix").iterator();
        block3: while (i$.hasNext()) {
            Element o;
            Element ppElement = o = (Element)i$.next();
            String prefix = ppElement.getAttributeValue("value");
            String url = ppElement.getAttributeValue("url");
            for (JpsModuleSourceRoot sourceRoot : model.getSourceRoots()) {
                if (!Comparing.strEqual((String)sourceRoot.getUrl(), (String)url)) continue;
                JpsElement properties = sourceRoot.getProperties();
                if (!(properties instanceof JavaSourceRootProperties)) continue block3;
                ((JavaSourceRootProperties)properties).setPackagePrefix(prefix);
                continue block3;
            }
        }
    }

    private static JpsJavaExtensionService getService() {
        return JpsJavaExtensionService.getInstance();
    }
}

