/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javaee.model.web.impl;

import com.intellij.openapi.util.JDOMUtil;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.javaee.model.impl.JpsJavaeeModuleExtensionSerializerBase;
import org.jetbrains.jps.javaee.model.web.JpsWebModuleExtension;
import org.jetbrains.jps.javaee.model.web.JpsWebRoot;
import org.jetbrains.jps.javaee.model.web.impl.JpsWebModuleExtensionImpl;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;

public class JpsWebModuleExtensionSerializer
extends JpsJavaeeModuleExtensionSerializerBase<JpsWebModuleExtension> {
    private static final String WEB_ROOTS_TAG = "webroots";
    private static final String ROOT_TAG = "root";
    private static final String URL_ATTRIBUTE = "url";
    private static final String RELATIVE_ATTRIBUTE = "relative";
    private static final String SOURCE_ROOTS_TAG = "sourceRoots";

    public JpsWebModuleExtensionSerializer() {
        super(JpsWebModuleExtensionImpl.ROLE, JpsWebModuleExtensionImpl.COLLECTION_ROLE, "web");
    }

    public JpsWebModuleExtension loadExtension(@NotNull Element facetConfigurationElement, String name, JpsElement parent, JpsModule module) {
        if (facetConfigurationElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetConfigurationElement", "org/jetbrains/jps/javaee/model/web/impl/JpsWebModuleExtensionSerializer", "loadExtension"));
        }
        JpsWebModuleExtensionImpl extension = new JpsWebModuleExtensionImpl(name);
        for (Element webRoot : JDOMUtil.getChildren((Element)facetConfigurationElement.getChild(WEB_ROOTS_TAG), (String)ROOT_TAG)) {
            extension.addWebRoot(webRoot.getAttributeValue(URL_ATTRIBUTE), webRoot.getAttributeValue(RELATIVE_ATTRIBUTE));
        }
        Element sourceRootsTag = facetConfigurationElement.getChild(SOURCE_ROOTS_TAG);
        if (sourceRootsTag != null) {
            for (Element sourceRoot : JDOMUtil.getChildren((Element)sourceRootsTag, (String)ROOT_TAG)) {
                extension.getSourceRootsList().addUrl(sourceRoot.getAttributeValue(URL_ATTRIBUTE));
            }
        } else {
            for (String url : JpsWebModuleExtensionSerializer.getAllSourceRootsList(module)) {
                extension.getSourceRootsList().addUrl(url);
            }
        }
        JpsWebModuleExtensionSerializer.loadJavaeeConfigFiles(extension, facetConfigurationElement);
        return extension;
    }

    protected void saveExtension(JpsWebModuleExtension extension, Element facetConfigurationTag, JpsModule module) {
        JpsWebModuleExtensionSerializer.saveJavaeeConfigFiles(extension, facetConfigurationTag);
        Element webRootsTag = new Element(WEB_ROOTS_TAG);
        for (JpsWebRoot webRoot : extension.getWebRoots()) {
            webRootsTag.addContent(new Element(ROOT_TAG).setAttribute(URL_ATTRIBUTE, webRoot.getUrl()).setAttribute(RELATIVE_ATTRIBUTE, webRoot.getRelativePath()));
        }
        facetConfigurationTag.addContent(webRootsTag);
        List<String> sourceUrls = JpsWebModuleExtensionSerializer.getAllSourceRootsList(module);
        if (!((Object)sourceUrls).equals(extension.getSourceRootsList().getUrls())) {
            Element sourceRootsTag = new Element(SOURCE_ROOTS_TAG);
            for (String url : extension.getSourceRootsList().getUrls()) {
                sourceRootsTag.addContent(new Element(ROOT_TAG).setAttribute(URL_ATTRIBUTE, url));
            }
            facetConfigurationTag.addContent(sourceRootsTag);
        }
    }

    private static List<String> getAllSourceRootsList(JpsModule module) {
        ArrayList<String> sourceUrls = new ArrayList<String>();
        for (JpsModuleSourceRoot root : module.getSourceRoots()) {
            if (!root.getRootType().equals(JavaSourceRootType.SOURCE)) continue;
            sourceUrls.add(root.getUrl());
        }
        return sourceUrls;
    }
}

