/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.Constant;
import java.util.HashMap;
import java.util.Map;

public abstract class ConstantPool<T extends Constant<T>> {
    private final Map<String, T> constants = new HashMap<String, T>();
    private int nextId = 1;

    public T valueOf(Class<?> firstNameComponent, String secondNameComponent) {
        if (firstNameComponent == null) {
            throw new NullPointerException("firstNameComponent");
        }
        if (secondNameComponent == null) {
            throw new NullPointerException("secondNameComponent");
        }
        return this.valueOf(firstNameComponent.getName() + '#' + secondNameComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T valueOf(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("empty name");
        }
        Map<String, T> map = this.constants;
        synchronized (map) {
            Constant c = (Constant)this.constants.get(name);
            if (c == null) {
                c = this.newConstant(this.nextId, name);
                this.constants.put(name, c);
                ++this.nextId;
            }
            return (T)c;
        }
    }

    protected abstract T newConstant(int var1, String var2);
}

