/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.process;

import com.android.annotations.NonNull;
import com.android.ide.common.process.JavaProcessInfo;
import com.android.ide.common.process.ProcessEnvBuilder;
import com.android.ide.common.process.ProcessInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ProcessInfoBuilder
extends ProcessEnvBuilder<ProcessInfoBuilder> {
    private String mExecutable;
    private String mClasspath;
    private String mMain;
    private final List<String> mArgs = Lists.newArrayList();
    private final List<String> mJvmArgs = Lists.newArrayList();

    @NonNull
    public ProcessInfo createProcess() {
        Preconditions.checkNotNull((Object)this.mExecutable, (Object)"executable is missing");
        return new ProcessInfoImpl(this.mExecutable, (List<String>)ImmutableList.copyOf(this.mArgs), (Map<String, Object>)ImmutableMap.copyOf((Map)this.mEnvironment));
    }

    @NonNull
    public JavaProcessInfo createJavaProcess() {
        Preconditions.checkNotNull((Object)this.mClasspath, (Object)"classpath is missing");
        Preconditions.checkNotNull((Object)this.mMain, (Object)"main class is missing");
        return new JavaProcessInfoImpl(this.mClasspath, this.mMain, (List<String>)ImmutableList.copyOf(this.mArgs), (Map<String, Object>)ImmutableMap.copyOf((Map)this.mEnvironment), (List<String>)ImmutableList.copyOf(this.mJvmArgs));
    }

    @NonNull
    public ProcessInfoBuilder setExecutable(@NonNull String executable) {
        this.mExecutable = executable;
        return this;
    }

    @NonNull
    public ProcessInfoBuilder setExecutable(@NonNull File executable) {
        this.mExecutable = executable.getAbsolutePath();
        return this;
    }

    @NonNull
    public ProcessInfoBuilder setClasspath(@NonNull String classpath) {
        this.mClasspath = classpath;
        return this;
    }

    @NonNull
    public ProcessInfoBuilder setMain(@NonNull String mainClass) {
        this.mMain = mainClass;
        return this;
    }

    @NonNull
    public ProcessInfoBuilder addArgs(@NonNull String arg) {
        this.mArgs.add(arg);
        return this;
    }

    @NonNull
    public ProcessInfoBuilder addArgs(@NonNull String arg1, @NonNull String arg2) {
        this.mArgs.add(arg1);
        this.mArgs.add(arg2);
        return this;
    }

    @NonNull
    public ProcessInfoBuilder addArgs(@NonNull String arg1, @NonNull String arg2, @NonNull String arg3) {
        this.mArgs.add(arg1);
        this.mArgs.add(arg2);
        this.mArgs.add(arg3);
        return this;
    }

    @NonNull
    public ProcessInfoBuilder addArgs(@NonNull String arg1, @NonNull String arg2, @NonNull String arg3, String ... args) {
        this.mArgs.add(arg1);
        this.mArgs.add(arg2);
        this.mArgs.add(arg3);
        this.mArgs.addAll(Arrays.asList(args));
        return this;
    }

    @NonNull
    public ProcessInfoBuilder addArgs(@NonNull List<String> args) {
        this.mArgs.addAll(args);
        return this;
    }

    @NonNull
    public ProcessInfoBuilder addArgs(@NonNull String[] args) {
        Collections.addAll(this.mArgs, args);
        return this;
    }

    @NonNull
    public ProcessInfoBuilder addJvmArg(@NonNull String arg) {
        this.mJvmArgs.add(arg);
        return this;
    }

    @NonNull
    public ProcessInfoBuilder addJvmArgs(@NonNull String arg1, @NonNull String arg2) {
        this.mJvmArgs.add(arg1);
        this.mJvmArgs.add(arg2);
        return this;
    }

    @NonNull
    public ProcessInfoBuilder addJvmArgs(@NonNull String arg1, @NonNull String arg2, @NonNull String arg3) {
        this.mJvmArgs.add(arg1);
        this.mJvmArgs.add(arg2);
        this.mJvmArgs.add(arg3);
        return this;
    }

    @NonNull
    public ProcessInfoBuilder addJvmArgs(@NonNull String arg1, @NonNull String arg2, @NonNull String arg3, String ... args) {
        this.mJvmArgs.add(arg1);
        this.mJvmArgs.add(arg2);
        this.mJvmArgs.add(arg3);
        this.mJvmArgs.addAll(Arrays.asList(args));
        return this;
    }

    @NonNull
    public ProcessInfoBuilder addJvmArgs(@NonNull List<String> args) {
        this.mJvmArgs.addAll(args);
        return this;
    }

    protected static class JavaProcessInfoImpl
    implements JavaProcessInfo {
        private final String mClasspath;
        private final String mMain;
        private final List<String> mArgs;
        private final Map<String, Object> mEnvironment;
        private final List<String> mJvmArgs;

        public JavaProcessInfoImpl(@NonNull String classpath, @NonNull String main, @NonNull List<String> args, @NonNull Map<String, Object> environment, @NonNull List<String> jvmArgs) {
            this.mClasspath = classpath;
            this.mMain = main;
            this.mArgs = args;
            this.mEnvironment = environment;
            this.mJvmArgs = jvmArgs;
        }

        @Override
        @NonNull
        public String getExecutable() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NonNull
        public String getClasspath() {
            return this.mClasspath;
        }

        @Override
        @NonNull
        public String getMainClass() {
            return this.mMain;
        }

        @Override
        @NonNull
        public List<String> getArgs() {
            return this.mArgs;
        }

        @Override
        @NonNull
        public Map<String, Object> getEnvironment() {
            return this.mEnvironment;
        }

        @Override
        @NonNull
        public List<String> getJvmArgs() {
            return this.mJvmArgs;
        }
    }

    protected static class ProcessInfoImpl
    implements ProcessInfo {
        private final String mExecutable;
        private final List<String> mArgs;
        private final Map<String, Object> mEnvironment;

        public ProcessInfoImpl(@NonNull String executable, @NonNull List<String> args, @NonNull Map<String, Object> environment) {
            this.mExecutable = executable;
            this.mArgs = args;
            this.mEnvironment = environment;
        }

        @Override
        @NonNull
        public String getExecutable() {
            return this.mExecutable;
        }

        @Override
        @NonNull
        public List<String> getArgs() {
            return this.mArgs;
        }

        @Override
        @NonNull
        public Map<String, Object> getEnvironment() {
            return this.mEnvironment;
        }
    }
}

