/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.jps.model.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaProjectExtension;
import org.jetbrains.jps.util.JpsPathUtil;
import org.jetbrains.osgi.jps.model.JpsOsmorcProjectExtension;
import org.jetbrains.osgi.jps.model.impl.OsmorcProjectExtensionProperties;

public class JpsOsmorcProjectExtensionImpl
extends JpsElementBase<JpsOsmorcProjectExtensionImpl>
implements JpsOsmorcProjectExtension {
    private OsmorcProjectExtensionProperties myProperties;

    public JpsOsmorcProjectExtensionImpl(OsmorcProjectExtensionProperties properties) {
        this.myProperties = properties;
    }

    public void applyChanges(@NotNull JpsOsmorcProjectExtensionImpl modified) {
        if (modified == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modified", "org/jetbrains/osgi/jps/model/impl/JpsOsmorcProjectExtensionImpl", "applyChanges"));
        }
        XmlSerializerUtil.copyBean((Object)modified.myProperties, (Object)this.myProperties);
    }

    @NotNull
    public JpsOsmorcProjectExtensionImpl createCopy() {
        JpsOsmorcProjectExtensionImpl jpsOsmorcProjectExtensionImpl = new JpsOsmorcProjectExtensionImpl((OsmorcProjectExtensionProperties)XmlSerializerUtil.createCopy((Object)this.myProperties));
        if (jpsOsmorcProjectExtensionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/model/impl/JpsOsmorcProjectExtensionImpl", "createCopy"));
        }
        return jpsOsmorcProjectExtensionImpl;
    }

    @Override
    public String getBundlesOutputPath() {
        return this.myProperties.myBundlesOutputPath;
    }

    @Override
    public String getDefaultManifestFileLocation() {
        return this.myProperties.myDefaultManifestFileLocation;
    }

    @NotNull
    public static String getDefaultBundlesOutputPath(JpsProject project) {
        String outputUrl;
        JpsJavaExtensionService service = JpsJavaExtensionService.getInstance();
        JpsJavaProjectExtension extension = service.getProjectExtension(project);
        if (extension != null && (outputUrl = extension.getOutputUrl()) != null) {
            String string = JpsPathUtil.urlToPath((String)outputUrl) + "/bundles";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/model/impl/JpsOsmorcProjectExtensionImpl", "getDefaultBundlesOutputPath"));
            }
            return string;
        }
        String string = FileUtil.getTempDirectory();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/model/impl/JpsOsmorcProjectExtensionImpl", "getDefaultBundlesOutputPath"));
        }
        return string;
    }
}

