/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import org.jetbrains.annotations.NotNull;

public class MergingCharSequence
implements CharSequence {
    private final CharSequence s1;
    private final CharSequence s2;

    public MergingCharSequence(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        if (s1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s1", "com/intellij/util/text/MergingCharSequence", "<init>"));
        }
        if (s2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s2", "com/intellij/util/text/MergingCharSequence", "<init>"));
        }
        this.s1 = s1;
        this.s2 = s2;
    }

    @Override
    public int length() {
        return this.s1.length() + this.s2.length();
    }

    @Override
    public char charAt(int index) {
        if (index < this.s1.length()) {
            return this.s1.charAt(index);
        }
        return this.s2.charAt(index - this.s1.length());
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start < this.s1.length() && end < this.s1.length()) {
            return this.s1.subSequence(start, end);
        }
        if (start >= this.s1.length() && end >= this.s1.length()) {
            return this.s2.subSequence(start - this.s1.length(), end - this.s1.length());
        }
        return new MergingCharSequence(this.s1.subSequence(start, this.s1.length()), this.s2.subSequence(0, end - this.s1.length()));
    }

    @Override
    @NotNull
    public String toString() {
        String string = ((Object)this.s1).toString() + ((Object)this.s2).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/MergingCharSequence", "toString"));
        }
        return string;
    }
}

