/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.Processor;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.LimitedInputStream;
import com.intellij.util.io.MappedFileInputStream;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.ResizeableMappedFile;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.Nullable;

public class AppendableStorageBackedByResizableMappedFile
extends ResizeableMappedFile {
    private final MyDataIS myReadStream = new MyDataIS(this);
    private byte[] myAppendBuffer;
    private volatile int myFileLength = (int)this.length();
    private volatile int myBufferPosition;
    private static final int ourAppendBufferLength = 4096;

    public AppendableStorageBackedByResizableMappedFile(File file, int initialSize, @Nullable PagedFileStorage.StorageLockContext lockContext, int pageSize, boolean valuesAreBufferAligned) throws IOException {
        super(file, initialSize, lockContext, pageSize, valuesAreBufferAligned);
    }

    private void flushKeyStoreBuffer() {
        if (this.myBufferPosition > 0) {
            this.put(this.myFileLength, this.myAppendBuffer, 0, this.myBufferPosition);
            this.myFileLength += this.myBufferPosition;
            this.myBufferPosition = 0;
        }
    }

    @Override
    public void force() {
        this.flushKeyStoreBuffer();
        super.force();
    }

    @Override
    public void close() {
        this.flushKeyStoreBuffer();
        super.close();
    }

    public <Data> Data read(int addr, KeyDescriptor<Data> descriptor) throws IOException {
        if (this.myFileLength <= addr) {
            return (Data)descriptor.read(new DataInputStream(new UnsyncByteArrayInputStream(this.myAppendBuffer, addr - this.myFileLength, this.myBufferPosition)));
        }
        this.myReadStream.setup(addr, this.myFileLength);
        return (Data)descriptor.read(this.myReadStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <Data> boolean processAll(Processor<Data> processor, KeyDescriptor<Data> descriptor) throws IOException {
        assert (!this.isDirty());
        DataInputStream keysStream = new DataInputStream(new BufferedInputStream(new LimitedInputStream(new FileInputStream(this.getPagedFileStorage().getFile()), this.myFileLength){

            @Override
            public int available() throws IOException {
                return this.remainingLimit();
            }
        }, 32768));
        try {
            while (true) {
                Object key;
                if (!processor.process(key = descriptor.read(keysStream))) {
                    boolean bl = false;
                    return bl;
                }
                continue;
                break;
            }
        }
        catch (EOFException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            keysStream.close();
        }
    }

    public int getCurrentLength() {
        return this.myBufferPosition + this.myFileLength;
    }

    public <Data> int append(Data value, KeyDescriptor<Data> descriptor) throws IOException {
        BufferExposingByteArrayOutputStream bos = new BufferExposingByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        descriptor.save(out, value);
        int size = bos.size();
        byte[] buffer = bos.getInternalBuffer();
        int currentLength = this.getCurrentLength();
        if (size > 4096) {
            this.flushKeyStoreBuffer();
            this.put(currentLength, buffer, 0, size);
            this.myFileLength += size;
        } else {
            if (size > 4096 - this.myBufferPosition) {
                this.flushKeyStoreBuffer();
            }
            if (this.myAppendBuffer == null) {
                this.myAppendBuffer = new byte[4096];
            }
            System.arraycopy(buffer, 0, this.myAppendBuffer, this.myBufferPosition, size);
            this.myBufferPosition += size;
        }
        return currentLength;
    }

    public <Data> boolean checkBytesAreTheSame(final int addr, Data value, KeyDescriptor<Data> descriptor) throws IOException {
        final boolean[] sameValue = new boolean[1];
        final PagedFileStorage storage = this.getPagedFileStorage();
        OutputStream comparer = this.myFileLength <= addr ? new OutputStream(){
            int address;
            boolean same;
            {
                this.address = addr - AppendableStorageBackedByResizableMappedFile.this.myFileLength;
                this.same = true;
            }

            @Override
            public void write(int b) {
                if (this.same) {
                    this.same = this.address < AppendableStorageBackedByResizableMappedFile.this.myBufferPosition && AppendableStorageBackedByResizableMappedFile.this.myAppendBuffer[this.address++] == (byte)b;
                }
            }

            @Override
            public void close() {
                sameValue[0] = this.same;
            }
        } : new OutputStream(){
            int base;
            int address;
            boolean same;
            ByteBuffer buffer;
            final int myPageSize;
            {
                this.base = addr;
                this.address = storage.getOffsetInPage(addr);
                this.same = true;
                this.buffer = storage.getByteBuffer(addr, false).getCachedBuffer();
                this.myPageSize = storage.myPageSize;
            }

            @Override
            public void write(int b) {
                if (this.same) {
                    if (this.myPageSize == this.address && this.address < AppendableStorageBackedByResizableMappedFile.this.myFileLength) {
                        this.base += this.address;
                        this.buffer = storage.getByteBuffer(this.base, false).getCachedBuffer();
                        this.address = 0;
                    }
                    this.same = this.address < AppendableStorageBackedByResizableMappedFile.this.myFileLength && this.buffer.get(this.address++) == (byte)b;
                }
            }

            @Override
            public void close() {
                sameValue[0] = this.same;
            }
        };
        DataOutputStream out = new DataOutputStream(comparer);
        descriptor.save(out, value);
        comparer.close();
        return sameValue[0];
    }

    private static class MyBufferedIS
    extends BufferedInputStream {
        public MyBufferedIS(InputStream in) {
            super(in, 512);
        }

        public void setup(long pos, long limit) {
            this.pos = 0;
            this.count = 0;
            ((MappedFileInputStream)this.in).setup(pos, limit);
        }
    }

    private static class MyDataIS
    extends DataInputStream {
        private MyDataIS(ResizeableMappedFile raf) {
            super(new MyBufferedIS(new MappedFileInputStream(raf, 0L, 0L)));
        }

        public void setup(long pos, long limit) {
            ((MyBufferedIS)this.in).setup(pos, limit);
        }
    }
}

