/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.compiler;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootCopyingHandlerProvider;
import org.jetbrains.jps.incremental.artifacts.instructions.FileCopyingHandler;
import org.jetbrains.jps.maven.model.JpsMavenExtensionService;
import org.jetbrains.jps.maven.model.impl.MavenModuleResourceConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.elements.JpsModuleOutputPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;

public class MavenCommonArtifactRootCopyingHandlerProvider
extends ArtifactRootCopyingHandlerProvider {
    private static final Logger LOG = Logger.getInstance(MavenCommonArtifactRootCopyingHandlerProvider.class);

    @Nullable
    public FileCopyingHandler createCustomHandler(@NotNull JpsArtifact artifact, @NotNull File root, @NotNull JpsPackagingElement contextElement, @NotNull JpsModel model, @NotNull BuildDataPaths buildDataPaths) {
        MavenModuleResourceConfiguration moduleResourceConfiguration;
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/jps/maven/compiler/MavenCommonArtifactRootCopyingHandlerProvider", "createCustomHandler"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/jps/maven/compiler/MavenCommonArtifactRootCopyingHandlerProvider", "createCustomHandler"));
        }
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "org/jetbrains/jps/maven/compiler/MavenCommonArtifactRootCopyingHandlerProvider", "createCustomHandler"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/jps/maven/compiler/MavenCommonArtifactRootCopyingHandlerProvider", "createCustomHandler"));
        }
        if (buildDataPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildDataPaths", "org/jetbrains/jps/maven/compiler/MavenCommonArtifactRootCopyingHandlerProvider", "createCustomHandler"));
        }
        if (contextElement instanceof JpsModuleOutputPackagingElement) {
            return null;
        }
        MavenProjectConfiguration projectConfiguration = JpsMavenExtensionService.getInstance().getMavenProjectConfiguration(buildDataPaths);
        if (projectConfiguration == null) {
            return null;
        }
        if ("MANIFEST.MF".equals(root.getName()) && (moduleResourceConfiguration = projectConfiguration.moduleConfigurations.get(MavenCommonArtifactRootCopyingHandlerProvider.getModuleName(artifact.getName()))) != null && moduleResourceConfiguration.manifest != null) {
            try {
                FileUtil.writeToFile((File)root, (String)moduleResourceConfiguration.manifest);
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    private static String getModuleName(@NotNull String artifactName) {
        if (artifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactName", "org/jetbrains/jps/maven/compiler/MavenCommonArtifactRootCopyingHandlerProvider", "getModuleName"));
        }
        return StringUtil.substringBefore((String)artifactName, (String)":");
    }
}

