/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl.compiler;

import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;

public final class ProcessorConfigProfileImpl
implements ProcessorConfigProfile {
    private String myName = "";
    private boolean myEnabled = false;
    private boolean myObtainProcessorsFromClasspath = true;
    private String myProcessorPath = "";
    private final Set<String> myProcessors = new THashSet(1);
    private final Map<String, String> myProcessorOptions = new THashMap(1);
    private String myGeneratedProductionDirectoryName = "generated";
    private String myGeneratedTestsDirectoryName = "generated_tests";
    private boolean myOutputRelativeToContentRoot = false;
    private final Set<String> myModuleNames = new THashSet(1);

    public ProcessorConfigProfileImpl(String name) {
        this.myName = name;
    }

    public ProcessorConfigProfileImpl(ProcessorConfigProfile profile) {
        this.initFrom(profile);
    }

    @Override
    public final void initFrom(ProcessorConfigProfile other) {
        this.myName = other.getName();
        this.myEnabled = other.isEnabled();
        this.myObtainProcessorsFromClasspath = other.isObtainProcessorsFromClasspath();
        this.myProcessorPath = other.getProcessorPath();
        this.myProcessors.clear();
        this.myProcessors.addAll(other.getProcessors());
        this.myProcessorOptions.clear();
        this.myProcessorOptions.putAll(other.getProcessorOptions());
        this.myGeneratedProductionDirectoryName = other.getGeneratedSourcesDirectoryName(false);
        this.myGeneratedTestsDirectoryName = other.getGeneratedSourcesDirectoryName(true);
        this.myOutputRelativeToContentRoot = other.isOutputRelativeToContentRoot();
        this.myModuleNames.clear();
        this.myModuleNames.addAll(other.getModuleNames());
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public void setName(String name) {
        this.myName = name;
    }

    @Override
    public boolean isEnabled() {
        return this.myEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    @Override
    @NotNull
    public String getProcessorPath() {
        String string = this.myProcessorPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/compiler/ProcessorConfigProfileImpl", "getProcessorPath"));
        }
        return string;
    }

    @Override
    public void setProcessorPath(@Nullable String processorPath) {
        this.myProcessorPath = processorPath != null ? processorPath : "";
    }

    @Override
    public boolean isObtainProcessorsFromClasspath() {
        return this.myObtainProcessorsFromClasspath;
    }

    @Override
    public void setObtainProcessorsFromClasspath(boolean value) {
        this.myObtainProcessorsFromClasspath = value;
    }

    @Override
    @NotNull
    public String getGeneratedSourcesDirectoryName(boolean forTests) {
        String string = forTests ? this.myGeneratedTestsDirectoryName : this.myGeneratedProductionDirectoryName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/compiler/ProcessorConfigProfileImpl", "getGeneratedSourcesDirectoryName"));
        }
        return string;
    }

    @Override
    public void setGeneratedSourcesDirectoryName(@Nullable String name, boolean forTests) {
        if (forTests) {
            this.myGeneratedTestsDirectoryName = name != null ? name.trim() : "generated_tests";
        } else {
            this.myGeneratedProductionDirectoryName = name != null ? name.trim() : "generated";
        }
    }

    @Override
    public boolean isOutputRelativeToContentRoot() {
        return this.myOutputRelativeToContentRoot;
    }

    @Override
    public void setOutputRelativeToContentRoot(boolean relativeToContent) {
        this.myOutputRelativeToContentRoot = relativeToContent;
    }

    @Override
    @NotNull
    public Set<String> getModuleNames() {
        Set<String> set = this.myModuleNames;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/compiler/ProcessorConfigProfileImpl", "getModuleNames"));
        }
        return set;
    }

    @Override
    public boolean addModuleName(String name) {
        return this.myModuleNames.add(name);
    }

    @Override
    public boolean addModuleNames(Collection<String> names) {
        return this.myModuleNames.addAll(names);
    }

    @Override
    public boolean removeModuleName(String name) {
        return this.myModuleNames.remove(name);
    }

    @Override
    public boolean removeModuleNames(Collection<String> names) {
        return this.myModuleNames.removeAll(names);
    }

    @Override
    public void clearModuleNames() {
        this.myModuleNames.clear();
    }

    @Override
    public void clearProcessors() {
        this.myProcessors.clear();
    }

    @Override
    public boolean addProcessor(String processor) {
        return this.myProcessors.add(processor);
    }

    @Override
    public boolean removeProcessor(String processor) {
        return this.myProcessors.remove(processor);
    }

    @Override
    @NotNull
    public Set<String> getProcessors() {
        Set<String> set = Collections.unmodifiableSet(this.myProcessors);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/compiler/ProcessorConfigProfileImpl", "getProcessors"));
        }
        return set;
    }

    @Override
    @NotNull
    public Map<String, String> getProcessorOptions() {
        Map<String, String> map = Collections.unmodifiableMap(this.myProcessorOptions);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/compiler/ProcessorConfigProfileImpl", "getProcessorOptions"));
        }
        return map;
    }

    @Override
    public String setOption(String key, String value) {
        return this.myProcessorOptions.put(key, value);
    }

    @Override
    @Nullable
    public String getOption(String key) {
        return this.myProcessorOptions.get(key);
    }

    @Override
    public void clearProcessorOptions() {
        this.myProcessorOptions.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessorConfigProfileImpl profile = (ProcessorConfigProfileImpl)o;
        if (this.myEnabled != profile.myEnabled) {
            return false;
        }
        if (this.myObtainProcessorsFromClasspath != profile.myObtainProcessorsFromClasspath) {
            return false;
        }
        if (this.myGeneratedProductionDirectoryName != null ? !this.myGeneratedProductionDirectoryName.equals(profile.myGeneratedProductionDirectoryName) : profile.myGeneratedProductionDirectoryName != null) {
            return false;
        }
        if (this.myGeneratedTestsDirectoryName != null ? !this.myGeneratedTestsDirectoryName.equals(profile.myGeneratedTestsDirectoryName) : profile.myGeneratedTestsDirectoryName != null) {
            return false;
        }
        if (this.myOutputRelativeToContentRoot != profile.myOutputRelativeToContentRoot) {
            return false;
        }
        if (!((Object)this.myModuleNames).equals(profile.myModuleNames)) {
            return false;
        }
        if (!((Object)this.myProcessorOptions).equals(profile.myProcessorOptions)) {
            return false;
        }
        if (this.myProcessorPath != null ? !this.myProcessorPath.equals(profile.myProcessorPath) : profile.myProcessorPath != null) {
            return false;
        }
        if (!((Object)this.myProcessors).equals(profile.myProcessors)) {
            return false;
        }
        return this.myName.equals(profile.myName);
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + (this.myEnabled ? 1 : 0);
        result = 31 * result + (this.myObtainProcessorsFromClasspath ? 1 : 0);
        result = 31 * result + (this.myProcessorPath != null ? this.myProcessorPath.hashCode() : 0);
        result = 31 * result + ((Object)this.myProcessors).hashCode();
        result = 31 * result + ((Object)this.myProcessorOptions).hashCode();
        result = 31 * result + (this.myGeneratedProductionDirectoryName != null ? this.myGeneratedProductionDirectoryName.hashCode() : 0);
        result = 31 * result + (this.myGeneratedTestsDirectoryName != null ? this.myGeneratedTestsDirectoryName.hashCode() : 0);
        result = 31 * result + (this.myOutputRelativeToContentRoot ? 1 : 0);
        result = 31 * result + ((Object)this.myModuleNames).hashCode();
        return result;
    }

    public String toString() {
        return this.myName;
    }
}

