/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.junit;

import com.intellij.rt.execution.junit.FileComparisonFailure;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import junit.framework.ComparisonFailure;

public class ComparisonFailureData {
    private static final String ASSERTION_CLASS_NAME = "java.lang.AssertionError";
    private static final String ASSERTION_FAILED_CLASS_NAME = "junit.framework.AssertionFailedError";
    private final String myExpected;
    private final String myActual;
    private final String myFilePath;
    private static Map EXPECTED = new HashMap();
    private static Map ACTUAL = new HashMap();
    static /* synthetic */ Class class$junit$framework$ComparisonFailure;
    static /* synthetic */ Class class$org$junit$ComparisonFailure;

    private static void init(Class exceptionClass) throws NoSuchFieldException {
        Field expectedField = exceptionClass.getDeclaredField("fExpected");
        expectedField.setAccessible(true);
        EXPECTED.put(exceptionClass, expectedField);
        Field actualField = exceptionClass.getDeclaredField("fActual");
        actualField.setAccessible(true);
        ACTUAL.put(exceptionClass, actualField);
    }

    public ComparisonFailureData(String expected, String actual) {
        this(expected, actual, null);
    }

    public ComparisonFailureData(String expected, String actual, String filePath) {
        this.myExpected = expected;
        this.myActual = actual;
        this.myFilePath = filePath;
    }

    public static void registerSMAttributes(ComparisonFailureData notification, String trace, String failureMessage, Map attrs, Throwable throwable) {
        if (notification != null) {
            int expectedIdx;
            attrs.put("expected", notification.getExpected());
            attrs.put("actual", notification.getActual());
            int failureIdx = trace.indexOf(failureMessage);
            attrs.put("details", failureIdx > -1 ? trace.substring(failureIdx + failureMessage.length()) : trace);
            String filePath = notification.getFilePath();
            if (filePath != null) {
                attrs.put("expectedFile", filePath);
            }
            String comparisonFailureMessage = (expectedIdx = trace.indexOf("expected")) > 0 ? trace.substring(0, expectedIdx) : "Comparison Failure: ";
            attrs.put("message", comparisonFailureMessage);
        } else {
            attrs.put("details", trace);
            Throwable throwableCause = null;
            try {
                throwableCause = throwable.getCause();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            if (!ComparisonFailureData.isAssertionError(throwable.getClass()) && !ComparisonFailureData.isAssertionError(throwableCause != null ? throwableCause.getClass() : null)) {
                attrs.put("error", "true");
            }
            attrs.put("message", failureMessage != null ? failureMessage : "");
        }
    }

    public static boolean isAssertionError(Class throwableClass) {
        if (throwableClass == null) {
            return false;
        }
        String throwableClassName = throwableClass.getName();
        if (throwableClassName.equals(ASSERTION_CLASS_NAME) || throwableClassName.equals(ASSERTION_FAILED_CLASS_NAME)) {
            return true;
        }
        return ComparisonFailureData.isAssertionError(throwableClass.getSuperclass());
    }

    public String getFilePath() {
        return this.myFilePath;
    }

    public String getExpected() {
        return this.myExpected;
    }

    public String getActual() {
        return this.myActual;
    }

    public static ComparisonFailureData create(Throwable assertion) {
        if (assertion instanceof FileComparisonFailure) {
            FileComparisonFailure comparisonFailure = (FileComparisonFailure)((Object)assertion);
            return new ComparisonFailureData(comparisonFailure.getExpected(), comparisonFailure.getActual(), comparisonFailure.getFilePath());
        }
        try {
            return new ComparisonFailureData(ComparisonFailureData.getExpected(assertion), ComparisonFailureData.getActual(assertion));
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static String getActual(Throwable assertion) throws IllegalAccessException, NoSuchFieldException {
        return ComparisonFailureData.get(assertion, ACTUAL, "fActual");
    }

    public static String getExpected(Throwable assertion) throws IllegalAccessException, NoSuchFieldException {
        return ComparisonFailureData.get(assertion, EXPECTED, "fExpected");
    }

    private static String get(Throwable assertion, Map staticMap, String fieldName) throws IllegalAccessException, NoSuchFieldException {
        String actual;
        if (assertion instanceof ComparisonFailure) {
            actual = (String)((Field)staticMap.get(class$junit$framework$ComparisonFailure == null ? (class$junit$framework$ComparisonFailure = ComparisonFailureData.class$("junit.framework.ComparisonFailure")) : class$junit$framework$ComparisonFailure)).get(assertion);
        } else if (assertion instanceof org.junit.ComparisonFailure) {
            actual = (String)((Field)staticMap.get(class$org$junit$ComparisonFailure == null ? (class$org$junit$ComparisonFailure = ComparisonFailureData.class$("org.junit.ComparisonFailure")) : class$org$junit$ComparisonFailure)).get(assertion);
        } else {
            Field field = assertion.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            actual = (String)field.get(assertion);
        }
        return actual;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            ComparisonFailureData.init(class$junit$framework$ComparisonFailure == null ? (class$junit$framework$ComparisonFailure = ComparisonFailureData.class$("junit.framework.ComparisonFailure")) : class$junit$framework$ComparisonFailure);
            ComparisonFailureData.init(class$org$junit$ComparisonFailure == null ? (class$org$junit$ComparisonFailure = ComparisonFailureData.class$("org.junit.ComparisonFailure")) : class$org$junit$ComparisonFailure);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

