/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.updater;

import com.android.annotations.NonNull;
import com.android.sdklib.internal.repository.AddonsListFetcher;
import com.android.sdklib.internal.repository.DownloadCache;
import com.android.sdklib.internal.repository.ITask;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.NullTaskMonitor;
import com.android.sdklib.internal.repository.archives.Archive;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.sources.SdkAddonSource;
import com.android.sdklib.internal.repository.sources.SdkSource;
import com.android.sdklib.internal.repository.sources.SdkSourceCategory;
import com.android.sdklib.internal.repository.sources.SdkSources;
import com.android.sdklib.internal.repository.sources.SdkSysImgSource;
import com.android.sdklib.internal.repository.updater.UpdaterData;
import com.android.sdklib.repository.SdkAddonsListConstants;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PackageLoader {
    private final UpdaterData mUpdaterData;
    private final DownloadCache mOverrideCache;
    private int mStateFetchRemoteAddonsList;

    public PackageLoader(UpdaterData updaterData) {
        this.mUpdaterData = updaterData;
        this.mOverrideCache = null;
    }

    public PackageLoader(UpdaterData updaterData, DownloadCache cache) {
        this.mUpdaterData = updaterData;
        this.mOverrideCache = cache;
    }

    public UpdaterData getUpdaterData() {
        return this.mUpdaterData;
    }

    protected void runOnUiThread(@NonNull Runnable r) {
        r.run();
    }

    public void loadPackages(final boolean overrideExisting, final ISourceLoadedCallback sourceLoadedCallback) {
        try {
            if (this.mUpdaterData == null) {
                return;
            }
            this.mUpdaterData.getTaskFactory().start("Loading Sources", new ITask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run(ITaskMonitor monitor) {
                    monitor.setProgressMax(10);
                    Package[] localPkgs = PackageLoader.this.mUpdaterData.getInstalledPackages(monitor.createSubMonitor(1));
                    if (localPkgs == null) {
                        localPkgs = new Package[]{};
                    }
                    if (!sourceLoadedCallback.onUpdateSource(null, localPkgs)) {
                        return;
                    }
                    boolean forceHttp = PackageLoader.this.mUpdaterData.getSettingsController().getSettings().getForceHttp();
                    PackageLoader.this.loadRemoteAddonsList(monitor.createSubMonitor(1));
                    SdkSource[] sources = PackageLoader.this.mUpdaterData.getSources().getAllSources();
                    try {
                        if (sources != null && sources.length > 0) {
                            ITaskMonitor subMonitor = monitor.createSubMonitor(8);
                            subMonitor.setProgressMax(sources.length);
                            for (SdkSource source : sources) {
                                Package[] pkgs = source.getPackages();
                                if (pkgs == null || overrideExisting) {
                                    source.load(PackageLoader.this.getDownloadCache(), subMonitor.createSubMonitor(1), forceHttp);
                                    pkgs = source.getPackages();
                                }
                                if (pkgs == null || sourceLoadedCallback.onUpdateSource(source, pkgs)) continue;
                                return;
                            }
                        }
                    }
                    catch (Exception e) {
                        monitor.logError("Loading source failed: %1$s", e.toString());
                    }
                    finally {
                        monitor.setDescription("Done loading packages.", new Object[0]);
                    }
                }
            });
        }
        finally {
            sourceLoadedCallback.onLoadCompleted();
        }
    }

    public void loadPackagesWithInstallTask(final int installFlags, final IAutoInstallTask installTask) {
        this.loadPackages(false, new ISourceLoadedCallback(){
            List<Archive> mArchivesToInstall = new ArrayList<Archive>();
            Map<Package, File> mInstallPaths = new HashMap<Package, File>();

            @Override
            public boolean onUpdateSource(SdkSource source, Package[] packages) {
                if ((packages = installTask.filterLoadedSource(source, packages)) == null || packages.length == 0) {
                    return true;
                }
                block0: for (Package pkg : packages) {
                    if (pkg.isLocal()) {
                        Archive[] a;
                        if (!installTask.acceptPackage(pkg) || (a = pkg.getArchives()).length != 1 || !a[0].isCompatible()) continue;
                        this.mInstallPaths.put(pkg, new File(a[0].getLocalOsPath()));
                        continue;
                    }
                    if (!installTask.acceptPackage(pkg)) continue;
                    for (Archive archive : pkg.getArchives()) {
                        if (!archive.isCompatible()) continue;
                        this.mArchivesToInstall.add(archive);
                        continue block0;
                    }
                }
                return true;
            }

            @Override
            public void onLoadCompleted() {
                if (!this.mArchivesToInstall.isEmpty()) {
                    this.installArchives(this.mArchivesToInstall);
                }
                if (this.mInstallPaths == null) {
                    installTask.setResult(false, null);
                } else {
                    installTask.setResult(true, this.mInstallPaths);
                }
                installTask.taskCompleted();
            }

            private void installArchives(final List<Archive> archivesToInstall) {
                final ArrayList installedArchives = new ArrayList();
                PackageLoader.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        List<Archive> archives = PackageLoader.this.mUpdaterData.updateOrInstallAll_WithGUI(archivesToInstall, true, installFlags);
                        if (archives != null) {
                            installedArchives.addAll(archives);
                        }
                    }
                });
                if (installedArchives.isEmpty()) {
                    this.mInstallPaths = null;
                    return;
                }
                PackageLoader.this.mUpdaterData.getSdkManager().reloadSdk(PackageLoader.this.mUpdaterData.getSdkLog());
                PackageLoader.this.mUpdaterData.getLocalSdkParser().clearPackages();
                Package[] localPkgs = PackageLoader.this.mUpdaterData.getInstalledPackages(new NullTaskMonitor(PackageLoader.this.mUpdaterData.getSdkLog()));
                for (Archive installedArchive : installedArchives) {
                    Package pkg = installedArchive.getParentPackage();
                    for (Package localPkg : localPkgs) {
                        Archive[] localArchive;
                        if (localPkg.canBeUpdatedBy(pkg) != Package.UpdateInfo.NOT_UPDATE || (localArchive = localPkg.getArchives()).length != 1 || !localArchive[0].isCompatible()) continue;
                        this.mInstallPaths.put(localPkg, new File(localArchive[0].getLocalOsPath()));
                    }
                }
            }
        });
    }

    public void loadRemoteAddonsList(ITaskMonitor monitor) {
        if (this.mStateFetchRemoteAddonsList != 0) {
            return;
        }
        this.mUpdaterData.getTaskFactory().start("Load Add-ons List", monitor, new ITask(){

            @Override
            public void run(ITaskMonitor subMonitor) {
                PackageLoader.this.loadRemoteAddonsListInTask(subMonitor);
            }
        });
    }

    private void loadRemoteAddonsListInTask(ITaskMonitor monitor) {
        this.mStateFetchRemoteAddonsList = -1;
        String url = SdkAddonsListConstants.URL_ADDON_LIST;
        String baseUrl = System.getenv("SDK_TEST_BASE_URL");
        if (baseUrl != null) {
            if (baseUrl.length() > 0 && baseUrl.endsWith("/")) {
                if (url.startsWith("https://dl.google.com/android/repository/")) {
                    url = baseUrl + url.substring("https://dl.google.com/android/repository/".length());
                }
            } else {
                monitor.logError("Ignoring invalid SDK_TEST_BASE_URL: %1$s", baseUrl);
            }
        }
        if (this.mUpdaterData.getSettingsController().getSettings().getForceHttp()) {
            url = url.replaceAll("https://", "http://");
        }
        boolean fetch3rdParties = System.getenv("SDK_SKIP_3RD_PARTIES") == null;
        AddonsListFetcher fetcher = new AddonsListFetcher();
        AddonsListFetcher.Site[] sites = fetcher.fetch(url, this.getDownloadCache(), monitor);
        if (sites != null) {
            SdkSources sources = this.mUpdaterData.getSources();
            sources.removeAll(SdkSourceCategory.ADDONS_3RD_PARTY);
            if (fetch3rdParties) {
                block4: for (AddonsListFetcher.Site s : sites) {
                    switch (s.getType()) {
                        case ADDON_SITE: {
                            sources.add(SdkSourceCategory.ADDONS_3RD_PARTY, new SdkAddonSource(s.getUrl(), s.getUiName()));
                            continue block4;
                        }
                        case SYS_IMG_SITE: {
                            sources.add(SdkSourceCategory.ADDONS_3RD_PARTY, new SdkSysImgSource(s.getUrl(), s.getUiName()));
                        }
                    }
                }
            }
            sources.notifyChangeListeners();
            this.mStateFetchRemoteAddonsList = 1;
        }
        monitor.setDescription("Fetched Add-ons List successfully", new Object[0]);
    }

    private DownloadCache getDownloadCache() {
        return this.mOverrideCache != null ? this.mOverrideCache : this.mUpdaterData.getDownloadCache();
    }

    public static interface IAutoInstallTask {
        public Package[] filterLoadedSource(SdkSource var1, Package[] var2);

        public boolean acceptPackage(Package var1);

        public void setResult(boolean var1, Map<Package, File> var2);

        public void taskCompleted();
    }

    public static interface ISourceLoadedCallback {
        public boolean onUpdateSource(SdkSource var1, Package[] var2);

        public void onLoadCompleted();
    }
}

