/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.TaskExecutor;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Consumer;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;

public class ProcessWaitFor {
    private static final Logger LOG = Logger.getInstance("#com.intellij.execution.process.ProcessWaitFor");
    private final Future<?> myWaitForThreadFuture;
    private final BlockingQueue<Consumer<Integer>> myTerminationCallback = new ArrayBlockingQueue<Consumer<Integer>>(1);
    private static final MultiMap<Process, Consumer<Integer>> ourQueue = new MultiMap();

    public void detach() {
        this.myWaitForThreadFuture.cancel(true);
    }

    public ProcessWaitFor(final Process process, TaskExecutor executor) {
        this.myWaitForThreadFuture = executor.executeTask(new Runnable(){

            @Override
            public void run() {
                int exitCode = 0;
                try {
                    while (true) {
                        try {
                            exitCode = process.waitFor();
                        }
                        catch (InterruptedException e) {
                            LOG.debug(e);
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    try {
                        ((Consumer)ProcessWaitFor.this.myTerminationCallback.take()).consume(exitCode);
                    }
                    catch (InterruptedException e) {
                        LOG.info(e);
                    }
                }
            }
        });
    }

    public void setTerminationCallback(Consumer<Integer> r) {
        this.myTerminationCallback.offer(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processQueue() {
        MultiMap<Process, Consumer<Integer>> multiMap = ourQueue;
        synchronized (multiMap) {
            Iterator<Map.Entry<Process, Collection<Consumer<Integer>>>> iterator = ourQueue.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Process, Collection<Consumer<Integer>>> entry = iterator.next();
                try {
                    int value = entry.getKey().exitValue();
                    for (Consumer<Integer> callback : entry.getValue()) {
                        try {
                            callback.consume(value);
                        }
                        catch (Throwable t) {
                            LOG.error(t);
                        }
                    }
                    iterator.remove();
                }
                catch (IllegalThreadStateException illegalThreadStateException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void attach(@NotNull Process process, @NotNull Consumer<Integer> callback) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/ProcessWaitFor", "attach"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/execution/process/ProcessWaitFor", "attach"));
        }
        MultiMap<Process, Consumer<Integer>> multiMap = ourQueue;
        synchronized (multiMap) {
            ourQueue.putValue(process, callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void detach(@NotNull Process process, Consumer<Integer> callback) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/ProcessWaitFor", "detach"));
        }
        if (callback != null) {
            MultiMap<Process, Consumer<Integer>> multiMap = ourQueue;
            synchronized (multiMap) {
                ourQueue.remove(process, callback);
            }
        }
    }

    static {
        BaseOSProcessHandler.ExecutorServiceHolder.submit(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            ProcessWaitFor.processQueue();
                            TimeoutUtil.sleep(50L);
                        }
                    }
                    catch (ThreadDeath e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        LOG.error(t);
                        continue;
                    }
                    break;
                }
            }
        });
    }
}

