/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.fileTypes.impl;

import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.WildcardFileNameMatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.fileTypes.FileNameMatcherFactory;

public class FileNameMatcherFactoryImpl
extends FileNameMatcherFactory {
    @Override
    @NotNull
    public FileNameMatcher createMatcher(@NotNull String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "org/jetbrains/jps/model/fileTypes/impl/FileNameMatcherFactoryImpl", "createMatcher"));
        }
        if (pattern.startsWith("*.") && pattern.indexOf(42, 2) < 0 && pattern.indexOf(46, 2) < 0 && pattern.indexOf(63, 2) < 0) {
            ExtensionFileNameMatcher extensionFileNameMatcher = new ExtensionFileNameMatcher(pattern.substring(2).toLowerCase());
            if (extensionFileNameMatcher == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/fileTypes/impl/FileNameMatcherFactoryImpl", "createMatcher"));
            }
            return extensionFileNameMatcher;
        }
        if (pattern.contains("*") || pattern.contains("?")) {
            WildcardFileNameMatcher wildcardFileNameMatcher = new WildcardFileNameMatcher(pattern);
            if (wildcardFileNameMatcher == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/fileTypes/impl/FileNameMatcherFactoryImpl", "createMatcher"));
            }
            return wildcardFileNameMatcher;
        }
        ExactFileNameMatcher exactFileNameMatcher = new ExactFileNameMatcher(pattern);
        if (exactFileNameMatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/fileTypes/impl/FileNameMatcherFactoryImpl", "createMatcher"));
        }
        return exactFileNameMatcher;
    }
}

