/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex;

import com.intellij.execution.configurations.CommandLineTokenizer;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.flex.model.JpsFlexCompilerProjectExtension;
import com.intellij.flex.model.bc.BuildConfigurationNature;
import com.intellij.flex.model.bc.ComponentSet;
import com.intellij.flex.model.bc.JpsAirDesktopPackagingOptions;
import com.intellij.flex.model.bc.JpsAirPackagingOptions;
import com.intellij.flex.model.bc.JpsAndroidPackagingOptions;
import com.intellij.flex.model.bc.JpsFlexBuildConfiguration;
import com.intellij.flex.model.bc.LinkageType;
import com.intellij.flex.model.bc.OutputType;
import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.flex.model.sdk.JpsFlexSdkType;
import com.intellij.flex.model.sdk.JpsFlexmojosSdkProperties;
import com.intellij.flex.model.sdk.JpsFlexmojosSdkType;
import com.intellij.flex.model.sdk.RslUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Bitness;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SystemProperties;
import gnu.trove.THashMap;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.java.JdkVersionDetector;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.runConfiguration.JpsRunConfigurationType;
import org.jetbrains.jps.model.runConfiguration.JpsTypedRunConfiguration;
import org.jetbrains.jps.model.serialization.JpsModelSerializationDataService;
import org.jetbrains.jps.util.JpsPathUtil;

public class FlexCommonUtils {
    public static final String AIR_NAMESPACE_BASE = "http://ns.adobe.com/air/application/";
    public static final Pattern ERROR_PATTERN = Pattern.compile("(.*?)(\\(\\D.*\\))?(?:\\((-?\\d+)\\))?: ?(?:col: (-?\\d+):?)? (Warning|Error): (.*)");
    public static final String LOCALE_TOKEN = "{locale}";
    public static final Pattern XMX_PATTERN = Pattern.compile("(.* )?-Xmx([0-9]+)[mM]( .*)?");
    public static final String AIR_SDK_VERSION_PREFIX = "AIR SDK ";
    public static final String FLEX_UNIT_LAUNCHER = "____FlexUnitLauncher";
    public static final String SDK_TOOLS_ENCODING = "UTF-8";
    public static final String OUT_OF_MEMORY = "java.lang.OutOfMemoryError";
    public static final String JAVA_HEAP_SPACE = "Java heap space";
    public static final String COULD_NOT_CREATE_JVM = "Could not create the Java virtual machine";
    public static final String HTML_WRAPPER_TEMPLATE_FILE_NAME = "index.template.html";
    public static final String SWF_MACRO = "${swf}";
    public static final String TITLE_MACRO = "${title}";
    public static final String APPLICATION_MACRO = "${application}";
    public static final String BG_COLOR_MACRO = "${bgcolor}";
    public static final String WIDTH_MACRO = "${width}";
    public static final String HEIGHT_MACRO = "${height}";
    public static final String VERSION_MAJOR_MACRO = "${version_major}";
    public static final String VERSION_MINOR_MACRO = "${version_minor}";
    public static final String VERSION_REVISION_MACRO = "${version_revision}";
    public static final String TITLE_ATTR = "pageTitle";
    public static final String BG_COLOR_ATTR = "backgroundColor";
    public static final String WIDTH_ATTR = "width";
    public static final String HEIGHT_ATTR = "height";
    public static final String FLEXUNIT_4_TEST_RUNNER = "com.intellij.flexunit.runner.TestRunner4";
    public static final String FLEXUNIT_1_TEST_RUNNER = "com.intellij.flexunit.runner.TestRunner1";
    private static final String MODULE_PREFIX = "Module: ";
    private static final String BC_PREFIX = "\tBC: ";
    private static final String RUN_CONFIG_TYPE_PREFIX = "Run config type: ";
    private static final String RUN_CONFIG_NAME_PREFIX = "\tName: ";
    private static final String FORCED_DEBUG_STATUS = "\tForced debug status: ";
    private static final Logger LOG = Logger.getInstance((String)FlexCommonUtils.class.getName());
    public static final boolean KEEP_TEMP_FILES = Boolean.parseBoolean(System.getProperty("idea.keep.flex.temporary.files"));
    public static final Pattern AIR_VERSION_PATTERN = Pattern.compile("[0-9]+\\.[0-9]+(\\.[0-9]+)*");
    private static final Map<Pair<String, Long>, String> ourAdtJarPathAndTimestampToVersion = new THashMap();

    public static boolean isSourceFile(String fileName) {
        String ext = FileUtilRt.getExtension((String)fileName);
        return ext.equalsIgnoreCase("as") || ext.equalsIgnoreCase("mxml") || ext.equalsIgnoreCase("fxg");
    }

    public static boolean canHaveResourceFiles(BuildConfigurationNature nature) {
        return nature.isApp();
    }

    public static boolean isFlexUnitBC(JpsFlexBuildConfiguration bc) {
        return bc.isTempBCForCompilation() && bc.getMainClass().endsWith(FLEX_UNIT_LAUNCHER);
    }

    public static boolean isRuntimeStyleSheetBC(JpsFlexBuildConfiguration bc) {
        return bc.isTempBCForCompilation() && bc.getMainClass().toLowerCase().endsWith(".css");
    }

    public static boolean isRLMTemporaryBC(JpsFlexBuildConfiguration bc) {
        return bc.isTempBCForCompilation() && bc.getOutputType() == OutputType.RuntimeLoadedModule;
    }

    public static boolean canHaveRLMsAndRuntimeStylesheets(JpsFlexBuildConfiguration bc) {
        return FlexCommonUtils.canHaveRLMsAndRuntimeStylesheets(bc.getOutputType(), bc.getTargetPlatform());
    }

    public static boolean canHaveRLMsAndRuntimeStylesheets(OutputType outputType, TargetPlatform targetPlatform) {
        return outputType == OutputType.Application && targetPlatform != TargetPlatform.Mobile;
    }

    @Nullable
    public static String getBCSpecifier(JpsFlexBuildConfiguration bc) {
        if (!bc.isTempBCForCompilation()) {
            return null;
        }
        if (FlexCommonUtils.isFlexUnitBC(bc)) {
            return "flexunit";
        }
        if (FlexCommonUtils.isRLMTemporaryBC(bc)) {
            return "module " + StringUtil.getShortName((String)bc.getMainClass());
        }
        if (FlexCommonUtils.isRuntimeStyleSheetBC(bc)) {
            return PathUtilRt.getFileName((String)bc.getMainClass());
        }
        return StringUtil.getShortName((String)bc.getMainClass());
    }

    public static String getTempFlexConfigsDirPath() {
        return FlexCommonUtils.getTempFlexConfigsDirPath(FileUtil.getTempDirectory());
    }

    public static String getTempFlexConfigsDirPath(String tempDirPath) {
        return FileUtil.toSystemIndependentName((String)tempDirPath) + "/" + "IntelliJ_IDEA";
    }

    public static String getBuildTargetId(String moduleName, String bcName, @Nullable Boolean forcedDebugStatus) {
        return MODULE_PREFIX + moduleName + BC_PREFIX + bcName + FORCED_DEBUG_STATUS + forcedDebugStatus;
    }

    public static String getBuildTargetIdForRunConfig(String runConfigTypeId, String runConfigName) {
        return RUN_CONFIG_TYPE_PREFIX + runConfigTypeId + RUN_CONFIG_NAME_PREFIX + runConfigName;
    }

    @Nullable
    public static Pair<String, String> getRunConfigTypeIdAndNameByBuildTargetId(String buildTargetId) {
        if (buildTargetId.startsWith(RUN_CONFIG_TYPE_PREFIX)) {
            int index = buildTargetId.indexOf(RUN_CONFIG_NAME_PREFIX);
            assert (index > 0) : buildTargetId;
            return Pair.create((Object)buildTargetId.substring(RUN_CONFIG_TYPE_PREFIX.length(), index), (Object)buildTargetId.substring(index + RUN_CONFIG_NAME_PREFIX.length()));
        }
        return null;
    }

    @Nullable
    public static Trinity<String, String, Boolean> getModuleAndBCNameAndForcedDebugStatusByBuildTargetId(String buildTargetId) {
        if (buildTargetId.startsWith(MODULE_PREFIX)) {
            int bcIndex = buildTargetId.indexOf(BC_PREFIX);
            int forceDebugIndex = buildTargetId.indexOf(FORCED_DEBUG_STATUS);
            assert (bcIndex > 0 && forceDebugIndex > bcIndex) : buildTargetId;
            String moduleName = buildTargetId.substring(MODULE_PREFIX.length(), bcIndex);
            String bcName = buildTargetId.substring(bcIndex + BC_PREFIX.length(), forceDebugIndex);
            String forcedDebugText = buildTargetId.substring(forceDebugIndex + FORCED_DEBUG_STATUS.length());
            Boolean forcedDebugStatus = forcedDebugText.equalsIgnoreCase("true") ? Boolean.TRUE : (forcedDebugText.equalsIgnoreCase("false") ? Boolean.FALSE : null);
            return Trinity.create((Object)moduleName, (Object)bcName, (Object)forcedDebugStatus);
        }
        return null;
    }

    @Nullable
    public static <P extends JpsElement> JpsTypedRunConfiguration<P> findRunConfiguration(@NotNull JpsProject project, @NotNull JpsRunConfigurationType<P> runConfigType, @NotNull String runConfigName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/flex/FlexCommonUtils", "findRunConfiguration"));
        }
        if (runConfigType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfigType", "com/intellij/flex/FlexCommonUtils", "findRunConfiguration"));
        }
        if (runConfigName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfigName", "com/intellij/flex/FlexCommonUtils", "findRunConfiguration"));
        }
        for (JpsTypedRunConfiguration runConfig : project.getRunConfigurations(runConfigType)) {
            if (!runConfigName.equals(runConfig.getName())) continue;
            return runConfig;
        }
        return null;
    }

    public static List<String> getOptionValues(String commandLine, String ... optionAndAliases) {
        if (StringUtil.isEmpty((String)commandLine)) {
            return Collections.emptyList();
        }
        LinkedList<String> result = new LinkedList<String>();
        CommandLineTokenizer tokenizer = new CommandLineTokenizer(commandLine);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            for (String option : optionAndAliases) {
                String nextToken;
                if (token.startsWith("-" + option + "=") || token.startsWith("-" + option + "+=")) {
                    result.addAll(StringUtil.split((String)token.substring(token.indexOf("=") + 1), (String)","));
                    continue;
                }
                if (!token.equals("-" + option) || tokenizer.countTokens() <= 0 || tokenizer.countTokens() <= 0) continue;
                while (tokenizer.hasMoreTokens() && FlexCommonUtils.canBeCompilerOptionValue(nextToken = tokenizer.peekNextToken())) {
                    tokenizer.nextToken();
                    result.add(nextToken);
                }
            }
        }
        return result;
    }

    public static boolean canBeCompilerOptionValue(String text) {
        if (text.startsWith("-")) {
            return text.length() > 1 && Character.isDigit(text.charAt(1));
        }
        return !text.startsWith("+");
    }

    public static String removeOptions(String commandLine, String ... optionsToRemove) {
        if (commandLine.isEmpty()) {
            return commandLine;
        }
        StringBuilder buf = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(commandLine, " ", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            boolean remove = false;
            for (String option : optionsToRemove) {
                if (!token.startsWith("-" + option)) continue;
                remove = true;
                break;
            }
            if (remove) {
                String nextToken = null;
                block2: while (tokenizer.hasMoreElements()) {
                    nextToken = tokenizer.nextToken();
                    if (StringUtil.isEmptyOrSpaces((String)nextToken) || FlexCommonUtils.canBeCompilerOptionValue(nextToken)) continue;
                    for (String option : optionsToRemove) {
                        if (nextToken.startsWith("-" + option)) continue block2;
                    }
                }
                if (nextToken == null || FlexCommonUtils.canBeCompilerOptionValue(nextToken)) continue;
                buf.append(nextToken);
                continue;
            }
            buf.append(token);
        }
        return buf.toString();
    }

    public static String getFlexCompilerWorkDirPath(JpsProject project) {
        File dir = JpsModelSerializationDataService.getBaseDirectory((JpsProject)project);
        return dir == null ? "" : dir.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String findXMLElement(File file, String xmlElement) {
        String string;
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            string = FlexCommonUtils.findXMLElement(inputStream, xmlElement);
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        inputStream.close();
        return string;
    }

    @Nullable
    public static String findXMLElement(InputStream is, String xmlElement) {
        List elementNames = StringUtil.split((String)StringUtil.replace((String)xmlElement, (String)">", (String)""), (String)"<");
        if (elementNames.isEmpty()) {
            return null;
        }
        try {
            Element root = JDOMUtil.load((InputStream)is);
            if (!root.getName().equals(elementNames.get(0))) {
                return null;
            }
            Element element = root;
            int depth = 0;
            while (elementNames.size() > ++depth) {
                if ((element = element.getChild((String)elementNames.get(depth), element.getNamespace())) != null) continue;
                return null;
            }
            return element.getTextNormalize();
        }
        catch (JDOMException jDOMException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static String getMaximumTargetPlayer(String sdkHome) {
        return FlexCommonUtils.getMaximumVersion(FlexCommonUtils.getTargetPlayers(sdkHome));
    }

    @NotNull
    public static String getMaximumVersion(String[] versions) {
        String version = versions.length > 0 ? versions[0] : "";
        for (int i = 1; i < versions.length; ++i) {
            if (StringUtil.compareVersionNumbers((String)versions[i], (String)version) <= 0) continue;
            version = versions[i];
        }
        String string = version;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/FlexCommonUtils", "getMaximumVersion"));
        }
        return string;
    }

    public static String[] getTargetPlayers(String sdkHome) {
        final File playerFolder = new File(sdkHome + "/frameworks/libs/player");
        if (playerFolder.isDirectory()) {
            return playerFolder.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return new File(playerFolder, name + "/playerglobal.swc").isFile();
                }
            });
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public static void processStandardNamespaces(JpsFlexBuildConfiguration bc, PairConsumer<String, String> processor) {
        JpsSdk<?> sdk = bc.getSdk();
        if (bc.isPureAs() || sdk == null || sdk.getSdkType() != JpsFlexSdkType.INSTANCE) {
            return;
        }
        if (StringUtil.compareVersionNumbers((String)sdk.getVersionString(), (String)"4") < 0) {
            processor.consume((Object)"http://www.adobe.com/2006/mxml", (Object)"frameworks/mxml-manifest.xml");
        } else {
            processor.consume((Object)"http://ns.adobe.com/mxml/2009", (Object)"frameworks/mxml-2009-manifest.xml");
            if (bc.getTargetPlatform() == TargetPlatform.Mobile || bc.getDependencies().getComponentSet() == ComponentSet.SparkAndMx || bc.getDependencies().getComponentSet() == ComponentSet.SparkOnly) {
                processor.consume((Object)"library://ns.adobe.com/flex/spark", (Object)"frameworks/spark-manifest.xml");
            }
            if (bc.getTargetPlatform() != TargetPlatform.Mobile) {
                if (bc.getDependencies().getComponentSet() == ComponentSet.SparkAndMx || bc.getDependencies().getComponentSet() == ComponentSet.MxOnly) {
                    processor.consume((Object)"library://ns.adobe.com/flex/mx", (Object)"frameworks/mx-manifest.xml");
                }
                processor.consume((Object)"http://www.adobe.com/2006/mxml", (Object)"frameworks/mxml-manifest.xml");
            }
        }
    }

    public static LinkageType getDefaultFrameworkLinkage(String sdkVersion, BuildConfigurationNature nature) {
        return nature.isLib() ? LinkageType.External : (nature.pureAS || !nature.isWebPlatform() ? LinkageType.Merged : (StringUtil.compareVersionNumbers((String)sdkVersion, (String)"4") >= 0 && StringUtil.compareVersionNumbers((String)sdkVersion, (String)"4.8") < 0 ? LinkageType.RSL : LinkageType.Merged));
    }

    @Nullable
    public static LinkageType getSdkEntryLinkageType(String swcPath, JpsFlexBuildConfiguration bc) {
        JpsSdk<?> sdk = bc.getSdk();
        LOG.assertTrue(sdk != null);
        return FlexCommonUtils.getSdkEntryLinkageType(sdk.getHomePath(), swcPath, bc.getNature(), bc.getDependencies().getTargetPlayer(), bc.getDependencies().getComponentSet());
    }

    @Nullable
    public static LinkageType getSdkEntryLinkageType(String sdkHome, String swcPath, BuildConfigurationNature bcNature, String targetPlayer, ComponentSet componentSet) {
        boolean swcIncluded;
        LOG.assertTrue(!swcPath.endsWith("!/"), (Object)"plain local filesystem path is expected");
        if (swcPath.endsWith("/frameworks/libs/air/airglobal.swc")) {
            return bcNature.isWebPlatform() ? null : LinkageType.External;
        }
        if (swcPath.endsWith("/playerglobal.swc") && swcPath.contains("/frameworks/libs/player/")) {
            if (swcPath.endsWith("/frameworks/libs/player/" + targetPlayer + "/playerglobal.swc")) {
                return bcNature.isWebPlatform() ? LinkageType.External : null;
            }
            return null;
        }
        int lastSlashIndex = swcPath.lastIndexOf(47);
        if (lastSlashIndex <= 0 || lastSlashIndex == swcPath.length() - 1) {
            LOG.error("Unexpected Flex SDK root: " + swcPath);
        }
        String swcName = swcPath.substring(lastSlashIndex + 1).toLowerCase();
        String folderPath = swcPath.substring(0, lastSlashIndex);
        if (folderPath.endsWith("/frameworks/libs")) {
            swcIncluded = FlexCommonUtils.isSwcFromLibsFolderIncluded(bcNature, componentSet, swcName);
        } else if (folderPath.endsWith("/frameworks/libs/air")) {
            swcIncluded = FlexCommonUtils.isSwcFromAirFolderIncluded(bcNature, componentSet, swcName);
        } else if (folderPath.endsWith("/frameworks/libs/mobile")) {
            swcIncluded = FlexCommonUtils.isSwcFromMobileFolderIncluded(bcNature, swcName);
        } else if (folderPath.endsWith("/frameworks/libs/mx")) {
            swcIncluded = FlexCommonUtils.isSwcFromMxFolderIncluded(bcNature, componentSet, swcName);
        } else if (folderPath.contains("/frameworks/themes/")) {
            swcIncluded = false;
        } else {
            if (Utils.IS_TEST_MODE) {
                LOG.warn("Unknown Flex SDK root: " + swcPath);
            }
            swcIncluded = true;
        }
        if (!swcIncluded) {
            return null;
        }
        if (bcNature.isLib()) {
            return LinkageType.Default;
        }
        return RslUtil.canBeRsl(sdkHome, swcPath) ? LinkageType.Default : LinkageType.Merged;
    }

    private static boolean isSwcFromLibsFolderIncluded(BuildConfigurationNature bcNature, ComponentSet componentSet, String swcName) {
        if (swcName.equals("advancedgrids.swc")) {
            return !bcNature.isMobilePlatform() && !bcNature.pureAS && componentSet != ComponentSet.SparkOnly;
        }
        if (swcName.equals("authoringsupport.swc")) {
            return true;
        }
        if (swcName.equals("charts.swc")) {
            return !bcNature.pureAS;
        }
        if (swcName.equals("core.swc")) {
            return bcNature.pureAS;
        }
        if (swcName.equals("datavisualization.swc")) {
            return !bcNature.pureAS;
        }
        if (swcName.endsWith("flash-integration.swc")) {
            return !bcNature.pureAS;
        }
        if (swcName.equals("flex.swc")) {
            return bcNature.pureAS;
        }
        if (swcName.endsWith("framework.swc")) {
            return !bcNature.pureAS;
        }
        if (swcName.endsWith("osmf.swc")) {
            return true;
        }
        if (swcName.endsWith("rpc.swc")) {
            return !bcNature.pureAS;
        }
        if (swcName.endsWith("spark.swc")) {
            return !bcNature.pureAS && (bcNature.isMobilePlatform() || componentSet != ComponentSet.MxOnly);
        }
        if (swcName.endsWith("spark_dmv.swc")) {
            return !bcNature.pureAS && !bcNature.isMobilePlatform() && componentSet == ComponentSet.SparkAndMx;
        }
        if (swcName.endsWith("sparkskins.swc")) {
            return !bcNature.pureAS && !bcNature.isMobilePlatform() && componentSet != ComponentSet.MxOnly;
        }
        if (swcName.endsWith("textlayout.swc")) {
            return true;
        }
        if (swcName.endsWith("utilities.swc")) {
            return true;
        }
        if (swcName.endsWith("asc-support.swc")) {
            return true;
        }
        if (swcName.equals("apache.swc") || swcName.equals("experimental.swc")) {
            return !bcNature.pureAS;
        }
        if (swcName.equals("experimental_mobile.swc")) {
            return bcNature.isMobilePlatform() && !bcNature.pureAS;
        }
        if (swcName.equals("automation.swc") || swcName.equals("automation_agent.swc") || swcName.equals("automation_dmv.swc") || swcName.equals("automation_flashflexkit.swc") || swcName.equals("qtp.swc")) {
            return true;
        }
        LOG.warn("Unknown SWC in '<Flex SDK>/frameworks/libs' folder: " + swcName);
        return true;
    }

    private static boolean isSwcFromAirFolderIncluded(BuildConfigurationNature bcNature, ComponentSet componentSet, String swcName) {
        if (bcNature.isMobilePlatform()) {
            return swcName.equals("servicemonitor.swc");
        }
        if (bcNature.isDesktopPlatform()) {
            if (swcName.equals("airframework.swc")) {
                return !bcNature.pureAS;
            }
            if (swcName.equals("airspark.swc")) {
                return !bcNature.pureAS && componentSet != ComponentSet.MxOnly;
            }
            return true;
        }
        return false;
    }

    private static boolean isSwcFromMobileFolderIncluded(BuildConfigurationNature bcNature, String swcName) {
        return bcNature.isMobilePlatform() && !bcNature.pureAS;
    }

    private static boolean isSwcFromMxFolderIncluded(BuildConfigurationNature bcNature, ComponentSet componentSet, String swcName) {
        if (!swcName.equals("mx.swc")) {
            LOG.warn("Unknown SWC in '<Flex SDK>/frameworks/libs/mx' folder: " + swcName);
        }
        return !bcNature.isMobilePlatform() && !bcNature.pureAS && componentSet != ComponentSet.SparkOnly;
    }

    public static boolean checkDependencyType(OutputType bcOutputType, OutputType dependencyBCOutputType, LinkageType linkageType) {
        switch (dependencyBCOutputType) {
            case Application: 
            case RuntimeLoadedModule: {
                return bcOutputType != OutputType.Library && linkageType == LinkageType.LoadInRuntime;
            }
            case Library: {
                return ArrayUtil.contains((Object)linkageType, (Object[])LinkageType.getSwcLinkageValues());
            }
        }
        LOG.error((Object)dependencyBCOutputType);
        return false;
    }

    public static String getPathToBundledJar(String filename) {
        URL url = FlexCommonUtils.class.getResource("");
        String folder = "jar".equals(url.getProtocol()) ? "/plugins/flex/lib/" : "/flex/lib/";
        return FileUtil.toSystemDependentName((String)(PathManager.getHomePath() + folder + filename));
    }

    public static Collection<String> getFlexUnitSupportLibNames(BuildConfigurationNature nature, ComponentSet componentSet, String pathToFlexUnitMainClass) {
        boolean flexUnit4 = true;
        try {
            String content = FileUtil.loadFile((File)new File(pathToFlexUnitMainClass), (String)SDK_TOOLS_ENCODING);
            if (content.contains(FLEXUNIT_1_TEST_RUNNER)) {
                flexUnit4 = false;
            }
        }
        catch (IOException content) {
            // empty catch block
        }
        ArrayList<String> result = new ArrayList<String>(2);
        if (flexUnit4) {
            result.add("unittestingsupport_flexunit_4.swc");
        }
        if (nature.pureAS) {
            result.add("unittestingsupport_as.swc");
        } else if (nature.isMobilePlatform() || componentSet == ComponentSet.SparkOnly) {
            result.add("unittestingsupport_spark.swc");
        } else {
            result.add("unittestingsupport_mx.swc");
        }
        return result;
    }

    public static String getPathToMainClassFile(String mainClassFqn, JpsModule module) {
        if (StringUtil.isEmpty((String)mainClassFqn)) {
            return "";
        }
        String s = mainClassFqn.replace('.', '/');
        String[] classFileRelPaths = new String[]{"/" + s + ".mxml", "/" + s + ".as"};
        for (JpsModuleSourceRoot srcRoot : module.getSourceRoots()) {
            String srcRootPath = JpsPathUtil.urlToPath((String)srcRoot.getUrl());
            for (String classFileRelPath : classFileRelPaths) {
                String pathToMainClassFile = srcRootPath + classFileRelPath;
                if (!new File(pathToMainClassFile).isFile()) continue;
                return pathToMainClassFile;
            }
        }
        return "";
    }

    public static String replacePathMacros(@NotNull String text, @NotNull JpsModule module, @NotNull String sdkRootPath) {
        int startIndex;
        File projectDir;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/flex/FlexCommonUtils", "replacePathMacros"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/flex/FlexCommonUtils", "replacePathMacros"));
        }
        if (sdkRootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkRootPath", "com/intellij/flex/FlexCommonUtils", "replacePathMacros"));
        }
        String preResult = StringUtil.replace((String)text, (String)"${FLEX_SDK}", (String)sdkRootPath);
        File moduleDir = JpsModelSerializationDataService.getBaseDirectory((JpsModule)module);
        if (moduleDir != null) {
            preResult = StringUtil.replace((String)preResult, (String)"${MODULE_DIR}", (String)moduleDir.getPath());
        }
        if ((projectDir = JpsModelSerializationDataService.getBaseDirectory((JpsProject)module.getProject())) != null) {
            preResult = StringUtil.replace((String)preResult, (String)"${PROJECT_DIR}", (String)projectDir.getPath());
        }
        preResult = StringUtil.replace((String)preResult, (String)"${USER_HOME}", (String)SystemProperties.getUserHome());
        StringBuilder builder = new StringBuilder(preResult);
        int endIndex = 0;
        while ((startIndex = builder.indexOf("${", endIndex)) >= 0 && (endIndex = builder.indexOf("}", startIndex)) > startIndex) {
            String macroName = builder.substring(startIndex + 2, endIndex);
            String macroValue = JpsModelSerializationDataService.getPathVariableValue((JpsGlobal)module.getProject().getModel().getGlobal(), (String)macroName);
            if (macroValue == null || StringUtil.isEmptyOrSpaces((String)macroValue)) continue;
            builder.replace(startIndex, endIndex + 1, macroValue);
            endIndex = endIndex + macroValue.length() - (macroName.length() + 3);
        }
        return builder.toString();
    }

    public static String getFlexUnitLauncherExtension(BuildConfigurationNature nature) {
        return nature.pureAS ? ".as" : ".mxml";
    }

    public static boolean is64BitJava6(String javaHome) {
        JdkVersionDetector.JdkVersionInfo info = JdkVersionDetector.getInstance().detectJdkVersionInfo(javaHome);
        if (info != null) {
            boolean is64Bit = info.getBitness() == Bitness.x64;
            boolean isJava6 = info.getVersion().contains("version \"1.6.");
            return is64Bit && isJava6;
        }
        return false;
    }

    public static List<String> getCommandLineForSdkTool(@NotNull JpsProject project, @NotNull JpsSdk<?> sdk, @Nullable String additionalClasspath, @NotNull String mainClass) {
        String vmOptions;
        boolean isFlexmojos;
        String classpath;
        int heapSizeMbFromJvmConfig;
        String additionalJavaArgs;
        boolean customJavaHomeSet;
        String javaHome;
        block22: {
            JpsFlexmojosSdkProperties flexmojosSdkData;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/flex/FlexCommonUtils", "getCommandLineForSdkTool"));
            }
            if (sdk == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/flex/FlexCommonUtils", "getCommandLineForSdkTool"));
            }
            if (mainClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainClass", "com/intellij/flex/FlexCommonUtils", "getCommandLineForSdkTool"));
            }
            javaHome = SystemProperties.getJavaHome();
            customJavaHomeSet = false;
            additionalJavaArgs = null;
            heapSizeMbFromJvmConfig = 0;
            classpath = additionalClasspath;
            isFlexmojos = sdk.getSdkType() == JpsFlexmojosSdkType.INSTANCE;
            JpsFlexmojosSdkProperties jpsFlexmojosSdkProperties = flexmojosSdkData = isFlexmojos ? (JpsFlexmojosSdkProperties)((JpsSimpleElement)sdk.getSdkProperties()).getData() : null;
            if (isFlexmojos) {
                classpath = (StringUtil.isEmpty((String)classpath) ? "" : classpath + File.pathSeparator) + FileUtil.toSystemDependentName((String)StringUtil.join(flexmojosSdkData.getFlexCompilerClasspath(), (String)File.pathSeparator));
            } else {
                FileInputStream inputStream = null;
                try {
                    String classpathFromJvmConfig;
                    String javaArgs;
                    inputStream = new FileInputStream(FileUtil.toSystemDependentName((String)(sdk.getHomePath() + "/bin/jvm.config")));
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    String configuredJavaHome = properties.getProperty("java.home");
                    if (configuredJavaHome != null && configuredJavaHome.trim().length() > 0) {
                        javaHome = configuredJavaHome;
                        customJavaHomeSet = true;
                    }
                    if ((javaArgs = properties.getProperty("java.args")) != null && javaArgs.trim().length() > 0) {
                        additionalJavaArgs = javaArgs;
                        Matcher matcher = XMX_PATTERN.matcher(javaArgs);
                        if (matcher.matches()) {
                            try {
                                heapSizeMbFromJvmConfig = Integer.parseInt(matcher.group(2));
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                    if ((classpathFromJvmConfig = properties.getProperty("java.class.path")) != null && classpathFromJvmConfig.trim().length() > 0) {
                        classpath = (StringUtil.isEmpty((String)classpath) ? "" : classpath + File.pathSeparator) + classpathFromJvmConfig;
                    }
                }
                catch (IOException e) {
                    if (inputStream == null) break block22;
                    try {
                        inputStream.close();
                    }
                    catch (IOException configuredJavaHome) {
                        // empty catch block
                    }
                }
            }
        }
        String javaExecutable = FileUtil.toSystemDependentName((String)(javaHome + "/bin/java" + (SystemInfo.isWindows ? ".exe" : "")));
        String applicationHomeParam = isFlexmojos ? null : "-Dapplication.home=" + FileUtil.toSystemDependentName((String)sdk.getHomePath());
        String d32 = FlexCommonUtils.getD32IfNeed(customJavaHomeSet, javaHome);
        ArrayList<String> result = new ArrayList<String>();
        result.add(javaExecutable);
        if (StringUtil.isNotEmpty((String)d32)) {
            result.add(d32);
        }
        if (StringUtil.isNotEmpty((String)applicationHomeParam)) {
            result.add(applicationHomeParam);
        }
        if (StringUtil.isNotEmpty((String)additionalJavaArgs)) {
            result.addAll(StringUtil.split((String)additionalJavaArgs, (String)" "));
        }
        if (StringUtil.isNotEmpty((String)(vmOptions = JpsFlexCompilerProjectExtension.getInstance((JpsProject)project).VM_OPTIONS))) {
            result.addAll(StringUtil.split((String)vmOptions, (String)" "));
        }
        if (additionalJavaArgs == null || !additionalJavaArgs.contains("file.encoding")) {
            result.add("-Dfile.encoding=UTF-8");
        }
        result.add("-Djava.awt.headless=true");
        result.add("-Duser.language=en");
        result.add("-Duser.region=en");
        int heapSizeMb = JpsFlexCompilerProjectExtension.getInstance((JpsProject)project).HEAP_SIZE_MB;
        if (heapSizeMb > heapSizeMbFromJvmConfig) {
            result.add("-Xmx" + heapSizeMb + "m");
        }
        if (StringUtil.isNotEmpty((String)classpath)) {
            result.add("-classpath");
            result.add(classpath);
        }
        result.add(mainClass);
        return result;
    }

    public static String getD32IfNeed(boolean customJavaHomeSet, String javaHome) {
        return !customJavaHomeSet && SystemInfo.isMac && FlexCommonUtils.is64BitJava6(javaHome) ? "-d32" : null;
    }

    @Nullable
    public static String getPathRelativeToSourceRoot(JpsModule module, String _path) {
        String path = FileUtil.toSystemIndependentName((String)_path);
        for (JpsModuleSourceRoot srcRoot : module.getSourceRoots()) {
            String rootPath = JpsPathUtil.urlToPath((String)srcRoot.getUrl());
            if (path.equals(rootPath)) {
                return "";
            }
            if (!path.startsWith(rootPath + "/")) continue;
            return path.substring(rootPath.length() + 1);
        }
        return null;
    }

    @Nullable
    public static String getPathRelativeToContentRoot(JpsModule module, String path) {
        for (String rootUrl : module.getContentRootsList().getUrls()) {
            String rootPath = JpsPathUtil.urlToPath((String)rootUrl);
            if (path.equals(rootPath)) {
                return "";
            }
            if (!path.startsWith(rootPath + "/")) continue;
            return path.substring(rootPath.length() + 1);
        }
        return null;
    }

    public static String getWrapperFileName(JpsFlexBuildConfiguration bc) {
        return FileUtil.getNameWithoutExtension((String)PathUtilRt.getFileName((String)bc.getActualOutputFilePath())) + ".html";
    }

    public static String getGeneratedAirDescriptorName(JpsFlexBuildConfiguration bc, JpsAirPackagingOptions packagingOptions) {
        String suffix = packagingOptions instanceof JpsAirDesktopPackagingOptions ? "-descriptor.xml" : (packagingOptions instanceof JpsAndroidPackagingOptions ? "-android-descriptor.xml" : "-ios-descriptor.xml");
        return FileUtil.getNameWithoutExtension((String)PathUtilRt.getFileName((String)bc.getActualOutputFilePath())) + suffix;
    }

    public static String replace(String text, Map<String, String> replacementMap) {
        String[] from = new String[replacementMap.size()];
        String[] to = new String[replacementMap.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : replacementMap.entrySet()) {
            from[i] = entry.getKey();
            to[i] = entry.getValue();
            ++i;
        }
        return StringUtil.replace((String)text, (String[])from, (String[])to);
    }

    @Nullable
    public static String getVersionOfAirSdkIncludedInFlexSdk(String flexSdkHomePath) {
        File adtFile = new File(flexSdkHomePath + "/lib/adt.jar");
        if (!adtFile.isFile()) {
            return null;
        }
        String version = ourAdtJarPathAndTimestampToVersion.get(Pair.create((Object)adtFile.getPath(), (Object)adtFile.lastModified()));
        if (version != null) {
            return version;
        }
        try {
            final Ref versionRef = Ref.create();
            String javaExecutable = FileUtil.toSystemDependentName((String)(SystemProperties.getJavaHome() + "/bin/java" + (SystemInfo.isWindows ? ".exe" : "")));
            Process process = Runtime.getRuntime().exec(new String[]{javaExecutable, "-jar", adtFile.getPath(), "-version"});
            BaseOSProcessHandler handler = new BaseOSProcessHandler(process, "doesn't matter", Charset.defaultCharset());
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(ProcessEvent event, Key outputType) {
                    if (outputType != ProcessOutputTypes.SYSTEM) {
                        FlexCommonUtils.parseAirVersionFromAdtOutput(event.getText().trim(), (Ref<String>)versionRef);
                    }
                }
            });
            handler.startNotify();
            handler.waitFor(3000L);
            if (!handler.isProcessTerminated()) {
                handler.destroyProcess();
            }
            version = (String)versionRef.get();
            ourAdtJarPathAndTimestampToVersion.put((Pair<String, Long>)Pair.create((Object)adtFile.getPath(), (Object)adtFile.lastModified()), version);
            return version;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void parseAirVersionFromAdtOutput(String adtOutput, Ref<String> versionRef) {
        String prefix = "adt version \"";
        String suffix = "\"";
        if (adtOutput.startsWith("adt version \"") && adtOutput.endsWith("\"")) {
            adtOutput = adtOutput.substring("adt version \"".length(), adtOutput.length() - "\"".length());
        }
        if (AIR_VERSION_PATTERN.matcher(adtOutput).matches()) {
            versionRef.set((Object)adtOutput);
        }
    }

    @Nullable
    public static String getAirVersion(String sdkHomePath, String sdkVersion) {
        String version = sdkVersion != null && sdkVersion.startsWith(AIR_SDK_VERSION_PREFIX) ? sdkVersion.substring(AIR_SDK_VERSION_PREFIX.length()) : (sdkHomePath != null && sdkHomePath.endsWith(".pom") && new File(sdkHomePath).isFile() ? FlexCommonUtils.guessAirSdkVersionByFlexmojosSdkVersion(sdkVersion) : FlexCommonUtils.getVersionOfAirSdkIncludedInFlexSdk(sdkHomePath));
        if (version != null) {
            Trinity<String, String, String> majorMinorRevision = FlexCommonUtils.getMajorMinorRevisionVersion(version);
            return ((String)majorMinorRevision.third).isEmpty() || "0".equals(majorMinorRevision.third) ? (String)majorMinorRevision.first + "." + (String)majorMinorRevision.second : (String)majorMinorRevision.first + "." + (String)majorMinorRevision.second + "." + (String)majorMinorRevision.third;
        }
        return null;
    }

    private static String guessAirSdkVersionByFlexmojosSdkVersion(String sdkVersion) {
        if (StringUtil.compareVersionNumbers((String)sdkVersion, (String)"4") < 0) {
            if (StringUtil.compareVersionNumbers((String)sdkVersion, (String)"3.1") < 0) {
                return "1.0";
            }
            if (StringUtil.compareVersionNumbers((String)sdkVersion, (String)"3.2") < 0) {
                return "1.1";
            }
            if (StringUtil.compareVersionNumbers((String)sdkVersion, (String)"3.3") < 0) {
                return "1.5";
            }
            if (StringUtil.compareVersionNumbers((String)sdkVersion, (String)"3.4") < 0) {
                return "1.5";
            }
            if (StringUtil.compareVersionNumbers((String)sdkVersion, (String)"3.5") < 0) {
                return "1.5.2";
            }
            return "1.5.3";
        }
        if (StringUtil.compareVersionNumbers((String)sdkVersion, (String)"4.1") < 0) {
            return "1.5.3";
        }
        if (StringUtil.compareVersionNumbers((String)sdkVersion, (String)"4.5") < 0) {
            return "2.0";
        }
        if (StringUtil.compareVersionNumbers((String)sdkVersion, (String)"4.6") < 0) {
            return "2.6";
        }
        return "3.1";
    }

    public static String fixApplicationId(String appId) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < appId.length(); ++i) {
            char ch = appId.charAt(i);
            if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '-') && ch != '.') continue;
            builder.append(ch);
        }
        return builder.toString();
    }

    @Nullable
    public static String parseAirVersionFromDescriptorFile(String descriptorFilePath) {
        if (StringUtil.isEmpty((String)descriptorFilePath)) {
            return null;
        }
        try {
            Document document = JDOMUtil.loadDocument((File)new File(descriptorFilePath));
            Element rootElement = document.getRootElement();
            if (rootElement != null) {
                String localName = rootElement.getName();
                Namespace namespace = rootElement.getNamespace();
                if ("application".equals(localName) && namespace != null && namespace.getURI().startsWith(AIR_NAMESPACE_BASE)) {
                    return namespace.getURI().substring(AIR_NAMESPACE_BASE.length());
                }
            }
        }
        catch (JDOMException jDOMException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static String getSwfVersionForTargetPlayer(String targetPlayer) {
        if (StringUtil.compareVersionNumbers((String)targetPlayer, (String)"20") >= 0) {
            return "31";
        }
        if (StringUtil.compareVersionNumbers((String)targetPlayer, (String)"19") >= 0) {
            return "30";
        }
        if (StringUtil.compareVersionNumbers((String)targetPlayer, (String)"18") >= 0) {
            return "29";
        }
        if (StringUtil.compareVersionNumbers((String)targetPlayer, (String)"17") >= 0) {
            return "28";
        }
        if (StringUtil.compareVersionNumbers((String)targetPlayer, (String)"16") >= 0) {
            return "27";
        }
        if (StringUtil.compareVersionNumbers((String)targetPlayer, (String)"15") >= 0) {
            return "26";
        }
        if (StringUtil.compareVersionNumbers((String)targetPlayer, (String)"14") >= 0) {
            return "25";
        }
        if (StringUtil.compareVersionNumbers((String)targetPlayer, (String)"13") >= 0) {
            return "24";
        }
        if (StringUtil.compareVersionNumbers((String)targetPlayer, (String)"12") >= 0) {
            return "23";
        }
        if (StringUtil.compareVersionNumbers((String)targetPlayer, (String)"11.9") >= 0) {
            return "22";
        }
        if (StringUtil.compareVersionNumbers((String)targetPlayer, (String)"11.8") >= 0) {
            return "21";
        }
        if (StringUtil.compareVersionNumbers((String)targetPlayer, (String)"11.7") >= 0) {
            return "20";
        }
        if (StringUtil.compareVersionNumbers((String)targetPlayer, (String)"11.6") >= 0) {
            return "19";
        }
        if (StringUtil.compareVersionNumbers((String)targetPlayer, (String)"11.5") >= 0) {
            return "18";
        }
        if (StringUtil.compareVersionNumbers((String)targetPlayer, (String)"11.4") >= 0) {
            return "17";
        }
        if (StringUtil.compareVersionNumbers((String)targetPlayer, (String)"11.3") >= 0) {
            return "16";
        }
        if (StringUtil.compareVersionNumbers((String)targetPlayer, (String)"11.2") >= 0) {
            return "15";
        }
        if (StringUtil.compareVersionNumbers((String)targetPlayer, (String)"11.1") >= 0) {
            return "14";
        }
        if (StringUtil.compareVersionNumbers((String)targetPlayer, (String)"11") >= 0) {
            return "13";
        }
        if (StringUtil.compareVersionNumbers((String)targetPlayer, (String)"10.3") >= 0) {
            return "12";
        }
        if (StringUtil.compareVersionNumbers((String)targetPlayer, (String)"10.2") >= 0) {
            return "11";
        }
        if (StringUtil.compareVersionNumbers((String)targetPlayer, (String)"10.1") >= 0) {
            return "10";
        }
        return "9";
    }

    public static String getSwfVersionForAirVersion(String airVersion) {
        if (StringUtil.compareVersionNumbers((String)airVersion, (String)"20") >= 0) {
            return "31";
        }
        if (StringUtil.compareVersionNumbers((String)airVersion, (String)"19") >= 0) {
            return "30";
        }
        if (StringUtil.compareVersionNumbers((String)airVersion, (String)"18") >= 0) {
            return "29";
        }
        if (StringUtil.compareVersionNumbers((String)airVersion, (String)"17") >= 0) {
            return "28";
        }
        if (StringUtil.compareVersionNumbers((String)airVersion, (String)"16") >= 0) {
            return "27";
        }
        if (StringUtil.compareVersionNumbers((String)airVersion, (String)"15") >= 0) {
            return "26";
        }
        if (StringUtil.compareVersionNumbers((String)airVersion, (String)"14") >= 0) {
            return "25";
        }
        if (StringUtil.compareVersionNumbers((String)airVersion, (String)"13") >= 0) {
            return "24";
        }
        if (StringUtil.compareVersionNumbers((String)airVersion, (String)"4") >= 0) {
            return "23";
        }
        if (StringUtil.compareVersionNumbers((String)airVersion, (String)"3.9") >= 0) {
            return "22";
        }
        if (StringUtil.compareVersionNumbers((String)airVersion, (String)"3.8") >= 0) {
            return "21";
        }
        if (StringUtil.compareVersionNumbers((String)airVersion, (String)"3.7") >= 0) {
            return "20";
        }
        if (StringUtil.compareVersionNumbers((String)airVersion, (String)"3.6") >= 0) {
            return "19";
        }
        if (StringUtil.compareVersionNumbers((String)airVersion, (String)"3.5") >= 0) {
            return "18";
        }
        if (StringUtil.compareVersionNumbers((String)airVersion, (String)"3.4") >= 0) {
            return "17";
        }
        if (StringUtil.compareVersionNumbers((String)airVersion, (String)"3.3") >= 0) {
            return "16";
        }
        if (StringUtil.compareVersionNumbers((String)airVersion, (String)"3.2") >= 0) {
            return "15";
        }
        if (StringUtil.compareVersionNumbers((String)airVersion, (String)"3.1") >= 0) {
            return "14";
        }
        if (StringUtil.compareVersionNumbers((String)airVersion, (String)"3") >= 0) {
            return "13";
        }
        if (StringUtil.compareVersionNumbers((String)airVersion, (String)"2.7") >= 0) {
            return "12";
        }
        if (StringUtil.compareVersionNumbers((String)airVersion, (String)"2.6") >= 0) {
            return "11";
        }
        if (StringUtil.compareVersionNumbers((String)airVersion, (String)"1.5") >= 0) {
            return "10";
        }
        return "9";
    }

    public static String getSwfVersionForSdk_THE_WORST_WAY(String sdkVersion) {
        if (sdkVersion.startsWith(AIR_SDK_VERSION_PREFIX)) {
            return FlexCommonUtils.getSwfVersionForAirVersion(sdkVersion.substring(AIR_SDK_VERSION_PREFIX.length()));
        }
        if (StringUtil.compareVersionNumbers((String)sdkVersion, (String)"4.6") >= 0) {
            return "14";
        }
        if (StringUtil.compareVersionNumbers((String)sdkVersion, (String)"4.5") >= 0) {
            return "11";
        }
        assert (false) : sdkVersion;
        return null;
    }

    public static boolean containsASC20(String sdkHome) {
        return new File(sdkHome + "/lib/compiler.jar").isFile();
    }

    public static Pair<String, Integer> getSourcePathAndLineFromASC20Message(String message) {
        if (message == null) {
            return null;
        }
        int index = message.lastIndexOf(58);
        if (index <= 0) {
            return null;
        }
        String filePath = message.substring(0, index);
        String lineNumber = message.substring(index + 1);
        try {
            int line = Integer.parseInt(lineNumber);
            if (new File(filePath).isFile()) {
                return Pair.create((Object)FileUtil.toSystemIndependentName((String)filePath), (Object)line);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public static InputStreamReader createInputStreamReader(InputStream inputStream) {
        try {
            return new InputStreamReader(inputStream, SDK_TOOLS_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            return new InputStreamReader(inputStream);
        }
    }

    public static String fixSizeReportOption(String additionalOptions, String postfix) {
        List<String> values = FlexCommonUtils.getOptionValues(additionalOptions, "size-report");
        StringBuilder result = new StringBuilder(FlexCommonUtils.removeOptions(additionalOptions, "size-report"));
        if (values.size() == 1 && values.get(0).toLowerCase().endsWith(".xml")) {
            String path = values.get(0);
            result.append(" -size-report=");
            if (path.contains(" ")) {
                result.append("\"");
            }
            result.append(path.substring(0, path.length() - ".xml".length()));
            result.append("-").append(postfix);
            result.append(path.substring(path.length() - ".xml".length()));
            if (path.contains(" ")) {
                result.append("\"");
            }
        }
        return result.toString();
    }

    public static boolean isAirSdkWithoutFlex(@Nullable JpsSdk<?> sdk) {
        String version = sdk == null ? null : sdk.getVersionString();
        return version != null && version.startsWith(AIR_SDK_VERSION_PREFIX);
    }

    public static Trinity<String, String, String> getMajorMinorRevisionVersion(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/flex/FlexCommonUtils", "getMajorMinorRevisionVersion"));
        }
        int firstDotIndex = version.indexOf(46);
        if (firstDotIndex == -1) {
            return Trinity.create((Object)version, (Object)"0", (Object)"0");
        }
        String majorVersion = version.substring(0, firstDotIndex);
        int secondDotIndex = version.indexOf(46, firstDotIndex + 1);
        if (secondDotIndex == -1) {
            return Trinity.create((Object)majorVersion, (Object)version.substring(firstDotIndex + 1), (Object)"0");
        }
        String minorVersion = version.substring(firstDotIndex + 1, secondDotIndex);
        int thirdDotIndex = version.indexOf(46, secondDotIndex + 1);
        String revision = thirdDotIndex == -1 ? version.substring(secondDotIndex + 1) : version.substring(secondDotIndex + 1, thirdDotIndex);
        return Trinity.create((Object)majorVersion, (Object)minorVersion, (Object)revision);
    }

    public static void deleteTempFlexConfigFiles(String projectName) {
        if (KEEP_TEMP_FILES) {
            return;
        }
        final String hash1 = Integer.toHexString((SystemProperties.getUserName() + projectName).hashCode()).toUpperCase();
        File dir = new File(FlexCommonUtils.getTempFlexConfigsDirPath());
        if (!dir.isDirectory()) {
            return;
        }
        File[] filesToDelete = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.startsWith("idea-" + hash1) && name.endsWith(".xml");
            }
        });
        if (filesToDelete != null) {
            for (File file : filesToDelete) {
                FileUtil.delete((File)file);
            }
        }
    }
}

