/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.containers.EmptyIterable;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.TreeTraverser;
import java.util.Collections;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FilteredTraverser<T, Self extends FilteredTraverser<T, Self>>
extends TreeTraverser<T>
implements Iterable<T> {
    protected final Meta<T> myMeta;

    protected FilteredTraverser(@Nullable Meta<T> meta) {
        this.myMeta = meta == null ? FilteredTraverser.emptyMeta() : meta;
    }

    @NotNull
    public T getRoot() {
        Object t = this.myMeta.roots.iterator().next();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverser", "getRoot"));
        }
        return t;
    }

    @NotNull
    public Iterable<? extends T> getRoots() {
        Iterable iterable = this.myMeta.roots;
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverser", "getRoots"));
        }
        return iterable;
    }

    @Override
    public Iterator<T> iterator() {
        return this.rawIterable().iterator();
    }

    protected abstract Self newInstance(Meta<T> var1);

    @NotNull
    public JBIterable<T> rawIterable() {
        JBIterable<T> jBIterable = this.preOrderTraversal();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverser", "rawIterable"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<T> preOrderTraversal() {
        JBIterable<T> jBIterable = this.preOrderTraversal(this.getRoots()).filter(this.newResultFilter());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverser", "preOrderTraversal"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<T> postOrderTraversal() {
        JBIterable<T> jBIterable = this.postOrderTraversal(this.getRoots()).filter(this.newResultFilter());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverser", "postOrderTraversal"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<T> breadthFirstTraversal() {
        JBIterable<T> jBIterable = this.breadthFirstTraversal(this.getRoots()).filter(this.newResultFilter());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverser", "breadthFirstTraversal"));
        }
        return jBIterable;
    }

    @NotNull
    private Condition<? super T> newResultFilter() {
        if (!this.myMeta.skipExpanded) {
            Condition condition = this.myMeta.resultFilter;
            if (condition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverser", "newResultFilter"));
            }
            return condition;
        }
        Condition condition = Conditions.and2(Conditions.not(Conditions.or2(Conditions.oneOf(this.myMeta.roots), this.myMeta.expandFilter)), this.myMeta.resultFilter);
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverser", "newResultFilter"));
        }
        return condition;
    }

    @NotNull
    public Self reset() {
        Self Self2 = this.newInstance(FilteredTraverser.emptyMeta().exclude(this.myMeta.excludeFilter).withRoots(this.myMeta.roots));
        if (Self2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverser", "reset"));
        }
        return Self2;
    }

    @NotNull
    public Self withRoot(@NotNull T root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/util/containers/FilteredTraverser", "withRoot"));
        }
        Self Self2 = this.newInstance(this.myMeta.withRoots(Collections.singleton(root)));
        if (Self2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverser", "withRoot"));
        }
        return Self2;
    }

    @NotNull
    public Self withRoots(@NotNull Iterable<? extends T> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/FilteredTraverser", "withRoots"));
        }
        Self Self2 = this.newInstance(this.myMeta.withRoots(roots));
        if (Self2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverser", "withRoots"));
        }
        return Self2;
    }

    @NotNull
    public Self skipExpanded(boolean skip) {
        Self Self2 = this.newInstance(this.myMeta.skipExpanded(skip));
        if (Self2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverser", "skipExpanded"));
        }
        return Self2;
    }

    @NotNull
    public Self expand(@NotNull Condition<? super T> filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/containers/FilteredTraverser", "expand"));
        }
        Self Self2 = this.newInstance(this.myMeta.expand(filter));
        if (Self2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverser", "expand"));
        }
        return Self2;
    }

    @NotNull
    public Self expandOnly(@NotNull Condition<? super T> filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/containers/FilteredTraverser", "expandOnly"));
        }
        Self Self2 = this.newInstance(this.myMeta.expandOnly(filter));
        if (Self2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverser", "expandOnly"));
        }
        return Self2;
    }

    @NotNull
    public Self filter(@NotNull Condition<? super T> filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/containers/FilteredTraverser", "filter"));
        }
        Self Self2 = this.newInstance(this.myMeta.filter(filter));
        if (Self2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverser", "filter"));
        }
        return Self2;
    }

    @NotNull
    public <C> JBIterable<C> filter(@NotNull Class<C> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/util/containers/FilteredTraverser", "filter"));
        }
        JBIterable<C> jBIterable = this.rawIterable().filter(type);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverser", "filter"));
        }
        return jBIterable;
    }

    public Self exclude(@NotNull Condition<? super T> filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/containers/FilteredTraverser", "exclude"));
        }
        return this.newInstance(this.myMeta.exclude(filter));
    }

    @Override
    @NotNull
    public JBIterable<T> children(@NotNull T node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/util/containers/FilteredTraverser", "children"));
        }
        if (!(this.myMeta.expandFilter.value(node) || !this.myMeta.expandOnly && Conditions.oneOf(this.myMeta.roots).value(node))) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverser", "children"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.from(this.childrenImpl(node)).filter(Conditions.not(this.myMeta.excludeFilter));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverser", "children"));
        }
        return jBIterable;
    }

    protected abstract Iterable<? extends T> childrenImpl(T var1);

    public String toString() {
        return this.rawIterable().toString();
    }

    protected static <T> Meta<T> emptyMeta() {
        return new Meta(EmptyIterable.getInstance(), false, false, Conditions.alwaysTrue(), Conditions.alwaysTrue(), Conditions.alwaysFalse());
    }

    protected static class Meta<T> {
        final Iterable<? extends T> roots;
        final boolean skipExpanded;
        final boolean expandOnly;
        final Condition<? super T> expandFilter;
        final Condition<? super T> resultFilter;
        final Condition<? super T> excludeFilter;

        public Meta(@NotNull Iterable<? extends T> roots, boolean skipExpanded, boolean expandOnly, @NotNull Condition<? super T> expandFilter, @NotNull Condition<? super T> resultFilter, @NotNull Condition<? super T> excludeFilter) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/FilteredTraverser$Meta", "<init>"));
            }
            if (expandFilter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expandFilter", "com/intellij/util/containers/FilteredTraverser$Meta", "<init>"));
            }
            if (resultFilter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultFilter", "com/intellij/util/containers/FilteredTraverser$Meta", "<init>"));
            }
            if (excludeFilter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludeFilter", "com/intellij/util/containers/FilteredTraverser$Meta", "<init>"));
            }
            this.roots = roots;
            this.skipExpanded = skipExpanded;
            this.expandOnly = expandOnly;
            this.expandFilter = expandFilter;
            this.resultFilter = resultFilter;
            this.excludeFilter = excludeFilter;
        }

        public Meta<T> withRoots(@NotNull Iterable<? extends T> roots) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/FilteredTraverser$Meta", "withRoots"));
            }
            return new Meta<T>(roots, this.skipExpanded, this.expandOnly, this.expandFilter, this.resultFilter, this.excludeFilter);
        }

        public Meta<T> skipExpanded(boolean skip) {
            return new Meta<T>(this.roots, skip, this.expandOnly, this.expandFilter, this.resultFilter, this.excludeFilter);
        }

        public Meta<T> expand(@NotNull Condition<? super T> filter) {
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/containers/FilteredTraverser$Meta", "expand"));
            }
            return new Meta<T>(this.roots, this.skipExpanded, this.expandOnly, Conditions.and2(this.expandFilter, filter), this.resultFilter, this.excludeFilter);
        }

        public Meta<T> expandOnly(@NotNull Condition<? super T> filter) {
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/containers/FilteredTraverser$Meta", "expandOnly"));
            }
            return new Meta<T>(this.roots, this.skipExpanded, true, Conditions.and2(this.expandFilter, filter), this.resultFilter, this.excludeFilter);
        }

        public Meta<T> filter(@NotNull Condition<? super T> filter) {
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/containers/FilteredTraverser$Meta", "filter"));
            }
            return new Meta<T>(this.roots, this.skipExpanded, this.expandOnly, this.expandFilter, Conditions.and2(this.resultFilter, filter), this.excludeFilter);
        }

        public Meta<T> exclude(Condition<? super T> filter) {
            return new Meta<T>(this.roots, this.skipExpanded, this.expandOnly, this.expandFilter, this.resultFilter, Conditions.or2(this.excludeFilter, filter));
        }
    }
}

