/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import java.net.URL;

public class HtmlBuilder {
    @NonNull
    private final StringBuilder mStringBuilder;
    private String mTableDataExtra;
    private static final boolean USE_DD_LISTS = true;

    public HtmlBuilder(@NonNull StringBuilder stringBuilder) {
        this.mStringBuilder = stringBuilder;
    }

    public HtmlBuilder() {
        this.mStringBuilder = new StringBuilder(100);
    }

    public HtmlBuilder openHtmlBody() {
        this.addHtml("<html><body>");
        return this;
    }

    public HtmlBuilder closeHtmlBody() {
        this.addHtml("</body></html>");
        return this;
    }

    public HtmlBuilder addHtml(@NonNull String html) {
        this.mStringBuilder.append(html);
        return this;
    }

    public HtmlBuilder addNbsp() {
        this.mStringBuilder.append("&nbsp;");
        return this;
    }

    public HtmlBuilder addNbsps(int count) {
        for (int i = 0; i < count; ++i) {
            this.addNbsp();
        }
        return this;
    }

    public HtmlBuilder newline() {
        this.mStringBuilder.append("<BR/>\n");
        return this;
    }

    public HtmlBuilder newlineIfNecessary() {
        if (!SdkUtils.endsWith(this.mStringBuilder, "<BR/>\n")) {
            this.mStringBuilder.append("<BR/>\n");
        }
        return this;
    }

    public HtmlBuilder addLink(@Nullable String textBefore, @NonNull String linkText, @Nullable String textAfter, @NonNull String url) {
        if (textBefore != null) {
            this.add(textBefore);
        }
        this.addLink(linkText, url);
        if (textAfter != null) {
            this.add(textAfter);
        }
        return this;
    }

    public HtmlBuilder addLink(@NonNull String text, @NonNull String url) {
        char c;
        int begin;
        int length = text.length();
        for (begin = 0; begin < length && Character.isWhitespace(c = text.charAt(begin)); ++begin) {
            this.mStringBuilder.append(c);
        }
        this.mStringBuilder.append("<A HREF=\"");
        this.mStringBuilder.append(url);
        this.mStringBuilder.append("\">");
        XmlUtils.appendXmlTextValue(this.mStringBuilder, text.trim());
        this.mStringBuilder.append("</A>");
        for (int end = length - 1; end > begin; --end) {
            char c2 = text.charAt(begin);
            if (!Character.isWhitespace(c2)) continue;
            this.mStringBuilder.append(c2);
        }
        return this;
    }

    public HtmlBuilder add(@NonNull String text) {
        XmlUtils.appendXmlTextValue(this.mStringBuilder, text);
        return this;
    }

    @NonNull
    public String getHtml() {
        return this.mStringBuilder.toString();
    }

    public HtmlBuilder beginBold() {
        this.mStringBuilder.append("<B>");
        return this;
    }

    public HtmlBuilder endBold() {
        this.mStringBuilder.append("</B>");
        return this;
    }

    public HtmlBuilder addBold(String text) {
        this.beginBold();
        this.add(text);
        this.endBold();
        return this;
    }

    public HtmlBuilder beginDiv() {
        return this.beginDiv(null);
    }

    public HtmlBuilder beginDiv(@Nullable String cssStyle) {
        this.mStringBuilder.append("<div");
        if (cssStyle != null) {
            this.mStringBuilder.append(" style=\"");
            this.mStringBuilder.append(cssStyle);
            this.mStringBuilder.append("\"");
        }
        this.mStringBuilder.append('>');
        return this;
    }

    public HtmlBuilder endDiv() {
        this.mStringBuilder.append("</div>");
        return this;
    }

    public HtmlBuilder addHeading(@NonNull String text, @NonNull String fontColor) {
        this.mStringBuilder.append("<font style=\"font-weight:bold; color:").append(fontColor).append(";\">");
        this.add(text);
        this.mStringBuilder.append("</font>");
        return this;
    }

    public HtmlBuilder beginList() {
        this.mStringBuilder.append("<DL>");
        return this;
    }

    public HtmlBuilder endList() {
        this.mStringBuilder.append("\n</DL>");
        return this;
    }

    public HtmlBuilder listItem() {
        this.mStringBuilder.append("\n<DD>");
        this.mStringBuilder.append("-&NBSP;");
        return this;
    }

    public HtmlBuilder addImage(URL url, @Nullable String altText) {
        String link = "";
        try {
            link = url.toURI().toURL().toExternalForm();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.mStringBuilder.append("<img src='");
        this.mStringBuilder.append(link);
        this.mStringBuilder.append("'");
        if (altText != null) {
            this.mStringBuilder.append(" alt=\"");
            this.mStringBuilder.append(altText);
            this.mStringBuilder.append("\"");
        }
        this.mStringBuilder.append(" />");
        return this;
    }

    public HtmlBuilder addIcon(@Nullable String src) {
        if (src != null) {
            this.mStringBuilder.append("<img src='");
            this.mStringBuilder.append(src);
            this.mStringBuilder.append("' width=16 height=16 border=0 />");
        }
        return this;
    }

    public HtmlBuilder beginTable(@Nullable String tdExtra) {
        this.mStringBuilder.append("<table>");
        this.mTableDataExtra = tdExtra;
        return this;
    }

    public HtmlBuilder beginTable() {
        return this.beginTable(null);
    }

    public HtmlBuilder endTable() {
        this.mStringBuilder.append("</table>");
        return this;
    }

    public HtmlBuilder beginTableRow() {
        this.mStringBuilder.append("<tr>");
        return this;
    }

    public HtmlBuilder endTableRow() {
        this.mStringBuilder.append("</tr>");
        return this;
    }

    public HtmlBuilder addTableRow(boolean isHeader, String ... columns) {
        if (columns == null || columns.length == 0) {
            return this;
        }
        String tag = "t" + (isHeader ? (char)'h' : 'd');
        this.beginTableRow();
        for (String c : columns) {
            this.mStringBuilder.append('<');
            this.mStringBuilder.append(tag);
            if (this.mTableDataExtra != null) {
                this.mStringBuilder.append(' ');
                this.mStringBuilder.append(this.mTableDataExtra);
            }
            this.mStringBuilder.append('>');
            this.mStringBuilder.append(c);
            this.mStringBuilder.append("</");
            this.mStringBuilder.append(tag);
            this.mStringBuilder.append('>');
        }
        this.endTableRow();
        return this;
    }

    public HtmlBuilder addTableRow(String ... columns) {
        return this.addTableRow(false, columns);
    }

    @NonNull
    public StringBuilder getStringBuilder() {
        return this.mStringBuilder;
    }
}

