/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Functions;
import com.intellij.util.UnmodifiableIterator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.SingletonIterator;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TreeTraverser<T> {
    @NotNull
    public abstract JBIterable<T> children(@NotNull T var1);

    @NotNull
    public final Tracing<T> preOrderTraversal(final @Nullable T root) {
        Tracing tracing = new Tracing<T>(){

            @Override
            public TracingIt<T> iterator() {
                return new PreOrderIt(root);
            }
        };
        if (tracing == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraverser", "preOrderTraversal"));
        }
        return tracing;
    }

    @NotNull
    public final Tracing<T> preOrderTraversal(final @NotNull Iterable<? extends T> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraverser", "preOrderTraversal"));
        }
        Tracing tracing = new Tracing<T>(){

            @Override
            public TracingIt<T> iterator() {
                return new PreOrderIt(roots);
            }
        };
        if (tracing == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraverser", "preOrderTraversal"));
        }
        return tracing;
    }

    @NotNull
    public final JBIterable<T> postOrderTraversal(final @Nullable T root) {
        JBIterable jBIterable = new JBIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new PostOrderIt(root);
            }
        };
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraverser", "postOrderTraversal"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<T> postOrderTraversal(final @NotNull Iterable<? extends T> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraverser", "postOrderTraversal"));
        }
        JBIterable jBIterable = new JBIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new PostOrderIt(roots);
            }
        };
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraverser", "postOrderTraversal"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<T> breadthFirstTraversal(final @Nullable T root) {
        JBIterable jBIterable = new JBIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new BreadthFirstIterator(root);
            }
        };
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraverser", "breadthFirstTraversal"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<T> breadthFirstTraversal(final @NotNull Iterable<? extends T> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraverser", "breadthFirstTraversal"));
        }
        JBIterable jBIterable = new JBIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new BreadthFirstIterator(roots);
            }
        };
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraverser", "breadthFirstTraversal"));
        }
        return jBIterable;
    }

    @NotNull
    public final Tracing<T> tracingBreadthFirstTraversal(final @Nullable T root) {
        Tracing tracing = new Tracing<T>(){

            @Override
            public TracingIt<T> iterator() {
                return new TracingBreadthFirstIt(root);
            }
        };
        if (tracing == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraverser", "tracingBreadthFirstTraversal"));
        }
        return tracing;
    }

    @NotNull
    public final Tracing<T> tracingBreadthFirstTraversal(final @NotNull Iterable<? extends T> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraverser", "tracingBreadthFirstTraversal"));
        }
        Tracing tracing = new Tracing<T>(){

            @Override
            public TracingIt<T> iterator() {
                return new TracingBreadthFirstIt(roots);
            }
        };
        if (tracing == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraverser", "tracingBreadthFirstTraversal"));
        }
        return tracing;
    }

    private final class TracingBreadthFirstIt
    extends BfsIterator
    implements TracingIt<T> {
        final Map<T, T> paths;
        T cur;

        TracingBreadthFirstIt(T root) {
            super(root);
            this.paths = ContainerUtil.newTroveMap();
        }

        TracingBreadthFirstIt(Iterable<? extends T> roots) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraverser$TracingBreadthFirstIt", "<init>"));
            }
            super(roots);
            this.paths = ContainerUtil.newTroveMap();
        }

        @Override
        public T next() {
            Object result = this.queue.remove();
            for (Object t : TreeTraverser.this.children(result)) {
                if (this.paths.containsKey(t)) continue;
                this.queue.add(t);
                this.paths.put(t, result);
            }
            this.cur = result;
            return this.cur;
        }

        @Override
        public T parent() {
            return this.paths.get(this.cur);
        }

        @Override
        @NotNull
        public JBIterable<T> backtrace() {
            final Object first = this.cur;
            JBIterable jBIterable = new JBIterable<T>(){

                @Override
                public Iterator<T> iterator() {
                    return new It<T>(){
                        T cur;
                        {
                            this.cur = first;
                        }

                        @Override
                        public boolean hasNext() {
                            return this.cur != null;
                        }

                        @Override
                        public T next() {
                            Object result = this.cur;
                            this.cur = TracingBreadthFirstIt.this.paths.get(this.cur);
                            return result;
                        }
                    };
                }
            };
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraverser$TracingBreadthFirstIt", "backtrace"));
            }
            return jBIterable;
        }
    }

    private final class BreadthFirstIterator
    extends BfsIterator {
        BreadthFirstIterator(T root) {
            super(root);
        }

        BreadthFirstIterator(Iterable<? extends T> roots) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraverser$BreadthFirstIterator", "<init>"));
            }
            super(roots);
        }
    }

    private class BfsIterator
    extends It<T> {
        final Deque<T> queue;

        BfsIterator(T root) {
            this.queue = new ArrayDeque();
            if (root != null) {
                this.queue.add(root);
            }
        }

        BfsIterator(Iterable<? extends T> roots) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraverser$BfsIterator", "<init>"));
            }
            this.queue = new ArrayDeque();
            for (Object root : roots) {
                this.queue.add(root);
            }
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        public T peek() {
            return this.queue.element();
        }

        @Override
        public T next() {
            Object result = this.queue.remove();
            for (Object t : TreeTraverser.this.children(result)) {
                this.queue.add(t);
            }
            return result;
        }
    }

    private final class PostOrderIt
    extends DfsIt<T> {
        PostOrderIt(T root) {
            if (root != null) {
                this.stack.addLast(Pair.create(root, TreeTraverser.this.children(root).iterator()));
            }
        }

        PostOrderIt(Iterable<? extends T> roots) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraverser$PostOrderIt", "<init>"));
            }
            for (Object root : roots) {
                this.stack.addLast(Pair.create(root, TreeTraverser.this.children(root).iterator()));
            }
        }

        @Override
        public T next() {
            while (!this.stack.isEmpty()) {
                Pair top = (Pair)this.stack.getLast();
                if (((Iterator)top.second).hasNext()) {
                    Object child = ((Iterator)top.second).next();
                    this.stack.addLast(Pair.create(child, TreeTraverser.this.children(child).iterator()));
                    continue;
                }
                this.stack.removeLast();
                return top.first;
            }
            throw new NoSuchElementException();
        }
    }

    private final class PreOrderIt
    extends DfsIt<T> {
        int doneCount;

        PreOrderIt(T root) {
            if (root != null) {
                this.stack.addLast(Pair.create(null, new SingletonIterator(root)));
            }
        }

        PreOrderIt(Iterable<T> roots) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraverser$PreOrderIt", "<init>"));
            }
            Iterator iterator = roots.iterator();
            if (iterator.hasNext()) {
                this.stack.addLast(Pair.create(null, iterator));
            }
        }

        @Override
        public boolean hasNext() {
            return this.stack.size() > this.doneCount;
        }

        @Override
        public T next() {
            Pair top;
            while (true) {
                top = (Pair)this.stack.getLast();
                if (((Iterator)top.second).hasNext()) break;
                this.stack.removeLast();
                --this.doneCount;
            }
            Object result = ((Iterator)top.second).next();
            if (!((Iterator)top.second).hasNext()) {
                ++this.doneCount;
            }
            Iterator childItr = TreeTraverser.this.children(result).iterator();
            this.stack.addLast(Pair.create(result, childItr));
            if (!childItr.hasNext()) {
                ++this.doneCount;
            }
            return result;
        }
    }

    private static abstract class DfsIt<T>
    extends It<T>
    implements TracingIt<T> {
        final ArrayDeque<Pair<T, Iterator<T>>> stack = new ArrayDeque();

        private DfsIt() {
        }

        @Override
        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        @Override
        @Nullable
        public T parent() {
            Iterator<Pair<T, Iterator<T>>> it = this.stack.descendingIterator();
            it.next();
            return it.hasNext() ? (T)it.next().first : null;
        }

        @Override
        @NotNull
        public JBIterable<T> backtrace() {
            JBIterable<Object> jBIterable = new JBIterable<Pair<T, Iterator<T>>>(){

                @Override
                public Iterator<Pair<T, Iterator<T>>> iterator() {
                    Iterator iterator = DfsIt.this.stack.descendingIterator();
                    iterator.next();
                    return iterator;
                }
            }.transform(Functions.pairFirst()).filter(Condition.NOT_NULL);
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraverser$DfsIt", "backtrace"));
            }
            return jBIterable;
        }
    }

    private static abstract class It<T>
    extends UnmodifiableIterator<T> {
        It() {
            super(null);
        }
    }

    public static interface TracingIt<T>
    extends Iterator<T> {
        @Nullable
        public T parent();

        @NotNull
        public JBIterable<T> backtrace();
    }

    public static abstract class Tracing<T>
    extends JBIterable<T> {
        @Override
        public abstract TracingIt<T> iterator();
    }
}

