/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.java.compiler;

import com.intellij.util.xmlb.XmlSerializer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.EclipseCompilerOptions;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionSerializer;

public class JpsEclipseCompilerOptionsSerializer
extends JpsProjectExtensionSerializer {
    private final String myCompilerId;

    public JpsEclipseCompilerOptionsSerializer(String componentName, String compilerId) {
        super("compiler.xml", componentName);
        this.myCompilerId = compilerId;
    }

    @Override
    public void loadExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/serialization/java/compiler/JpsEclipseCompilerOptionsSerializer", "loadExtension"));
        }
        if (componentTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTag", "org/jetbrains/jps/model/serialization/java/compiler/JpsEclipseCompilerOptionsSerializer", "loadExtension"));
        }
        JpsJavaCompilerConfiguration configuration = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(project);
        EclipseCompilerOptions options = (EclipseCompilerOptions)XmlSerializer.deserialize((Element)componentTag, EclipseCompilerOptions.class);
        if (options == null) {
            options = new EclipseCompilerOptions();
        }
        configuration.setCompilerOptions(this.myCompilerId, options);
    }

    @Override
    public void loadExtensionWithDefaultSettings(@NotNull JpsProject project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/serialization/java/compiler/JpsEclipseCompilerOptionsSerializer", "loadExtensionWithDefaultSettings"));
        }
        JpsJavaCompilerConfiguration configuration = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(project);
        configuration.setCompilerOptions(this.myCompilerId, new EclipseCompilerOptions());
    }

    @Override
    public void saveExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/serialization/java/compiler/JpsEclipseCompilerOptionsSerializer", "saveExtension"));
        }
        if (componentTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTag", "org/jetbrains/jps/model/serialization/java/compiler/JpsEclipseCompilerOptionsSerializer", "saveExtension"));
        }
    }
}

