/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.testFrameworks;

import com.intellij.rt.execution.testFrameworks.ForkedDebuggerHelper;
import com.intellij.rt.execution.testFrameworks.ForkedVMWrapper;
import com.intellij.rt.execution.testFrameworks.ProcessBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public abstract class ForkedByModuleSplitter {
    protected final ForkedDebuggerHelper myForkedDebuggerHelper = new ForkedDebuggerHelper();
    protected final String myWorkingDirsPath;
    protected final String myForkMode;
    protected final PrintStream myOut;
    protected final PrintStream myErr;
    protected final List myNewArgs;
    protected String myDynamicClasspath;
    protected List myVMParameters;
    static /* synthetic */ Class class$com$intellij$rt$execution$CommandLineWrapper;

    public ForkedByModuleSplitter(String workingDirsPath, String forkMode, PrintStream out, PrintStream err, List newArgs) {
        this.myWorkingDirsPath = workingDirsPath;
        this.myForkMode = forkMode;
        this.myOut = out;
        this.myErr = err;
        this.myNewArgs = newArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startSplitting(String[] args, String configName, String commandLinePath) throws Exception {
        args = this.myForkedDebuggerHelper.excludeDebugPortFromArgs(args);
        this.myVMParameters = new ArrayList();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(commandLinePath));
        this.myDynamicClasspath = bufferedReader.readLine();
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                this.myVMParameters.add(line);
            }
        }
        finally {
            bufferedReader.close();
        }
        long time = System.currentTimeMillis();
        int result = this.startSplitting(args, configName);
        this.myForkedDebuggerHelper.closeDebugSocket();
        this.sendTime(time);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int startChildFork(List args, File workingDir, String classpath) throws IOException, InterruptedException {
        ArrayList vmParameters = new ArrayList(this.myVMParameters);
        this.myForkedDebuggerHelper.setupDebugger(vmParameters);
        File tempFile = File.createTempFile("fork", "test");
        tempFile.deleteOnExit();
        String testOutputPath = tempFile.getAbsolutePath();
        ProcessBuilder builder = new ProcessBuilder();
        builder.add(vmParameters);
        builder.add("-classpath");
        if (this.myDynamicClasspath.length() > 0) {
            try {
                File classpathFile = File.createTempFile("classpath", null);
                classpathFile.deleteOnExit();
                PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(classpathFile), "UTF-8"));
                try {
                    int idx = 0;
                    while (idx < classpath.length()) {
                        int endIdx = classpath.indexOf(File.pathSeparator, idx);
                        if (endIdx < 0) {
                            writer.println(classpath.substring(idx));
                            break;
                        }
                        writer.println(classpath.substring(idx, endIdx));
                        idx = endIdx + File.pathSeparator.length();
                    }
                }
                finally {
                    writer.close();
                }
                builder.add(this.myDynamicClasspath);
                builder.add((class$com$intellij$rt$execution$CommandLineWrapper == null ? (class$com$intellij$rt$execution$CommandLineWrapper = ForkedByModuleSplitter.class$("com.intellij.rt.execution.CommandLineWrapper")) : class$com$intellij$rt$execution$CommandLineWrapper).getName());
                builder.add(classpathFile.getAbsolutePath());
            }
            catch (Throwable e) {
                builder.add(classpath);
            }
        } else {
            builder.add(classpath);
        }
        builder.add(this.getStarterName());
        builder.add(testOutputPath);
        builder.add(args);
        builder.setWorkingDir(workingDir);
        Process exec = builder.createProcess();
        int result = exec.waitFor();
        ForkedVMWrapper.readWrapped(testOutputPath, this.myOut, this.myErr);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int splitPerModule() throws IOException {
        int result = 0;
        BufferedReader perDirReader = new BufferedReader(new FileReader(this.myWorkingDirsPath));
        try {
            String workingDir;
            String packageName = perDirReader.readLine();
            while ((workingDir = perDirReader.readLine()) != null) {
                String moduleName = perDirReader.readLine();
                String classpath = perDirReader.readLine();
                try {
                    ArrayList<String> classNames = new ArrayList<String>();
                    int classNamesSize = Integer.parseInt(perDirReader.readLine());
                    for (int i = 0; i < classNamesSize; ++i) {
                        String className = perDirReader.readLine();
                        if (className == null) {
                            System.err.println("Class name is expected. Working dir: " + workingDir);
                            result = -1;
                            break;
                        }
                        classNames.add(className);
                    }
                    int childResult = this.startPerModuleFork(moduleName, classNames, packageName, workingDir, classpath, result);
                    result = Math.min(childResult, result);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            perDirReader.close();
        }
        return result;
    }

    protected abstract int startSplitting(String[] var1, String var2) throws Exception;

    protected abstract int startPerModuleFork(String var1, List var2, String var3, String var4, String var5, int var6) throws Exception;

    protected abstract String getStarterName();

    protected void sendTime(long time) {
    }

    protected void sendTree(Object rootDescription) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

