/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.archives;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.internal.repository.archives.BitSize;
import com.android.sdklib.internal.repository.archives.HostOs;
import com.android.sdklib.repository.NoPreviewRevision;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ArchFilter {
    private static final String PROP_HOST_OS = "Archive.HostOs";
    private static final String PROP_HOST_BITS = "Archive.HostBits";
    private static final String PROP_JVM_BITS = "Archive.JvmBits";
    private static final String PROP_MIN_JVM_VERSION = "Archive.MinJvmVers";
    public static final String LEGACY_PROP_OS = "Archive.Os";
    public static final String LEGACY_PROP_ARCH = "Archive.Arch";
    private final HostOs mHostOs;
    private final BitSize mHostBits;
    private final BitSize mJvmBits;
    private final NoPreviewRevision mMinJvmVersion;

    public ArchFilter(@Nullable HostOs hostOs, @Nullable BitSize hostBits, @Nullable BitSize jvmBits, @Nullable NoPreviewRevision minJvmVersion) {
        this.mHostOs = hostOs;
        this.mHostBits = hostBits;
        this.mJvmBits = jvmBits;
        this.mMinJvmVersion = minJvmVersion;
    }

    public ArchFilter(@Nullable Properties props) {
        HostOs hostOs = null;
        BitSize hostBits = null;
        BitSize jvmBits = null;
        NoPreviewRevision minJvmVers = null;
        if (props != null) {
            hostOs = HostOs.fromXmlName(props.getProperty(PROP_HOST_OS));
            hostBits = BitSize.fromXmlName(props.getProperty(PROP_HOST_BITS));
            jvmBits = BitSize.fromXmlName(props.getProperty(PROP_JVM_BITS));
            try {
                minJvmVers = NoPreviewRevision.parseRevision(props.getProperty(PROP_MIN_JVM_VERSION));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (!props.containsKey(PROP_HOST_OS) && props.containsKey(LEGACY_PROP_OS)) {
                hostOs = HostOs.fromXmlName(props.getProperty(LEGACY_PROP_OS));
            }
            if (!props.containsKey(PROP_HOST_BITS) && !props.containsKey(PROP_HOST_BITS) && props.containsKey(LEGACY_PROP_ARCH)) {
                String v = props.getProperty(LEGACY_PROP_ARCH).toLowerCase();
                if (v.indexOf("x86_64") > 0) {
                    hostBits = jvmBits = BitSize._64;
                } else if (v.indexOf("x86") > 0) {
                    jvmBits = BitSize._32;
                }
            }
        }
        this.mHostOs = hostOs;
        this.mHostBits = hostBits;
        this.mJvmBits = jvmBits;
        this.mMinJvmVersion = minJvmVers;
    }

    @Nullable
    public HostOs getHostOS() {
        return this.mHostOs;
    }

    @Nullable
    public BitSize getHostBits() {
        return this.mHostBits;
    }

    @Nullable
    public BitSize getJvmBits() {
        return this.mJvmBits;
    }

    @Nullable
    public NoPreviewRevision getMinJvmVersion() {
        return this.mMinJvmVersion;
    }

    public boolean isCompatibleWith(@NonNull ArchFilter required) {
        if (this.mHostOs != null && required.mHostOs != null && !this.mHostOs.equals((Object)required.mHostOs)) {
            return false;
        }
        if (this.mHostBits != null && required.mHostBits != null && !this.mHostBits.equals((Object)required.mHostBits)) {
            return false;
        }
        if (this.mJvmBits != null && required.mJvmBits != null && !this.mJvmBits.equals((Object)required.mJvmBits)) {
            return false;
        }
        return this.mMinJvmVersion == null || required.mMinJvmVersion == null || this.mMinJvmVersion.compareTo(required.mMinJvmVersion) <= 0;
    }

    @NonNull
    public static ArchFilter getCurrent() {
        String os = System.getProperty("os.name");
        HostOs hostOS = null;
        if (os.startsWith("Mac")) {
            hostOS = HostOs.MACOSX;
        } else if (os.startsWith("Windows")) {
            hostOS = HostOs.WINDOWS;
        } else if (os.startsWith("Linux")) {
            hostOS = HostOs.LINUX;
        }
        String arch = System.getProperty("os.arch");
        BitSize jvmBits = arch.equalsIgnoreCase("x86_64") || arch.equalsIgnoreCase("ia64") || arch.equalsIgnoreCase("amd64") ? BitSize._64 : BitSize._32;
        BitSize hostBits = jvmBits;
        NoPreviewRevision minJvmVersion = null;
        String javav = System.getProperty("java.version");
        Pattern p = Pattern.compile("((\\d+)(\\.\\d+)?(\\.\\d+)?).*");
        Matcher m = p.matcher(javav);
        if (m.matches()) {
            minJvmVersion = NoPreviewRevision.parseRevision(m.group(1));
        }
        return new ArchFilter(hostOS, hostBits, jvmBits, minJvmVersion);
    }

    void saveProperties(@NonNull Properties props) {
        if (this.mHostOs != null) {
            props.setProperty(PROP_HOST_OS, this.mHostOs.getXmlName());
        }
        if (this.mHostBits != null) {
            props.setProperty(PROP_HOST_BITS, this.mHostBits.getXmlName());
        }
        if (this.mJvmBits != null) {
            props.setProperty(PROP_JVM_BITS, this.mJvmBits.getXmlName());
        }
        if (this.mMinJvmVersion != null) {
            props.setProperty(PROP_MIN_JVM_VERSION, this.mMinJvmVersion.toShortString());
        }
    }

    public String toString() {
        return "<ArchFilter mHostOs=" + (Object)((Object)this.mHostOs) + ", mHostBits=" + (Object)((Object)this.mHostBits) + ", mJvmBits=" + (Object)((Object)this.mJvmBits) + ", mMinJvmVersion=" + this.mMinJvmVersion + ">";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mHostOs == null ? 0 : this.mHostOs.hashCode());
        result = 31 * result + (this.mHostBits == null ? 0 : this.mHostBits.hashCode());
        result = 31 * result + (this.mJvmBits == null ? 0 : this.mJvmBits.hashCode());
        result = 31 * result + (this.mMinJvmVersion == null ? 0 : this.mMinJvmVersion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArchFilter other = (ArchFilter)obj;
        if (this.mHostBits != other.mHostBits) {
            return false;
        }
        if (this.mHostOs != other.mHostOs) {
            return false;
        }
        if (this.mJvmBits != other.mJvmBits) {
            return false;
        }
        return !(this.mMinJvmVersion == null ? other.mMinJvmVersion != null : !this.mMinJvmVersion.equals(other.mMinJvmVersion));
    }
}

