/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.packages;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.repository.packages.BrokenPackage;
import com.android.sdklib.internal.repository.packages.FullRevisionPackage;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.sources.SdkSource;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgDesc;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

public class BuildToolPackage
extends FullRevisionPackage {
    private static final String INSTALL_ID_BASE = "build-tools-";
    private final IPkgDesc mPkgDesc = PkgDesc.Builder.newBuildTool(this.getRevision()).setDescriptions(this).create();

    public BuildToolPackage(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        super(source, packageNode, nsUri, licenses);
    }

    public static Package create(File buildToolDir, Properties props) {
        String error = null;
        if (props == null) {
            error = String.format("Missing file %1$s in build-tool/%2$s", "source.properties", buildToolDir.getName());
        }
        FullRevision rev = null;
        if (error == null) {
            String revStr = BuildToolPackage.getProperty(props, "Pkg.Revision", null);
            if (revStr != null) {
                try {
                    rev = FullRevision.parseRevision(revStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (rev == null) {
                error = String.format("Missing revision property in %1$s", "source.properties");
            }
        }
        if (error == null) {
            if (!buildToolDir.isDirectory()) {
                error = String.format("build-tool/%1$s folder is missing", buildToolDir.getName());
            } else {
                File[] files = buildToolDir.listFiles();
                if (files == null || files.length == 0) {
                    error = String.format("build-tool/%1$s folder is empty", buildToolDir.getName());
                } else {
                    HashSet<String> names = new HashSet<String>();
                    for (File file : files) {
                        names.add(file.getName());
                    }
                    for (String name : new String[]{SdkConstants.FN_AAPT, SdkConstants.FN_AIDL, SdkConstants.FN_DX}) {
                        if (names.contains(name)) continue;
                        error = error == null ? String.format("build-tool/%1$s folder is missing ", buildToolDir.getName()) : error + ", ";
                        error = error + (String)name;
                    }
                }
            }
        }
        if (error == null && rev != null) {
            BuildToolPackage pkg = new BuildToolPackage(null, props, 0, null, null, null, buildToolDir.getAbsolutePath());
            if (pkg.hasCompatibleArchive()) {
                return pkg;
            }
            error = "Package is not compatible with current OS";
        }
        StringBuilder sb = new StringBuilder("Broken Build-Tools Package");
        if (rev != null) {
            sb.append(String.format(", revision %1$s", rev.toShortString()));
        }
        String shortDesc = sb.toString();
        if (error != null) {
            sb.append('\n').append(error);
        }
        String longDesc = sb.toString();
        IPkgDesc desc = PkgDesc.Builder.newBuildTool(rev != null ? rev : new FullRevision(0)).setDescriptionShort(shortDesc).create();
        return new BrokenPackage(props, shortDesc, longDesc, 0, 0, buildToolDir.getAbsolutePath(), desc);
    }

    protected BuildToolPackage(SdkSource source, Properties props, int revision, String license, String description, String descUrl, String archiveOsPath) {
        super(source, props, revision, license, description, descUrl, archiveOsPath);
    }

    @Override
    @NonNull
    public IPkgDesc getPkgDesc() {
        return this.mPkgDesc;
    }

    @Override
    public String installId() {
        return INSTALL_ID_BASE + this.getRevision().toString().replace(' ', '_');
    }

    @Override
    public String getListDescription() {
        String ld = this.getListDisplay();
        if (!ld.isEmpty()) {
            return String.format("%1$s%2$s", ld, this.isObsolete() ? " (Obsolete)" : "");
        }
        return String.format("Android SDK Build-tools%1$s", this.isObsolete() ? " (Obsolete)" : "");
    }

    @Override
    public String getShortDescription() {
        String ld = this.getListDisplay();
        if (!ld.isEmpty()) {
            return String.format("%1$s, revision %2$s%3$s", ld, this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
        }
        return String.format("Android SDK Build-tools, revision %1$s%2$s", this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
    }

    @Override
    public String getLongDescription() {
        String s = this.getDescription();
        if (s == null || s.length() == 0) {
            s = this.getShortDescription();
        }
        if (s.indexOf("revision") == -1) {
            s = s + String.format("\nRevision %1$s%2$s", this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
        }
        return s;
    }

    @Override
    public File getInstallFolder(String osSdkRoot, SdkManager sdkManager) {
        File folder = new File(osSdkRoot, "build-tools");
        folder = new File(folder, this.getRevision().toString().replace(' ', '_'));
        return folder;
    }

    @Override
    public boolean sameItemAs(Package pkg) {
        return this.sameItemAs(pkg, FullRevision.PreviewComparison.COMPARE_TYPE);
    }

    @Override
    public boolean sameItemAs(Package pkg, FullRevision.PreviewComparison comparePreview) {
        if (pkg instanceof BuildToolPackage) {
            BuildToolPackage rhs = (BuildToolPackage)pkg;
            return rhs.getRevision().compareTo(this.getRevision(), comparePreview) == 0;
        }
        return false;
    }

    @Override
    protected String comparisonKey() {
        String s = super.comparisonKey();
        int pos = s.indexOf("|r:");
        assert (pos > 0);
        FullRevision rev = this.getRevision();
        String reverseSort = String.format("|rr:%1$04d.%2$04d.%3$04d.", 9999 - rev.getMajor(), 9999 - rev.getMinor(), 9999 - rev.getMicro());
        s = s.substring(0, pos) + reverseSort + s.substring(pos);
        return s;
    }
}

