/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.testFrameworks;

import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

class ForkedVMWrapper
extends DataOutputStream {
    public static final char DELIMITER = '\u0002';
    public static final byte[] ERROR = new byte[]{3};
    public static final byte[] OUTPUT = new byte[]{4};
    private FileOutputStream myOutputStream;
    private boolean myError;

    public ForkedVMWrapper(FileOutputStream outputStream, boolean error) throws FileNotFoundException {
        super(outputStream);
        this.myOutputStream = outputStream;
        this.myError = error;
    }

    public synchronized void write(int b) throws IOException {
        this.printPrefix();
        this.myOutputStream.write(b);
    }

    private void printPrefix() throws IOException {
        this.myOutputStream.write("/\u0002".getBytes());
        if (this.myError) {
            this.myOutputStream.write(ERROR);
        } else {
            this.myOutputStream.write(OUTPUT);
        }
    }

    public void write(byte[] b) throws IOException {
        this.printPrefix();
        this.myOutputStream.write(b);
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.printPrefix();
        this.myOutputStream.write(b, off, len);
    }

    public void close() throws IOException {
        this.myOutputStream.close();
    }

    public void flush() throws IOException {
        this.myOutputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readWrapped(String path, PrintStream out, PrintStream err) throws IOException {
        FileInputStream stream = new FileInputStream(path);
        try {
            boolean error = false;
            boolean afterSymbol = false;
            boolean afterDelimiter = false;
            while (stream.available() > 0) {
                char read = (char)stream.read();
                if (!afterSymbol && read == '/') {
                    afterSymbol = true;
                    continue;
                }
                if (afterSymbol) {
                    if (afterDelimiter) {
                        error = read == ERROR[0];
                        afterSymbol = false;
                        afterDelimiter = false;
                        continue;
                    }
                    if (read != '\u0002') {
                        if (error) {
                            err.write("/".getBytes());
                            err.write(read);
                        } else {
                            out.write("/".getBytes());
                            out.write(read);
                        }
                        afterSymbol = false;
                        afterDelimiter = false;
                        continue;
                    }
                    afterDelimiter = true;
                    continue;
                }
                if (error) {
                    err.write(read);
                    continue;
                }
                out.write(read);
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }
}

