/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gant;

import com.intellij.openapi.diagnostic.CompositeLogger;
import com.intellij.openapi.diagnostic.DefaultLogger;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.build.Standalone;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.cmdline.JpsModelLoader;
import org.jetbrains.jps.gant.BuildInfoPrinter;
import org.jetbrains.jps.gant.DefaultBuildInfoPrinter;
import org.jetbrains.jps.gant.Log4jFileLoggerFactory;
import org.jetbrains.jps.incremental.MessageHandler;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.BuilderStatisticsMessage;
import org.jetbrains.jps.incremental.messages.BuildingTargetProgressMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;
import org.jetbrains.jps.model.java.JpsJavaDependenciesEnumerator;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;

public class JpsGantProjectBuilder {
    private final Project myProject;
    private final JpsModel myModel;
    private boolean myCompressJars;
    private boolean myBuildIncrementally;
    private File myDataStorageRoot;
    private JpsModelLoader myModelLoader;
    private boolean myDryRun;
    private BuildInfoPrinter myBuildInfoPrinter = new DefaultBuildInfoPrinter();
    private Set<String> myCompiledModules = new HashSet<String>();
    private Set<String> myCompiledModuleTests = new HashSet<String>();
    private boolean myStatisticsReported;
    private Logger.Factory myFileLoggerFactory;

    public JpsGantProjectBuilder(Project project, JpsModel model) {
        this.myProject = project;
        this.myModel = model;
        this.myModelLoader = new JpsModelLoader(){

            @Override
            public JpsModel loadModel() {
                return JpsGantProjectBuilder.this.myModel;
            }
        };
    }

    public void setDryRun(boolean dryRun) {
        this.myDryRun = dryRun;
    }

    public void setTargetFolder(String targetFolder) {
        String url = "file://" + FileUtil.toSystemIndependentName((String)targetFolder);
        JpsJavaExtensionService.getInstance().getOrCreateProjectExtension(this.myModel.getProject()).setOutputUrl(url);
        this.exportModuleOutputProperties();
    }

    public boolean isCompressJars() {
        return this.myCompressJars;
    }

    public void setCompressJars(boolean compressJars) {
        this.myCompressJars = compressJars;
    }

    public boolean isBuildIncrementally() {
        return this.myBuildIncrementally;
    }

    public void setBuildIncrementally(boolean buildIncrementally) {
        this.myBuildIncrementally = buildIncrementally;
    }

    public void setBuildInfoPrinter(BuildInfoPrinter printer) {
        this.myBuildInfoPrinter = printer;
    }

    public void setUseInProcessJavac(boolean value) {
        this.warning("projectBuilder.useInProcessJavac option is ignored because it doesn't make sense for new JPS builders");
    }

    public void setArrangeModuleCyclesOutputs(boolean value) {
        this.warning("projectBuilder.arrangeModuleCyclesOutputs option is ignored because it doesn't make sense for new JPS builders");
    }

    public void error(String message) {
        throw new BuildException(message);
    }

    public void error(Throwable t) {
        throw new BuildException(t);
    }

    public void warning(String message) {
        this.myProject.log(message, 1);
    }

    public void info(String message) {
        this.myProject.log(message, 2);
    }

    public void stage(String message) {
        this.myBuildInfoPrinter.printProgressMessage(this, message);
    }

    public File getDataStorageRoot() {
        return this.myDataStorageRoot;
    }

    public void setDataStorageRoot(File dataStorageRoot) {
        this.myDataStorageRoot = dataStorageRoot;
    }

    public void setupAdditionalLogging(File buildLogFile, String categoriesWithDebugLevel) {
        categoriesWithDebugLevel = StringUtil.notNullize((String)categoriesWithDebugLevel);
        try {
            this.myFileLoggerFactory = new Log4jFileLoggerFactory(buildLogFile, categoriesWithDebugLevel);
            this.info("Build log (" + (!categoriesWithDebugLevel.isEmpty() ? "debug level for " + categoriesWithDebugLevel : "info") + ") will be written to " + buildLogFile.getAbsolutePath());
        }
        catch (Throwable t) {
            this.myProject.log("Cannot setup additional logging to " + buildLogFile.getAbsolutePath() + ": " + t.getMessage(), t, 1);
        }
    }

    public void cleanOutput() {
        if (this.myDryRun) {
            this.info("Cleaning skipped as we're running dry");
            return;
        }
        if (this.myBuildIncrementally) {
            this.info("Cleaning skipped for incremental build");
            return;
        }
        long cleanOutputStart = System.currentTimeMillis();
        for (JpsModule module : this.myModel.getProject().getModules()) {
            for (boolean test : new boolean[]{false, true}) {
                File output = JpsJavaExtensionService.getInstance().getOutputDirectory(module, test);
                if (output == null) continue;
                FileUtil.delete((File)output);
            }
        }
        this.myBuildInfoPrinter.printStatisticsMessage(this, "Cleaning output time, ms", String.valueOf(System.currentTimeMillis() - cleanOutputStart));
        this.myCompiledModules.clear();
        this.myCompiledModuleTests.clear();
    }

    public void makeModule(JpsModule module) {
        this.runBuild(JpsGantProjectBuilder.getModuleDependencies(module, false), false, false);
    }

    public void buildModules(List<JpsModule> modules) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        this.info("Collecting dependencies for " + modules.size() + " modules");
        for (JpsModule module : modules) {
            Set<String> dependencies = JpsGantProjectBuilder.getModuleDependencies(module, false);
            for (String dependency : dependencies) {
                if (!names.add(dependency)) continue;
                this.info(" adding " + dependency + " required for " + module.getName());
            }
        }
        this.runBuild(names, false, false);
    }

    public void makeModuleTests(JpsModule module) {
        this.runBuild(JpsGantProjectBuilder.getModuleDependencies(module, true), false, true);
    }

    public void buildAll() {
        this.runBuild(Collections.<String>emptySet(), true, true);
    }

    public void buildProduction() {
        this.runBuild(Collections.<String>emptySet(), true, false);
    }

    public void exportModuleOutputProperties() {
        for (JpsModule module : this.myModel.getProject().getModules()) {
            for (boolean test : new boolean[]{true, false}) {
                String propertyName = "module." + module.getName() + ".output." + (test ? "test" : "main");
                String outputPath = this.getModuleOutput(module, test);
                this.myProject.setProperty(propertyName, outputPath);
            }
        }
    }

    private static Set<String> getModuleDependencies(JpsModule module, boolean includeTests) {
        JpsJavaDependenciesEnumerator enumerator = JpsJavaExtensionService.dependencies((JpsModule)module).recursively();
        if (!includeTests) {
            enumerator = enumerator.productionOnly();
        }
        HashSet<String> names = new HashSet<String>();
        for (JpsModule depModule : enumerator.getModules()) {
            names.add(depModule.getName());
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBuild(Set<String> modulesSet, boolean allModules, boolean includeTests) {
        if (!this.myDryRun) {
            AntMessageHandler messageHandler = new AntMessageHandler();
            AntLoggerFactory.ourMessageHandler = new AntMessageHandler();
            AntLoggerFactory.ourFileLoggerFactory = this.myFileLoggerFactory;
            Logger.setFactory(AntLoggerFactory.class);
            boolean forceBuild = !this.myBuildIncrementally;
            ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes = new ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope>();
            for (JavaModuleBuildTargetType type : JavaModuleBuildTargetType.ALL_TYPES) {
                if (!includeTests && type.isTests()) continue;
                ArrayList<String> namesToCompile = new ArrayList<String>(allModules ? this.getAllModules() : modulesSet);
                if (type.isTests()) {
                    namesToCompile.removeAll(this.myCompiledModuleTests);
                    this.myCompiledModuleTests.addAll(namesToCompile);
                } else {
                    namesToCompile.removeAll(this.myCompiledModules);
                    this.myCompiledModules.addAll(namesToCompile);
                }
                if (namesToCompile.isEmpty()) continue;
                CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope.Builder builder = CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope.newBuilder().setTypeId(type.getTypeId()).setForceBuild(forceBuild);
                if (allModules) {
                    scopes.add(builder.setAllTargets(true).build());
                    continue;
                }
                if (modulesSet.isEmpty()) continue;
                scopes.add(builder.addAllTargetId(modulesSet).build());
            }
            this.info("Starting build; incremental: " + this.myBuildIncrementally + ", cache directory: " + this.myDataStorageRoot.getAbsolutePath());
            this.info("Build scope: " + (allModules ? "all" : Integer.valueOf(modulesSet.size())) + " modules, " + (includeTests ? "including tests" : "production only"));
            long compilationStart = System.currentTimeMillis();
            try {
                this.myBuildInfoPrinter.printBlockOpenedMessage(this, "Compilation");
                Standalone.runBuild(this.myModelLoader, this.myDataStorageRoot, messageHandler, scopes, false);
            }
            catch (Throwable e) {
                this.error(e);
            }
            finally {
                this.myBuildInfoPrinter.printBlockClosedMessage(this, "Compilation");
            }
            if (messageHandler.myFailed) {
                this.error("Compilation failed");
            } else if (!this.myStatisticsReported) {
                this.myBuildInfoPrinter.printStatisticsMessage(this, "Compilation time, ms", String.valueOf(System.currentTimeMillis() - compilationStart));
                this.myStatisticsReported = true;
            }
        } else {
            this.info("Building skipped as we're running dry");
        }
    }

    private Set<String> getAllModules() {
        HashSet<String> modules = new HashSet<String>();
        for (JpsModule module : this.myModel.getProject().getModules()) {
            modules.add(module.getName());
        }
        return modules;
    }

    public String moduleOutput(JpsModule module) {
        return this.getModuleOutput(module, false);
    }

    public String moduleTestsOutput(JpsModule module) {
        return this.getModuleOutput(module, true);
    }

    public String getModuleOutput(JpsModule module, boolean forTests) {
        File directory = JpsJavaExtensionService.getInstance().getOutputDirectory(module, forTests);
        return directory != null ? directory.getAbsolutePath() : null;
    }

    public List<String> moduleRuntimeClasspath(JpsModule module, boolean forTests) {
        JpsJavaDependenciesEnumerator enumerator = JpsJavaExtensionService.dependencies((JpsModule)module).recursively().includedIn(JpsJavaClasspathKind.runtime((boolean)forTests));
        Collection roots = enumerator.classes().getRoots();
        ArrayList<String> result = new ArrayList<String>();
        for (File root : roots) {
            result.add(root.getAbsolutePath());
        }
        return result;
    }

    private static class AntLoggerFactory
    implements Logger.Factory {
        private static final String COMPILER_NAME = "build runner";
        private static AntMessageHandler ourMessageHandler;
        private static Logger.Factory ourFileLoggerFactory;

        private AntLoggerFactory() {
        }

        public Logger getLoggerInstance(String category) {
            DefaultLogger antLogger = new DefaultLogger(category){

                public void error(@NonNls String message, @Nullable Throwable t, String ... details) {
                    if (details == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "org/jetbrains/jps/gant/JpsGantProjectBuilder$AntLoggerFactory$1", "error"));
                    }
                    if (t != null) {
                        ourMessageHandler.processMessage(new CompilerMessage(AntLoggerFactory.COMPILER_NAME, t));
                    } else {
                        ourMessageHandler.processMessage(new CompilerMessage(AntLoggerFactory.COMPILER_NAME, BuildMessage.Kind.ERROR, message));
                    }
                }

                public void warn(@NonNls String message, @Nullable Throwable t) {
                    ourMessageHandler.processMessage(new CompilerMessage(AntLoggerFactory.COMPILER_NAME, BuildMessage.Kind.WARNING, message));
                }
            };
            if (ourFileLoggerFactory != null) {
                return new CompositeLogger(new Logger[]{antLogger, ourFileLoggerFactory.getLoggerInstance(category)});
            }
            return antLogger;
        }
    }

    private class AntMessageHandler
    implements MessageHandler {
        private boolean myFailed;

        private AntMessageHandler() {
        }

        @Override
        public void processMessage(BuildMessage msg) {
            BuildMessage.Kind kind = msg.getKind();
            String text = msg.getMessageText();
            block0 : switch (kind) {
                case ERROR: {
                    String messageText;
                    String compilerName;
                    if (msg instanceof CompilerMessage) {
                        CompilerMessage compilerMessage = (CompilerMessage)msg;
                        compilerName = compilerMessage.getCompilerName();
                        String sourcePath = compilerMessage.getSourcePath();
                        messageText = sourcePath != null ? sourcePath + (compilerMessage.getLine() != -1L ? ":" + compilerMessage.getLine() : "") + ":\n" + text : text;
                    } else {
                        compilerName = "";
                        messageText = text;
                    }
                    this.myFailed = true;
                    JpsGantProjectBuilder.this.myBuildInfoPrinter.printCompilationErrors(JpsGantProjectBuilder.this, compilerName, messageText);
                    break;
                }
                case WARNING: {
                    JpsGantProjectBuilder.this.warning(text);
                    break;
                }
                case INFO: {
                    if (msg instanceof BuilderStatisticsMessage) {
                        BuilderStatisticsMessage message = (BuilderStatisticsMessage)msg;
                        String buildKind = JpsGantProjectBuilder.this.myBuildIncrementally ? " (incremental)" : "";
                        JpsGantProjectBuilder.this.myBuildInfoPrinter.printStatisticsMessage(JpsGantProjectBuilder.this, "Compilation time '" + message.getBuilderName() + "'" + buildKind + ", ms", String.valueOf(message.getElapsedTimeMs()));
                        int sources = message.getNumberOfProcessedSources();
                        JpsGantProjectBuilder.this.myBuildInfoPrinter.printStatisticsMessage(JpsGantProjectBuilder.this, "Processed files by '" + message.getBuilderName() + "'" + buildKind, String.valueOf(sources));
                        if (JpsGantProjectBuilder.this.myBuildIncrementally || sources <= 0) break;
                        JpsGantProjectBuilder.this.myBuildInfoPrinter.printStatisticsMessage(JpsGantProjectBuilder.this, "Compilation time per file for '" + message.getBuilderName() + "', ms", String.format(Locale.US, "%.2f", (double)message.getElapsedTimeMs() / (double)sources));
                        break;
                    }
                    if (text.isEmpty()) break;
                    JpsGantProjectBuilder.this.info(text);
                    break;
                }
                case PROGRESS: {
                    if (!(msg instanceof BuildingTargetProgressMessage)) break;
                    String targetsString = StringUtil.join(((BuildingTargetProgressMessage)msg).getTargets(), (Function)new NotNullFunction<BuildTarget<?>, String>(){

                        @NotNull
                        public String fun(BuildTarget<?> dom) {
                            String string = dom.getPresentableName();
                            if (string == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gant/JpsGantProjectBuilder$AntMessageHandler$1", "fun"));
                            }
                            return string;
                        }
                    }, (String)",");
                    switch (((BuildingTargetProgressMessage)msg).getEventType()) {
                        case STARTED: {
                            JpsGantProjectBuilder.this.myBuildInfoPrinter.printBlockOpenedMessage(JpsGantProjectBuilder.this, targetsString);
                            break block0;
                        }
                        case FINISHED: {
                            JpsGantProjectBuilder.this.myBuildInfoPrinter.printBlockClosedMessage(JpsGantProjectBuilder.this, targetsString);
                        }
                    }
                }
            }
        }
    }
}

