/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.JBIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JBIterable<E>
implements Iterable<E> {
    final Iterable<E> myIterable;
    private static final JBIterable EMPTY = new JBIterable(){

        @Override
        public Iterator iterator() {
            return ContainerUtil.emptyIterator();
        }
    };

    protected JBIterable() {
        this.myIterable = this;
    }

    JBIterable(@NotNull Iterable<E> iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/util/containers/JBIterable", "<init>"));
        }
        this.myIterable = iterable;
    }

    @NotNull
    public static <E> JBIterable<E> from(@Nullable Iterable<? extends E> iterable) {
        if (iterable == null) {
            JBIterable<E> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "from"));
            }
            return jBIterable;
        }
        if (iterable instanceof JBIterable) {
            JBIterable jBIterable = (JBIterable)iterable;
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "from"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = new JBIterable<E>(iterable){

            @Override
            public Iterator<E> iterator() {
                return this.myIterable.iterator();
            }
        };
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "from"));
        }
        return jBIterable;
    }

    @NotNull
    public static <E> JBIterable<E> generate(final @Nullable E first, final @NotNull Function<? super E, ? extends E> generator) {
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/util/containers/JBIterable", "generate"));
        }
        if (first == null) {
            JBIterable<E> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "generate"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = new JBIterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new JBIterator<E>(){
                    E cur;
                    {
                        this.cur = first;
                    }

                    @Override
                    public E nextImpl() {
                        Object result = this.cur;
                        if (result == null) {
                            return this.stop();
                        }
                        this.cur = generator.fun(this.cur);
                        return result;
                    }
                };
            }
        };
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "generate"));
        }
        return jBIterable;
    }

    @NotNull
    public static <E> JBIterable<E> generate(final @Nullable E first1, final @Nullable E first2, final @NotNull PairFunction<? super E, ? super E, ? extends E> generator) {
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/util/containers/JBIterable", "generate"));
        }
        if (first1 == null) {
            JBIterable<E> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "generate"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = new JBIterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new JBIterator<E>(){
                    E cur1;
                    E cur2;
                    {
                        this.cur1 = first1;
                        this.cur2 = first2;
                    }

                    @Override
                    public E nextImpl() {
                        Object result = this.cur1;
                        this.cur1 = this.cur2;
                        this.cur2 = generator.fun(result, this.cur2);
                        if (result == null) {
                            return this.stop();
                        }
                        return result;
                    }
                };
            }
        };
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "generate"));
        }
        return jBIterable;
    }

    @NotNull
    public static <E> JBIterable<E> of(E ... elements) {
        JBIterable<E> jBIterable = JBIterable.from(ContainerUtil.newArrayList(elements));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "of"));
        }
        return jBIterable;
    }

    @NotNull
    public static <E> JBIterable<E> empty() {
        JBIterable jBIterable = EMPTY;
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "empty"));
        }
        return jBIterable;
    }

    @NotNull
    public static <E> JBIterable<E> once(@NotNull Iterator<E> iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/util/containers/JBIterable", "once"));
        }
        final Ref<Iterator<E>> itRef = Ref.create(iterator);
        JBIterable jBIterable = new JBIterable<E>(){

            @Override
            @NotNull
            public Iterator<E> iterator() {
                Iterator result = (Iterator)itRef.get();
                if (result == null) {
                    throw new UnsupportedOperationException();
                }
                itRef.set(null);
                Iterator iterator = result;
                if (iterator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable$5", "iterator"));
                }
                return iterator;
            }
        };
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "once"));
        }
        return jBIterable;
    }

    public <T extends Iterator<E>> T typedIterator() {
        return (T)this.iterator();
    }

    public String toString() {
        int max = 50;
        List<E> list = this.take(max + 1).toList();
        return "(" + StringUtil.join(list.subList(0, Math.min(list.size(), max)), ", ") + (list.size() > max ? ", ..." : "") + ")";
    }

    public final int size() {
        int count = 0;
        for (E ignored : this.myIterable) {
            ++count;
        }
        return count;
    }

    public final boolean contains(@Nullable Object element) {
        if (this.myIterable instanceof Collection) {
            return ((Collection)this.myIterable).contains(element);
        }
        for (E e : this.myIterable) {
            if (!Comparing.equal(e, element)) continue;
            return true;
        }
        return false;
    }

    public final JBIterable<E> append(@Nullable Iterable<? extends E> other) {
        return other == null ? this : (this == EMPTY ? JBIterable.from(other) : JBIterable.from(ContainerUtil.concat(this.myIterable, other)));
    }

    public final <T> JBIterable<E> append(@Nullable Iterable<T> other, @NotNull Function<? super T, ? extends Iterable<? extends E>> fun) {
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "com/intellij/util/containers/JBIterable", "append"));
        }
        return other == null ? this : (this == EMPTY ? JBIterable.from(other).flatten(fun) : this.append((T)JBIterable.from(other).flatten(fun)));
    }

    public final JBIterable<E> append(@NotNull E[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/JBIterable", "append"));
        }
        return this == EMPTY ? JBIterable.of(elements) : this.append((E)Arrays.asList(elements));
    }

    public final JBIterable<E> append(@Nullable E e) {
        return e == null ? this : (this == EMPTY ? JBIterable.of(e) : this.append(Collections.singleton(e)));
    }

    public final JBIterable<E> filter(final @NotNull Condition<? super E> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/JBIterable", "filter"));
        }
        final JBIterable it = this;
        return new JBIterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return JBIterator.from(it.iterator()).filter(condition);
            }
        };
    }

    public final <T> JBIterable<T> filter(@NotNull Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/util/containers/JBIterable", "filter"));
        }
        return this.filter(Conditions.instanceOf(type));
    }

    public final JBIterable<E> repeat(final int count) {
        final JBIterable it = this;
        return new JBIterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new JBIterator<E>(){
                    int index;
                    Iterator<E> cur;
                    {
                        this.cur = it.iterator();
                    }

                    @Override
                    public E nextImpl() {
                        if (this.cur.hasNext()) {
                            return this.cur.next();
                        }
                        if (this.index >= count || ++this.index == count) {
                            return this.stop();
                        }
                        this.cur = it.iterator();
                        return this.cur.hasNext() ? this.cur.next() : this.stop();
                    }

                    @Override
                    public void remove() {
                        this.cur.remove();
                    }
                };
            }
        };
    }

    @NotNull
    public final JBIterable<E> take(final int count) {
        final JBIterable it = this;
        JBIterable jBIterable = new JBIterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return JBIterator.from(it.iterator()).takeWhile(count);
            }
        };
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "take"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> takeWhile(final @NotNull Condition<? super E> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/JBIterable", "takeWhile"));
        }
        final JBIterable it = this;
        JBIterable jBIterable = new JBIterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return JBIterator.from(it.iterator()).takeWhile(condition);
            }
        };
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "takeWhile"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> skip(final int count) {
        final JBIterable it = this;
        JBIterable jBIterable = new JBIterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return JBIterator.from(it.iterator()).skipWhile(count);
            }
        };
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "skip"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> skipWhile(final @NotNull Condition<? super E> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/JBIterable", "skipWhile"));
        }
        final JBIterable it = this;
        JBIterable jBIterable = new JBIterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return JBIterator.from(it.iterator()).skipWhile(condition);
            }
        };
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "skipWhile"));
        }
        return jBIterable;
    }

    @NotNull
    public final <T> JBIterable<T> transform(final @NotNull Function<? super E, T> function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/util/containers/JBIterable", "transform"));
        }
        final JBIterable it = this;
        JBIterable jBIterable = new JBIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return JBIterator.from(it.iterator()).transform(function);
            }
        };
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "transform"));
        }
        return jBIterable;
    }

    @NotNull
    public <T> JBIterable<T> flatten(final Function<? super E, ? extends Iterable<? extends T>> function) {
        if (this == EMPTY) {
            JBIterable<E> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "flatten"));
            }
            return jBIterable;
        }
        final Iterable<E> thatIt = this.myIterable;
        JBIterable jBIterable = new JBIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final Iterator it = thatIt.iterator();
                return new JBIterator<T>(){
                    Iterator<? extends T> cur;

                    @Override
                    public T nextImpl() {
                        while ((this.cur == null || !this.cur.hasNext()) && it.hasNext()) {
                            this.cur = ((Iterable)function.fun(it.next())).iterator();
                        }
                        if (this.cur == null || !this.cur.hasNext()) {
                            return this.stop();
                        }
                        return this.cur.next();
                    }

                    @Override
                    public void remove() {
                        this.cur.remove();
                    }
                };
            }
        };
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "flatten"));
        }
        return jBIterable;
    }

    @Nullable
    public final E first() {
        Iterator<E> iterator = this.myIterable.iterator();
        return iterator.hasNext() ? (E)iterator.next() : null;
    }

    @Nullable
    public final E last() {
        if (this.myIterable instanceof List) {
            return (E)ContainerUtil.getLastItem((List)this.myIterable);
        }
        Iterator<E> iterator = this.myIterable.iterator();
        E cur = null;
        while (iterator.hasNext()) {
            cur = iterator.next();
        }
        return cur;
    }

    public final boolean isEmpty() {
        return !this.myIterable.iterator().hasNext();
    }

    public final List<E> toList() {
        return Collections.unmodifiableList(ContainerUtil.newArrayList(this.myIterable));
    }

    public final Set<E> toSet() {
        return Collections.unmodifiableSet(ContainerUtil.newHashSet(this.myIterable));
    }

    public final <V> Map<E, V> toMap(Convertor<E, V> valueFunction) {
        return Collections.unmodifiableMap(ContainerUtil.newMapFromKeys(this.iterator(), valueFunction));
    }

    public final <C extends Collection<? super E>> C addAllTo(@NotNull C collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/JBIterable", "addAllTo"));
        }
        if (this.myIterable instanceof Collection) {
            collection.addAll((Collection)this.myIterable);
        } else {
            for (E item : this.myIterable) {
                collection.add(item);
            }
        }
        return collection;
    }
}

