/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeTraverser<T> {
    protected final Function<T, ? extends Iterable<? extends T>> treeStructure;

    public TreeTraverser(Function<T, ? extends Iterable<? extends T>> provider) {
        this.treeStructure = provider;
    }

    @NotNull
    public Iterable<? extends T> children(@NotNull T root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/util/containers/TreeTraverser", "children"));
        }
        Iterable<? extends T> result = this.treeStructure.fun(root);
        Iterable<Object> iterable = result != null ? result : JBIterable.empty();
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraverser", "children"));
        }
        return iterable;
    }

    @NotNull
    public final JBIterable<T> preOrderTraversal(final @NotNull Iterable<? extends T> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraverser", "preOrderTraversal"));
        }
        JBIterable jBIterable = new JBIterable<T>(){

            @Override
            public TracingIt<T> iterator() {
                return new PreOrderIt(roots);
            }
        };
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraverser", "preOrderTraversal"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<T> preOrderTraversal(@Nullable T root) {
        JBIterable<List<T>> jBIterable = this.preOrderTraversal((T)ContainerUtil.createMaybeSingletonList(root));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraverser", "preOrderTraversal"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<T> postOrderTraversal(final @NotNull Iterable<? extends T> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraverser", "postOrderTraversal"));
        }
        JBIterable jBIterable = new JBIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new PostOrderIt(roots);
            }
        };
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraverser", "postOrderTraversal"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<T> postOrderTraversal(@Nullable T root) {
        JBIterable<List<T>> jBIterable = this.postOrderTraversal((T)ContainerUtil.createMaybeSingletonList(root));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraverser", "postOrderTraversal"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<T> leavesTraversal(final @NotNull Iterable<? extends T> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraverser", "leavesTraversal"));
        }
        JBIterable jBIterable = new JBIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new LeavesDfsIt(roots);
            }
        };
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraverser", "leavesTraversal"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<T> breadthFirstTraversal(final @NotNull Iterable<? extends T> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraverser", "breadthFirstTraversal"));
        }
        JBIterable jBIterable = new JBIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new BfsIterator(roots);
            }
        };
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraverser", "breadthFirstTraversal"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<T> breadthFirstTraversal(@Nullable T root) {
        JBIterable<List<T>> jBIterable = this.breadthFirstTraversal((T)ContainerUtil.createMaybeSingletonList(root));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraverser", "breadthFirstTraversal"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<T> tracingBreadthFirstTraversal(final @NotNull Iterable<? extends T> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraverser", "tracingBreadthFirstTraversal"));
        }
        JBIterable jBIterable = new JBIterable<T>(){

            @Override
            public TracingIt<T> iterator() {
                return new TracingBfsIt(TreeTraverser.this, roots);
            }
        };
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraverser", "tracingBreadthFirstTraversal"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<T> tracingBreadthFirstTraversal(@Nullable T root) {
        JBIterable<List<T>> jBIterable = this.tracingBreadthFirstTraversal((T)ContainerUtil.createMaybeSingletonList(root));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraverser", "tracingBreadthFirstTraversal"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<T> leavesBreadthFirstTraversal(final @NotNull Iterable<? extends T> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraverser", "leavesBreadthFirstTraversal"));
        }
        JBIterable jBIterable = new JBIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new LeavesBfsIt(roots);
            }
        };
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraverser", "leavesBreadthFirstTraversal"));
        }
        return jBIterable;
    }

    private final class TracingBfsIt
    extends TracingIt<T> {
        final ArrayDeque<T> queue;
        final Map<T, T> paths;
        T cur;
        final /* synthetic */ TreeTraverser this$0;

        /*
         * Exception decompiling
         */
        TracingBfsIt(@NotNull TreeTraverser var1_1, Iterable<? extends T> roots) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
             *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public T nextImpl() {
            if (this.queue.isEmpty()) {
                return this.stop();
            }
            Object result = this.queue.remove();
            for (Object t : this.this$0.children(result)) {
                if (this.paths.containsKey(t)) continue;
                this.queue.add(t);
                this.paths.put(t, result);
            }
            this.cur = result;
            return this.cur;
        }

        @Override
        public T parent() {
            return this.paths.get(this.cur);
        }

        @Override
        @NotNull
        public JBIterable<T> backtrace() {
            final Object first = this.cur;
            JBIterable jBIterable = new JBIterable<T>(){

                @Override
                public Iterator<T> iterator() {
                    return new JBIterator<T>(){
                        T cur;
                        {
                            this.cur = first;
                        }

                        @Override
                        public T nextImpl() {
                            if (this.cur == null) {
                                return this.stop();
                            }
                            Object result = this.cur;
                            this.cur = TracingBfsIt.this.paths.get(this.cur);
                            return result;
                        }
                    };
                }
            };
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraverser$TracingBfsIt", "backtrace"));
            }
            return jBIterable;
        }
    }

    private final class LeavesBfsIt
    extends JBIterator<T> {
        final ArrayDeque<T> queue;

        LeavesBfsIt(Iterable<? extends T> roots) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraverser$LeavesBfsIt", "<init>"));
            }
            this.queue = new ArrayDeque();
            JBIterable.from(roots).addAllTo(this.queue);
        }

        @Override
        public T nextImpl() {
            while (!this.queue.isEmpty()) {
                Object result = this.queue.remove();
                Iterator childrenIt = TreeTraverser.this.children(result).iterator();
                if (!childrenIt.hasNext()) {
                    return result;
                }
                while (childrenIt.hasNext()) {
                    this.queue.add(childrenIt.next());
                }
            }
            return this.stop();
        }
    }

    private final class BfsIterator
    extends JBIterator<T> {
        final ArrayDeque<T> queue;

        BfsIterator(Iterable<? extends T> roots) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraverser$BfsIterator", "<init>"));
            }
            this.queue = new ArrayDeque();
            JBIterable.from(roots).addAllTo(this.queue);
        }

        @Override
        public T nextImpl() {
            if (this.queue.isEmpty()) {
                return this.stop();
            }
            Object result = this.queue.remove();
            for (Object t : TreeTraverser.this.children(result)) {
                this.queue.add(t);
            }
            return result;
        }
    }

    private final class LeavesDfsIt
    extends DfsIt<T> {
        LeavesDfsIt(Iterable<? extends T> roots) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraverser$LeavesDfsIt", "<init>"));
            }
            Iterator iterator = roots.iterator();
            while (iterator.hasNext()) {
                Object root;
                Iterator childrenIt = TreeTraverser.this.children(root = iterator.next()).iterator();
                this.stack.addLast(Pair.create(root, childrenIt.hasNext() ? childrenIt : null));
            }
        }

        @Override
        public T nextImpl() {
            while (!this.stack.isEmpty()) {
                Pair top = (Pair)this.stack.getLast();
                if (top.second != null && ((Iterator)top.second).hasNext()) {
                    Object child = ((Iterator)top.second).next();
                    Iterator childrenIt = TreeTraverser.this.children(child).iterator();
                    if (childrenIt.hasNext()) {
                        this.stack.addLast(Pair.create(child, childrenIt));
                        continue;
                    }
                    return child;
                }
                this.stack.removeLast();
                if (top.second != null) continue;
                return top.first;
            }
            return this.stop();
        }
    }

    private final class PostOrderIt
    extends DfsIt<T> {
        PostOrderIt(Iterable<? extends T> roots) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraverser$PostOrderIt", "<init>"));
            }
            for (Object root : roots) {
                this.stack.addLast(Pair.create(root, TreeTraverser.this.children(root).iterator()));
            }
        }

        @Override
        public T nextImpl() {
            while (!this.stack.isEmpty()) {
                Pair top = (Pair)this.stack.getLast();
                if (((Iterator)top.second).hasNext()) {
                    Object child = ((Iterator)top.second).next();
                    this.stack.addLast(Pair.create(child, TreeTraverser.this.children(child).iterator()));
                    continue;
                }
                this.stack.removeLast();
                return top.first;
            }
            return this.stop();
        }
    }

    private final class PreOrderIt
    extends DfsIt<T> {
        int doneCount;

        PreOrderIt(Iterable<T> roots) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraverser$PreOrderIt", "<init>"));
            }
            Iterator iterator = roots.iterator();
            if (iterator.hasNext()) {
                this.stack.addLast(Pair.create(null, iterator));
            }
        }

        @Override
        public T nextImpl() {
            Pair top;
            if (this.stack.size() <= this.doneCount) {
                return this.stop();
            }
            while (true) {
                top = (Pair)this.stack.getLast();
                if (((Iterator)top.second).hasNext()) break;
                this.stack.removeLast();
                --this.doneCount;
            }
            Object result = ((Iterator)top.second).next();
            if (!((Iterator)top.second).hasNext()) {
                ++this.doneCount;
            }
            Iterator childItr = TreeTraverser.this.children(result).iterator();
            this.stack.addLast(Pair.create(result, childItr));
            if (!childItr.hasNext()) {
                ++this.doneCount;
            }
            return result;
        }
    }

    private static abstract class DfsIt<T>
    extends TracingIt<T> {
        final ArrayDeque<Pair<T, Iterator<? extends T>>> stack = new ArrayDeque();

        private DfsIt() {
        }

        @Override
        @Nullable
        public T parent() {
            Iterator<Pair<T, Iterator<T>>> it = this.stack.descendingIterator();
            it.next();
            return it.hasNext() ? (T)it.next().first : null;
        }

        @Override
        @NotNull
        public JBIterable<T> backtrace() {
            JBIterable<Object> jBIterable = new JBIterable<Pair<T, Iterator<? extends T>>>(){

                @Override
                public Iterator<Pair<T, Iterator<? extends T>>> iterator() {
                    Iterator iterator = DfsIt.this.stack.descendingIterator();
                    iterator.next();
                    return iterator;
                }
            }.transform(Functions.pairFirst()).filter(Condition.NOT_NULL);
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraverser$DfsIt", "backtrace"));
            }
            return jBIterable;
        }
    }

    public static abstract class TracingIt<T>
    extends JBIterator<T> {
        @Nullable
        public abstract T parent();

        @NotNull
        public abstract JBIterable<T> backtrace();
    }
}

