/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.model.bc;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtilRt;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.util.JpsPathUtil;

public class InfoFromConfigFile {
    public static InfoFromConfigFile DEFAULT = new InfoFromConfigFile(null, null, null, null, null);
    private static final Map<String, Pair<Long, InfoFromConfigFile>> ourCache = new THashMap();
    @Nullable
    private final File myConfigFile;
    @Nullable
    private final String myMainClassPath;
    private boolean myMainClassInitialized = false;
    @Nullable
    private String myMainClass;
    @Nullable
    private final String myOutputFileName;
    @Nullable
    private final String myOutputFolderPath;
    @Nullable
    private final String myTargetPlayer;

    private InfoFromConfigFile(@Nullable File configFile, @Nullable String mainClassPath, @Nullable String outputFileName, @Nullable String outputFolderPath, @Nullable String targetPlayer) {
        this.myConfigFile = configFile;
        this.myMainClassPath = mainClassPath;
        this.myOutputFileName = outputFileName;
        this.myOutputFolderPath = outputFolderPath;
        this.myTargetPlayer = targetPlayer;
    }

    @Nullable
    public String getMainClass(JpsModule module) {
        if (!this.myMainClassInitialized && this.myConfigFile != null && this.myConfigFile.isFile()) {
            this.myMainClass = this.myMainClassPath == null ? null : InfoFromConfigFile.getMainClassByPath(module, this.myMainClassPath, this.myConfigFile.getParent());
        }
        this.myMainClassInitialized = true;
        return this.myMainClass;
    }

    @Nullable
    public String getOutputFileName() {
        return this.myOutputFileName;
    }

    @Nullable
    public String getOutputFolderPath() {
        return this.myOutputFolderPath;
    }

    @Nullable
    public String getTargetPlayer() {
        return this.myTargetPlayer;
    }

    private static String getMainClassByPath(JpsModule module, String mainClassPath, String baseDir) {
        String mainClassCanonicalPath;
        if (mainClassPath.isEmpty()) {
            return "unknown";
        }
        File mainClassFile = new File(mainClassPath);
        if (!mainClassFile.isFile()) {
            mainClassFile = new File(baseDir + File.pathSeparator + mainClassPath);
        }
        if (!mainClassFile.isFile()) {
            return FileUtil.getNameWithoutExtension((String)FileUtil.getNameWithoutExtension((String)PathUtilRt.getFileName((String)mainClassPath)));
        }
        try {
            mainClassCanonicalPath = FileUtil.toSystemIndependentName((String)mainClassFile.getCanonicalPath());
        }
        catch (IOException e) {
            mainClassCanonicalPath = FileUtil.toSystemIndependentName((String)mainClassFile.getPath());
        }
        for (JpsModuleSourceRoot sourceRoot : module.getSourceRoots()) {
            String relativePath;
            String sourcePath = JpsPathUtil.urlToPath((String)sourceRoot.getUrl());
            if (!FileUtil.isAncestor((String)sourcePath, (String)mainClassCanonicalPath, (boolean)true) || (relativePath = FileUtil.getRelativePath((String)sourcePath, (String)mainClassCanonicalPath, (char)'/')) == null) continue;
            return FileUtil.getNameWithoutExtension((String)relativePath).replace("/", ".");
        }
        return FileUtil.getNameWithoutExtension((String)mainClassCanonicalPath);
    }

    @NotNull
    public static InfoFromConfigFile getInfoFromConfigFile(String configFilePath) {
        Long cachedTimestamp;
        String canonicalPath;
        File configFile;
        File file = configFile = configFilePath.isEmpty() ? null : new File(configFilePath);
        if (configFile == null || !configFile.isFile()) {
            ourCache.remove(configFilePath);
            InfoFromConfigFile infoFromConfigFile = DEFAULT;
            if (infoFromConfigFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/InfoFromConfigFile", "getInfoFromConfigFile"));
            }
            return infoFromConfigFile;
        }
        try {
            canonicalPath = configFile.getCanonicalPath();
        }
        catch (IOException e) {
            canonicalPath = configFile.getPath();
        }
        Pair data = ourCache.get(canonicalPath);
        Long currentTimestamp = configFile.lastModified();
        Long l = cachedTimestamp = data == null ? null : (Long)data.first;
        if (cachedTimestamp == null || !cachedTimestamp.equals(currentTimestamp)) {
            String targetPlayer;
            String outputPath;
            String mainClassPath;
            block12: {
                ourCache.remove(canonicalPath);
                mainClassPath = null;
                outputPath = null;
                targetPlayer = null;
                try {
                    Document document = JDOMUtil.loadDocument((File)configFile);
                    Element rootElement = document.getRootElement();
                    if (rootElement == null) break block12;
                    Element fileSpecsElement = rootElement.getChild("file-specs", rootElement.getNamespace());
                    mainClassPath = fileSpecsElement == null ? null : fileSpecsElement.getChildTextNormalize("path-element", rootElement.getNamespace());
                    outputPath = rootElement.getChildTextNormalize("output", rootElement.getNamespace());
                    if (outputPath != null && !FileUtil.isAbsolute((String)outputPath)) {
                        try {
                            outputPath = FileUtil.toSystemIndependentName((String)new File(configFile.getParent(), outputPath).getCanonicalPath());
                        }
                        catch (IOException e) {
                            outputPath = FileUtil.toSystemIndependentName((String)new File(configFile.getParent(), outputPath).getAbsolutePath());
                        }
                    }
                    targetPlayer = rootElement.getChildTextNormalize("target-player", rootElement.getNamespace());
                }
                catch (IOException document) {
                }
                catch (JDOMException document) {
                    // empty catch block
                }
            }
            String outputFileName = outputPath == null ? null : PathUtilRt.getFileName(outputPath);
            String outputFolderPath = outputPath == null ? null : PathUtilRt.getParentPath(outputPath);
            data = Pair.create((Object)currentTimestamp, (Object)new InfoFromConfigFile(configFile, mainClassPath, outputFileName, outputFolderPath, targetPlayer));
            ourCache.put(canonicalPath, (Pair<Long, InfoFromConfigFile>)data);
        }
        InfoFromConfigFile infoFromConfigFile = (InfoFromConfigFile)data.second;
        if (infoFromConfigFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/InfoFromConfigFile", "getInfoFromConfigFile"));
        }
        return infoFromConfigFile;
    }
}

