/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Bitness;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;
import org.jetbrains.jps.service.SharedThreadPool;

public class JdkVersionDetectorImpl
extends JdkVersionDetector {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.impl.SdkVersionUtil");
    private static final JdkVersionDetector.ActionRunner ACTION_RUNNER = new JdkVersionDetector.ActionRunner(){

        @Override
        public Future<?> run(Runnable runnable) {
            return SharedThreadPool.getInstance().executeOnPooledThread(runnable);
        }
    };

    @Override
    @Nullable
    public String detectJdkVersion(@NotNull String homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "org/jetbrains/jps/model/java/impl/JdkVersionDetectorImpl", "detectJdkVersion"));
        }
        return this.detectJdkVersion(homePath, ACTION_RUNNER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public String detectJdkVersion(@NotNull String homePath, @NotNull JdkVersionDetector.ActionRunner actionRunner) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "org/jetbrains/jps/model/java/impl/JdkVersionDetectorImpl", "detectJdkVersion"));
        }
        if (actionRunner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionRunner", "org/jetbrains/jps/model/java/impl/JdkVersionDetectorImpl", "detectJdkVersion"));
        }
        File path = new File(homePath, "jre/lib/rt.jar");
        try {
            JarFile runtimeArchive222;
            JarFile runtimeArchive;
            try {
                runtimeArchive = new JarFile(path, false);
            }
            catch (IOException e) {
                try {
                    runtimeArchive = new JarFile(path.getParentFile(), false);
                }
                catch (IOException e1) {
                    runtimeArchive222 = new JarFile(new File(homePath, "jrt-fs.jar"));
                }
            }
            try {
                String version;
                Manifest manifest = runtimeArchive222.getManifest();
                if (manifest != null && (version = manifest.getMainAttributes().getValue("Implementation-Version")) != null) {
                    String string = "java version \"" + version + "\"";
                    return string;
                }
            }
            finally {
                runtimeArchive222.close();
            }
        }
        catch (IOException runtimeArchive222) {
            // empty catch block
        }
        JdkVersionDetector.JdkVersionInfo info = this.detectJdkVersionInfo(homePath, actionRunner);
        if (info == null) return null;
        return info.getVersion();
    }

    @Override
    public JdkVersionDetector.JdkVersionInfo detectJdkVersionInfo(@NotNull String homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "org/jetbrains/jps/model/java/impl/JdkVersionDetectorImpl", "detectJdkVersionInfo"));
        }
        return this.detectJdkVersionInfo(homePath, ACTION_RUNNER);
    }

    @Override
    public JdkVersionDetector.JdkVersionInfo detectJdkVersionInfo(@NotNull String homePath, @NotNull JdkVersionDetector.ActionRunner actionRunner) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "org/jetbrains/jps/model/java/impl/JdkVersionDetectorImpl", "detectJdkVersionInfo"));
        }
        if (actionRunner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionRunner", "org/jetbrains/jps/model/java/impl/JdkVersionDetectorImpl", "detectJdkVersionInfo"));
        }
        String[] command = new String[]{homePath + File.separator + "bin" + File.separator + "java", "-version"};
        return JdkVersionDetectorImpl.readVersionInfoFromProcessOutput(homePath, command, null, actionRunner);
    }

    @Override
    public String readVersionFromProcessOutput(@NotNull String homePath, @NotNull String[] command, String versionLineMarker, @NotNull JdkVersionDetector.ActionRunner actionRunner) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "org/jetbrains/jps/model/java/impl/JdkVersionDetectorImpl", "readVersionFromProcessOutput"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/jps/model/java/impl/JdkVersionDetectorImpl", "readVersionFromProcessOutput"));
        }
        if (actionRunner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionRunner", "org/jetbrains/jps/model/java/impl/JdkVersionDetectorImpl", "readVersionFromProcessOutput"));
        }
        JdkVersionDetector.JdkVersionInfo info = JdkVersionDetectorImpl.readVersionInfoFromProcessOutput(homePath, command, versionLineMarker, actionRunner);
        if (info != null) {
            return info.getVersion();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JdkVersionDetector.JdkVersionInfo readVersionInfoFromProcessOutput(@NotNull String homePath, @NotNull String[] command, String versionLineMarker, @NotNull JdkVersionDetector.ActionRunner actionRunner) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "org/jetbrains/jps/model/java/impl/JdkVersionDetectorImpl", "readVersionInfoFromProcessOutput"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/jps/model/java/impl/JdkVersionDetectorImpl", "readVersionInfoFromProcessOutput"));
        }
        if (actionRunner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionRunner", "org/jetbrains/jps/model/java/impl/JdkVersionDetectorImpl", "readVersionInfoFromProcessOutput"));
        }
        if (!new File(homePath).exists()) {
            return null;
        }
        try {
            Process process = Runtime.getRuntime().exec(command);
            VersionParsingThread parsingThread = new VersionParsingThread(process.getErrorStream(), versionLineMarker);
            Future<?> parsingThreadFuture = actionRunner.run(parsingThread);
            ReadStreamThread readThread = new ReadStreamThread(process.getInputStream());
            actionRunner.run(readThread);
            try {
                try {
                    process.waitFor();
                }
                catch (InterruptedException e) {
                    LOG.info((Throwable)e);
                    process.destroy();
                }
            }
            finally {
                try {
                    parsingThreadFuture.get();
                }
                catch (Exception e) {
                    LOG.info((Throwable)e);
                }
            }
            String version = parsingThread.getVersion();
            if (version != null) {
                return new JdkVersionDetector.JdkVersionInfo(version, parsingThread.getBitness());
            }
        }
        catch (IOException ex) {
            LOG.info((Throwable)ex);
        }
        return null;
    }

    public static class VersionParsingThread
    implements Runnable {
        private Reader myReader;
        private final InputStream myStream;
        private boolean mySkipLF = false;
        private final String myVersionLineMarker;
        private final AtomicReference<String> myVersionString = new AtomicReference();
        private final AtomicReference<Bitness> myBitness = new AtomicReference<Bitness>(Bitness.x32);
        private static final String VERSION_LINE_MARKER = "version";
        private static final String BITNESS_64_MARKER = "64-Bit";

        protected VersionParsingThread(InputStream input, String versionLineMarker) {
            this.myStream = input;
            this.myVersionLineMarker = versionLineMarker != null ? versionLineMarker : VERSION_LINE_MARKER;
        }

        Bitness getBitness() {
            return this.myBitness.get();
        }

        String getVersion() {
            return this.myVersionString.get();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                this.myReader = new InputStreamReader(this.myStream);
                while (true) {
                    String line;
                    if ((line = this.readLine()) == null) {
                        return;
                    }
                    if (line.contains(this.myVersionLineMarker)) {
                        this.myVersionString.set(line);
                    }
                    if (!line.contains(BITNESS_64_MARKER)) continue;
                    this.myBitness.set(Bitness.x64);
                    continue;
                    break;
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                return;
            }
            finally {
                if (this.myReader != null) {
                    try {
                        this.myReader.close();
                    }
                    catch (IOException e) {
                        LOG.info((Throwable)e);
                    }
                }
            }
        }

        private String readLine() throws IOException {
            int c;
            boolean first = true;
            StringBuilder buffer = new StringBuilder();
            while ((c = this.myReader.read()) != -1) {
                first = false;
                if (c == 10) {
                    if (!this.mySkipLF) break;
                    this.mySkipLF = false;
                    continue;
                }
                if (c == 13) {
                    this.mySkipLF = true;
                    break;
                }
                this.mySkipLF = false;
                buffer.append((char)c);
            }
            if (first) {
                return null;
            }
            String s = buffer.toString();
            return s;
        }
    }

    public static class ReadStreamThread
    implements Runnable {
        private final InputStream myStream;

        protected ReadStreamThread(InputStream stream) {
            this.myStream = stream;
        }

        @Override
        public void run() {
            try {
                int b;
                while ((b = this.myStream.read()) != -1) {
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
    }
}

