/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.compiler;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Base64;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.artifacts.ArtifactBuildTaskProvider;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.BuildTask;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.maven.model.JpsMavenExtensionService;
import org.jetbrains.jps.maven.model.impl.MavenModuleResourceConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.elements.JpsArtifactRootElement;

public class MavenManifestGenerationBuildTaskProvider
extends ArtifactBuildTaskProvider {
    @NotNull
    public List<? extends BuildTask> createArtifactBuildTasks(@NotNull JpsArtifact artifact, @NotNull ArtifactBuildTaskProvider.ArtifactBuildPhase buildPhase) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/jps/maven/compiler/MavenManifestGenerationBuildTaskProvider", "createArtifactBuildTasks"));
        }
        if (buildPhase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildPhase", "org/jetbrains/jps/maven/compiler/MavenManifestGenerationBuildTaskProvider", "createArtifactBuildTasks"));
        }
        String artifactName = artifact.getName();
        if (buildPhase == ArtifactBuildTaskProvider.ArtifactBuildPhase.PRE_PROCESSING && (artifactName.endsWith(" exploded") || artifactName.endsWith("ejb-client")) && artifact.getRootElement() instanceof JpsArtifactRootElement) {
            List<MavenManifestGenerationBuildTask> list = Collections.singletonList(new MavenManifestGenerationBuildTask(artifact));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/maven/compiler/MavenManifestGenerationBuildTaskProvider", "createArtifactBuildTasks"));
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/maven/compiler/MavenManifestGenerationBuildTaskProvider", "createArtifactBuildTasks"));
        }
        return list;
    }

    private static class MavenManifestGenerationBuildTask
    extends BuildTask {
        private static final Logger LOG = Logger.getInstance(MavenManifestGenerationBuildTask.class);
        private final JpsArtifact myArtifact;

        public MavenManifestGenerationBuildTask(JpsArtifact artifact) {
            this.myArtifact = artifact;
        }

        public void build(CompileContext context) throws ProjectBuildException {
            BuildDataPaths dataPaths = context.getProjectDescriptor().dataManager.getDataPaths();
            MavenProjectConfiguration projectConfiguration = JpsMavenExtensionService.getInstance().getMavenProjectConfiguration(dataPaths);
            if (projectConfiguration == null) {
                return;
            }
            MavenModuleResourceConfiguration moduleResourceConfiguration = projectConfiguration.moduleConfigurations.get(MavenManifestGenerationBuildTask.getModuleName(this.myArtifact.getName()));
            if (moduleResourceConfiguration != null && StringUtil.isNotEmpty((String)moduleResourceConfiguration.manifest)) {
                try {
                    File output = new File(this.myArtifact.getOutputPath(), "META-INF/MANIFEST.MF");
                    FileUtil.writeToFile((File)output, (byte[])Base64.decode((String)moduleResourceConfiguration.manifest));
                }
                catch (Exception e) {
                    LOG.debug((Throwable)e);
                }
            }
        }

        @Nullable
        private static String getModuleName(@NotNull String artifactName) {
            if (artifactName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactName", "org/jetbrains/jps/maven/compiler/MavenManifestGenerationBuildTaskProvider$MavenManifestGenerationBuildTask", "getModuleName"));
            }
            return StringUtil.substringBefore((String)artifactName, (String)":");
        }
    }
}

