/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.JBIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JBIterable<E>
implements Iterable<E> {
    final Iterable<E> myIterable;
    private static final JBIterable EMPTY = new JBIterable(){

        @Override
        public Iterator iterator() {
            return ContainerUtil.emptyIterator();
        }
    };

    protected JBIterable() {
        this.myIterable = this;
    }

    JBIterable(@NotNull Iterable<E> iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/util/containers/JBIterable", "<init>"));
        }
        this.myIterable = iterable;
    }

    @NotNull
    public static <E> JBIterable<E> from(@Nullable Iterable<? extends E> iterable) {
        if (iterable == null) {
            JBIterable<E> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "from"));
            }
            return jBIterable;
        }
        if (iterable instanceof JBIterable) {
            JBIterable jBIterable = (JBIterable)iterable;
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "from"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = new JBIterable<E>(iterable){

            @Override
            public Iterator<E> iterator() {
                return this.myIterable.iterator();
            }
        };
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "from"));
        }
        return jBIterable;
    }

    @NotNull
    public static <E> JBIterable<E> generate(final @Nullable E first, final @NotNull Function<? super E, ? extends E> generator) {
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/util/containers/JBIterable", "generate"));
        }
        if (first == null) {
            JBIterable<E> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "generate"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = new JBIterable<E>(){

            @Override
            public Iterator<E> iterator() {
                final Function fun = Stateful.copy(generator);
                return new JBIterator<E>(){
                    E cur;
                    {
                        this.cur = first;
                    }

                    @Override
                    public E nextImpl() {
                        Object result = this.cur;
                        if (result == null) {
                            return this.stop();
                        }
                        this.cur = fun.fun(this.cur);
                        return result;
                    }
                };
            }
        };
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "generate"));
        }
        return jBIterable;
    }

    @NotNull
    public static <E> JBIterable<E> generate(final @Nullable E first1, final @Nullable E first2, final @NotNull PairFunction<? super E, ? super E, ? extends E> generator) {
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/util/containers/JBIterable", "generate"));
        }
        if (first1 == null) {
            JBIterable<E> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "generate"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = new JBIterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new JBIterator<E>(){
                    E cur1;
                    E cur2;
                    {
                        this.cur1 = first1;
                        this.cur2 = first2;
                    }

                    @Override
                    public E nextImpl() {
                        Object result = this.cur1;
                        this.cur1 = this.cur2;
                        this.cur2 = generator.fun(result, this.cur2);
                        if (result == null) {
                            return this.stop();
                        }
                        return result;
                    }
                };
            }
        };
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "generate"));
        }
        return jBIterable;
    }

    @NotNull
    public static <E> JBIterable<E> of(E ... elements) {
        JBIterable<E> jBIterable = elements == null ? JBIterable.empty() : JBIterable.from(ContainerUtil.newArrayList(elements));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "of"));
        }
        return jBIterable;
    }

    @NotNull
    public static <E> JBIterable<E> empty() {
        JBIterable jBIterable = EMPTY;
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "empty"));
        }
        return jBIterable;
    }

    @NotNull
    public static <E> JBIterable<E> once(@NotNull Iterator<E> iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/util/containers/JBIterable", "once"));
        }
        JBIterable jBIterable = JBIterable.of(Ref.create(iterator)).intercept(new Function<Iterator<Ref<Iterator<E>>>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<Ref<Iterator<E>>> iterator) {
                Ref ref = iterator.next();
                Iterator result = ref.get();
                if (result == null) {
                    throw new UnsupportedOperationException();
                }
                ref.set(null);
                return result;
            }
        });
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "once"));
        }
        return jBIterable;
    }

    public <T extends Iterator<E>> T typedIterator() {
        return (T)this.iterator();
    }

    public String toString() {
        int max = 50;
        List<E> list = this.take(max + 1).toList();
        return "(" + StringUtil.join(list.subList(0, Math.min(list.size(), max)), ", ") + (list.size() > max ? ", ..." : "") + ")";
    }

    public final int size() {
        int count = 0;
        for (E ignored : this.myIterable) {
            ++count;
        }
        return count;
    }

    public final boolean contains(@Nullable Object element) {
        if (this.myIterable instanceof Collection) {
            return ((Collection)this.myIterable).contains(element);
        }
        for (E e : this.myIterable) {
            if (!Comparing.equal(e, element)) continue;
            return true;
        }
        return false;
    }

    public final JBIterable<E> append(@Nullable Iterable<? extends E> other) {
        return other == null ? this : (this == EMPTY ? JBIterable.from(other) : JBIterable.of(this.myIterable, other).flatten(Functions.identity()));
    }

    public final <T> JBIterable<E> append(@Nullable Iterable<T> other, @NotNull Function<? super T, ? extends Iterable<? extends E>> fun) {
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "com/intellij/util/containers/JBIterable", "append"));
        }
        return other == null ? this : (this == EMPTY ? JBIterable.from(other).flatten(fun) : this.append((T)JBIterable.from(other).flatten(fun)));
    }

    public final JBIterable<E> repeat(int count) {
        Function fun = Functions.identity();
        return JBIterable.generate(this, fun).take(count).flatten(fun);
    }

    public final JBIterable<E> append(@NotNull E[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/JBIterable", "append"));
        }
        return this == EMPTY ? JBIterable.of(elements) : this.append((E)Arrays.asList(elements));
    }

    public final JBIterable<E> append(@Nullable E e) {
        return e == null ? this : (this == EMPTY ? JBIterable.of(e) : this.append(Collections.singleton(e)));
    }

    public final JBIterable<E> filter(final @NotNull Condition<? super E> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/JBIterable", "filter"));
        }
        return this.intercept(new Function<Iterator<E>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<E> iterator) {
                return JBIterator.from(iterator).filter(Stateful.copy(condition));
            }
        });
    }

    public final <T> JBIterable<T> filter(@NotNull Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/util/containers/JBIterable", "filter"));
        }
        return this.filter(Conditions.instanceOf(type));
    }

    @NotNull
    public final JBIterable<E> take(final int count) {
        JBIterable jBIterable = this.intercept(new Function<Iterator<E>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<E> iterator) {
                return JBIterator.from(iterator).take(count);
            }
        });
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "take"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> takeWhile(final @NotNull Condition<? super E> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/JBIterable", "takeWhile"));
        }
        JBIterable jBIterable = this.intercept(new Function<Iterator<E>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<E> iterator) {
                return JBIterator.from(iterator).takeWhile(Stateful.copy(condition));
            }
        });
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "takeWhile"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> skip(final int count) {
        JBIterable jBIterable = this.intercept(new Function<Iterator<E>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<E> iterator) {
                return JBIterator.from(iterator).skip(count);
            }
        });
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "skip"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> skipWhile(final @NotNull Condition<? super E> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/JBIterable", "skipWhile"));
        }
        JBIterable jBIterable = this.intercept(new Function<Iterator<E>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<E> iterator) {
                return JBIterator.from(iterator).skipWhile(Stateful.copy(condition));
            }
        });
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "skipWhile"));
        }
        return jBIterable;
    }

    @NotNull
    public final <T> JBIterable<T> transform(final @NotNull Function<? super E, T> function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/util/containers/JBIterable", "transform"));
        }
        JBIterable<T> jBIterable = this.intercept(new Function<Iterator<E>, Iterator<T>>(){

            @Override
            public Iterator<T> fun(Iterator<E> iterator) {
                return JBIterator.from(iterator).transform(Stateful.copy(function));
            }
        });
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "transform"));
        }
        return jBIterable;
    }

    @NotNull
    public <T> JBIterable<T> flatten(final Function<? super E, ? extends Iterable<? extends T>> function) {
        JBIterable<T> jBIterable = this.intercept(new Function<Iterator<E>, Iterator<T>>(){

            @Override
            public Iterator<T> fun(final Iterator<E> iterator) {
                final Function fun = Stateful.copy(function);
                return new JBIterator<T>(){
                    Iterator<? extends T> cur;

                    @Override
                    public T nextImpl() {
                        while ((this.cur == null || !this.cur.hasNext()) && iterator.hasNext()) {
                            this.cur = ((Iterable)fun.fun(iterator.next())).iterator();
                        }
                        if (this.cur == null || !this.cur.hasNext()) {
                            return this.stop();
                        }
                        return this.cur.next();
                    }

                    @Override
                    public void remove() {
                        this.cur.remove();
                    }
                };
            }
        });
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "flatten"));
        }
        return jBIterable;
    }

    @NotNull
    public final <T> JBIterable<T> intercept(final @NotNull Function<Iterator<E>, Iterator<T>> function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/util/containers/JBIterable", "intercept"));
        }
        if (this == EMPTY) {
            JBIterable<E> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "intercept"));
            }
            return jBIterable;
        }
        final JBIterable thisIterable = this;
        JBIterable jBIterable = new JBIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return (Iterator)function.fun(thisIterable.iterator());
            }
        };
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable", "intercept"));
        }
        return jBIterable;
    }

    @Nullable
    public final E first() {
        Iterator<E> iterator = this.myIterable.iterator();
        return iterator.hasNext() ? (E)iterator.next() : null;
    }

    @Nullable
    public final E last() {
        if (this.myIterable instanceof List) {
            return (E)ContainerUtil.getLastItem((List)this.myIterable);
        }
        Iterator<E> iterator = this.myIterable.iterator();
        E cur = null;
        while (iterator.hasNext()) {
            cur = iterator.next();
        }
        return cur;
    }

    public final boolean isEmpty() {
        return !this.myIterable.iterator().hasNext();
    }

    public final List<E> toList() {
        return Collections.unmodifiableList(ContainerUtil.newArrayList(this.myIterable));
    }

    public final Set<E> toSet() {
        return Collections.unmodifiableSet(ContainerUtil.newLinkedHashSet(this.myIterable));
    }

    public final <V> Map<E, V> toMap(Convertor<E, V> valueFunction) {
        return Collections.unmodifiableMap(ContainerUtil.newMapFromKeys(this.iterator(), valueFunction));
    }

    public final <C extends Collection<? super E>> C addAllTo(@NotNull C collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/JBIterable", "addAllTo"));
        }
        if (this.myIterable instanceof Collection) {
            collection.addAll((Collection)this.myIterable);
        } else {
            for (E item : this.myIterable) {
                collection.add(item);
            }
        }
        return collection;
    }

    public static abstract class StatefulTransform<S, T>
    extends Stateful<StatefulTransform>
    implements Function<S, T> {
    }

    public static abstract class StatefulFilter<T>
    extends Stateful<StatefulFilter>
    implements Condition<T> {
    }

    public static abstract class Stateful<Self extends Stateful>
    implements Cloneable {
        @NotNull
        static <T> T copy(@NotNull T o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/util/containers/JBIterable$Stateful", "copy"));
            }
            if (!(o instanceof Stateful)) {
                T t = o;
                if (t == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable$Stateful", "copy"));
                }
                return t;
            }
            Object object = ((Stateful)o).clone();
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/JBIterable$Stateful", "copy"));
            }
            return (T)object;
        }

        public Self clone() {
            try {
                return (Self)((Stateful)super.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

