/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TreeTraversal {
    private final String debugName;
    @NotNull
    public static final TreeTraversal PRE_ORDER_DFS = new TreeTraversal("PRE_ORDER_DFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal$3", "createIterator"));
            }
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/util/containers/TreeTraversal$3", "createIterator"));
            }
            PreOrderIt<? extends T> preOrderIt = new PreOrderIt<T>(roots, tree);
            if (preOrderIt == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraversal$3", "createIterator"));
            }
            return preOrderIt;
        }
    };
    @NotNull
    public static final TreeTraversal POST_ORDER_DFS = new TreeTraversal("POST_ORDER_DFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal$4", "createIterator"));
            }
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/util/containers/TreeTraversal$4", "createIterator"));
            }
            PostOrderIt<? extends T> postOrderIt = new PostOrderIt<T>(roots, tree);
            if (postOrderIt == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraversal$4", "createIterator"));
            }
            return postOrderIt;
        }
    };
    @NotNull
    public static final TreeTraversal LEAVES_ONLY_DFS = new TreeTraversal("LEAVES_ONLY_DFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal$5", "createIterator"));
            }
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/util/containers/TreeTraversal$5", "createIterator"));
            }
            LeavesDfsIt<? extends T> leavesDfsIt = new LeavesDfsIt<T>(roots, tree);
            if (leavesDfsIt == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraversal$5", "createIterator"));
            }
            return leavesDfsIt;
        }
    };
    @NotNull
    public static final TreeTraversal PLAIN_BFS = new TreeTraversal("PLAIN_BFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal$6", "createIterator"));
            }
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/util/containers/TreeTraversal$6", "createIterator"));
            }
            BfsIterator<? extends T> bfsIterator = new BfsIterator<T>(roots, tree);
            if (bfsIterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraversal$6", "createIterator"));
            }
            return bfsIterator;
        }
    };
    @NotNull
    public static final TreeTraversal TRACING_BFS = new TreeTraversal("TRACING_BFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal$7", "createIterator"));
            }
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/util/containers/TreeTraversal$7", "createIterator"));
            }
            TracingBfsIt<? extends T> tracingBfsIt = new TracingBfsIt<T>(roots, tree);
            if (tracingBfsIt == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraversal$7", "createIterator"));
            }
            return tracingBfsIt;
        }
    };
    @NotNull
    public static final TreeTraversal LEAVES_ONLY_BFS = new TreeTraversal("LEAVES_ONLY_BFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal$8", "createIterator"));
            }
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/util/containers/TreeTraversal$8", "createIterator"));
            }
            LeavesBfsIt<? extends T> leavesBfsIt = new LeavesBfsIt<T>(roots, tree);
            if (leavesBfsIt == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraversal$8", "createIterator"));
            }
            return leavesBfsIt;
        }
    };

    protected TreeTraversal(@NotNull String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/util/containers/TreeTraversal", "<init>"));
        }
        this.debugName = debugName;
    }

    @NotNull
    public <T> JBIterable<T> traversal(final @NotNull Iterable<? extends T> roots, final @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal", "traversal"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/util/containers/TreeTraversal", "traversal"));
        }
        JBIterable jBIterable = new JBIterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                It it = TreeTraversal.this.createIterator(roots, tree);
                if (it == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraversal$1", "iterator"));
                }
                return it;
            }
        };
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraversal", "traversal"));
        }
        return jBIterable;
    }

    @NotNull
    public <T> JBIterable<T> traversal(@Nullable T root, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/util/containers/TreeTraversal", "traversal"));
        }
        JBIterable<List<T>> jBIterable = this.traversal((T)ContainerUtil.createMaybeSingletonList(root), tree);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraversal", "traversal"));
        }
        return jBIterable;
    }

    @NotNull
    public <T> Function<T, JBIterable<T>> traversal(final @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/util/containers/TreeTraversal", "traversal"));
        }
        Function function = new Function<T, JBIterable<T>>(){

            @Override
            public JBIterable<T> fun(T t) {
                return TreeTraversal.this.traversal(t, tree);
            }
        };
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraversal", "traversal"));
        }
        return function;
    }

    @NotNull
    public abstract <T> It<T> createIterator(@NotNull Iterable<? extends T> var1, @NotNull Function<T, ? extends Iterable<? extends T>> var2);

    public String toString() {
        return this.debugName;
    }

    @NotNull
    private static <T> Iterable<? extends T> children(@NotNull T root, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/util/containers/TreeTraversal", "children"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/util/containers/TreeTraversal", "children"));
        }
        JBIterable<? extends T> jBIterable = JBIterable.from(tree.fun(root));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraversal", "children"));
        }
        return jBIterable;
    }

    private static class P<T> {
        T node;
        Iterable<? extends T> itle;
        Iterator<? extends T> it;
        boolean empty;
        static final Function TO_NODE = new Function<P<?>, Object>(){

            @Override
            public Object fun(P<?> tp) {
                return tp.node;
            }
        };

        private P() {
        }

        Iterator<? extends T> iterator(@NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/util/containers/TreeTraversal$P", "iterator"));
            }
            if (this.it != null) {
                return this.it;
            }
            this.it = (this.itle != null ? this.itle : (this.itle = TreeTraversal.children(this.node, tree))).iterator();
            this.empty = !this.it.hasNext();
            return this.it;
        }

        static <T> P<T> create(T node) {
            P<T> p = new P<T>();
            p.node = node;
            return p;
        }

        static <T> P<T> create(Iterable<? extends T> it) {
            P<T> p = new P<T>();
            p.itle = it;
            return p;
        }

        static <T> Function<P<T>, T> toNode() {
            return TO_NODE;
        }
    }

    private static final class TracingBfsIt<T>
    extends TracingIt<T> {
        final Function<T, ? extends Iterable<? extends T>> tree;
        final ArrayDeque<T> queue;
        final Map<T, T> paths;
        T cur;

        /*
         * Exception decompiling
         */
        TracingBfsIt(@NotNull Iterable<? extends T> roots, Function<T, ? extends Iterable<? extends T>> tree) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
             *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public T nextImpl() {
            if (this.queue.isEmpty()) {
                return (T)this.stop();
            }
            T result = this.queue.remove();
            for (Object t : TreeTraversal.children(result, this.tree)) {
                if (this.paths.containsKey(t)) continue;
                this.queue.add(t);
                this.paths.put(t, result);
            }
            this.cur = result;
            return this.cur;
        }

        @Override
        public T parent() {
            return this.paths.get(this.cur);
        }

        @Override
        @NotNull
        public JBIterable<T> backtrace() {
            final T first = this.cur;
            JBIterable jBIterable = new JBIterable<T>(){

                @Override
                public Iterator<T> iterator() {
                    return new JBIterator<T>(){
                        T cur;
                        {
                            this.cur = first;
                        }

                        @Override
                        public T nextImpl() {
                            if (this.cur == null) {
                                return this.stop();
                            }
                            Object result = this.cur;
                            this.cur = TracingBfsIt.this.paths.get(this.cur);
                            return result;
                        }
                    };
                }
            };
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraversal$TracingBfsIt", "backtrace"));
            }
            return jBIterable;
        }
    }

    private static final class LeavesBfsIt<T>
    extends It<T> {
        final Function<T, ? extends Iterable<? extends T>> tree;
        final ArrayDeque<T> queue;

        LeavesBfsIt(@NotNull Iterable<? extends T> roots, Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal$LeavesBfsIt", "<init>"));
            }
            this.queue = new ArrayDeque();
            this.tree = tree;
            JBIterable.from(roots).addAllTo(this.queue);
        }

        @Override
        public T nextImpl() {
            while (!this.queue.isEmpty()) {
                T result = this.queue.remove();
                Iterator childrenIt = TreeTraversal.children(result, this.tree).iterator();
                if (!childrenIt.hasNext()) {
                    return result;
                }
                while (childrenIt.hasNext()) {
                    this.queue.add(childrenIt.next());
                }
            }
            return (T)this.stop();
        }
    }

    private static final class BfsIterator<T>
    extends It<T> {
        final Function<T, ? extends Iterable<? extends T>> tree;
        final ArrayDeque<T> queue;

        BfsIterator(@NotNull Iterable<? extends T> roots, Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal$BfsIterator", "<init>"));
            }
            this.queue = new ArrayDeque();
            this.tree = tree;
            JBIterable.from(roots).addAllTo(this.queue);
        }

        @Override
        public T nextImpl() {
            if (this.queue.isEmpty()) {
                return (T)this.stop();
            }
            T result = this.queue.remove();
            for (Object t : TreeTraversal.children(result, this.tree)) {
                this.queue.add(t);
            }
            return result;
        }
    }

    private static final class LeavesDfsIt<T>
    extends DfsIt<T> {
        final Function<T, ? extends Iterable<? extends T>> tree;

        LeavesDfsIt(@NotNull Iterable<? extends T> roots, Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal$LeavesDfsIt", "<init>"));
            }
            this.tree = tree;
            this.stack.addLast(P.create(roots));
        }

        @Override
        public T nextImpl() {
            while (!this.stack.isEmpty()) {
                P top = (P)this.stack.getLast();
                if (top.iterator(this.tree).hasNext() && !top.empty) {
                    T child = top.iterator(this.tree).next();
                    this.stack.addLast(P.create(child));
                    continue;
                }
                this.stack.removeLast();
                if (!top.empty) continue;
                return (T)(this.stack.isEmpty() ? this.stop() : top.node);
            }
            return (T)this.stop();
        }
    }

    private static final class PostOrderIt<T>
    extends DfsIt<T> {
        final Function<T, ? extends Iterable<? extends T>> tree;

        PostOrderIt(@NotNull Iterable<? extends T> roots, Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal$PostOrderIt", "<init>"));
            }
            this.tree = tree;
            for (T root : roots) {
                this.stack.addLast(P.create(root));
            }
        }

        @Override
        public T nextImpl() {
            while (!this.stack.isEmpty()) {
                Iterator<T> it = ((P)this.stack.getLast()).iterator(this.tree);
                if (it.hasNext()) {
                    T result = it.next();
                    this.stack.addLast(P.create(result));
                    continue;
                }
                return ((P)this.stack.removeLast()).node;
            }
            return (T)this.stop();
        }
    }

    private static final class PreOrderIt<T>
    extends DfsIt<T> {
        final Function<T, ? extends Iterable<? extends T>> tree;

        PreOrderIt(@NotNull Iterable<? extends T> roots, Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/TreeTraversal$PreOrderIt", "<init>"));
            }
            this.tree = tree;
            this.stack.addLast(P.create(roots));
        }

        @Override
        public T nextImpl() {
            while (!this.stack.isEmpty()) {
                Iterator<T> it = ((P)this.stack.getLast()).iterator(this.tree);
                if (it.hasNext()) {
                    T result = it.next();
                    this.stack.addLast(P.create(result));
                    return result;
                }
                this.stack.removeLast();
            }
            return (T)this.stop();
        }
    }

    private static abstract class DfsIt<T>
    extends TracingIt<T> {
        final ArrayDeque<P<T>> stack = new ArrayDeque();

        private DfsIt() {
        }

        @Override
        @Nullable
        public T parent() {
            if (this.stack.isEmpty()) {
                throw new NoSuchElementException();
            }
            Iterator<P<T>> it = this.stack.descendingIterator();
            it.next();
            return it.hasNext() ? (T)it.next().node : null;
        }

        @Override
        @NotNull
        public JBIterable<T> backtrace() {
            if (this.stack.isEmpty()) {
                throw new NoSuchElementException();
            }
            JBIterable<Object> jBIterable = new JBIterable<P<T>>(){

                @Override
                public Iterator<P<T>> iterator() {
                    return DfsIt.this.stack.descendingIterator();
                }
            }.transform(P.toNode()).filter(Condition.NOT_NULL);
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/TreeTraversal$DfsIt", "backtrace"));
            }
            return jBIterable;
        }
    }

    public static abstract class TracingIt<T>
    extends It<T> {
        @Nullable
        public abstract T parent();

        @NotNull
        public abstract JBIterable<T> backtrace();
    }

    public static abstract class It<T>
    extends JBIterator<T> {
    }
}

