/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoundedTaskExecutor
implements Executor {
    protected final Executor myBackendExecutor;
    private final int myMaxTasks;
    private final AtomicInteger myInProgress;
    private final Queue<FutureTask> myTaskQueue;
    private final Runnable USER_TASK_RUNNER;

    public BoundedTaskExecutor(@NotNull Executor backendExecutor, int maxSimultaneousTasks) {
        if (backendExecutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backendExecutor", "com/intellij/util/concurrency/BoundedTaskExecutor", "<init>"));
        }
        this.myInProgress = new AtomicInteger(0);
        this.myTaskQueue = new LinkedBlockingQueue<FutureTask>();
        this.USER_TASK_RUNNER = new Runnable(){

            @Override
            public void run() {
                FutureTask task = (FutureTask)BoundedTaskExecutor.this.myTaskQueue.poll();
                try {
                    if (task != null && !task.isCancelled()) {
                        task.run();
                    }
                }
                finally {
                    BoundedTaskExecutor.this.myInProgress.decrementAndGet();
                    if (!BoundedTaskExecutor.this.myTaskQueue.isEmpty()) {
                        BoundedTaskExecutor.this.processQueue();
                    }
                }
            }
        };
        this.myBackendExecutor = backendExecutor;
        assert (maxSimultaneousTasks >= 1) : maxSimultaneousTasks;
        this.myMaxTasks = Math.max(maxSimultaneousTasks, 1);
    }

    @Override
    public void execute(@NotNull Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/util/concurrency/BoundedTaskExecutor", "execute"));
        }
        this.submit(task);
    }

    @NotNull
    public Future<?> submit(@NotNull Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/util/concurrency/BoundedTaskExecutor", "submit"));
        }
        RunnableFuture<Object> future = this.queueTask(new FutureTask<Object>(task, null));
        if (future == null) {
            throw new RuntimeException("Failed to queue task: " + task);
        }
        RunnableFuture<Object> runnableFuture = future;
        if (runnableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/BoundedTaskExecutor", "submit"));
        }
        return runnableFuture;
    }

    @NotNull
    public <T> Future<T> submit(@NotNull Callable<T> task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/util/concurrency/BoundedTaskExecutor", "submit"));
        }
        RunnableFuture<T> future = this.queueTask(new FutureTask<T>(task));
        if (future == null) {
            throw new RuntimeException("Failed to queue task: " + task);
        }
        RunnableFuture<T> runnableFuture = future;
        if (runnableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/BoundedTaskExecutor", "submit"));
        }
        return runnableFuture;
    }

    @Nullable
    private <T> RunnableFuture<T> queueTask(@NotNull FutureTask<T> futureTask) {
        if (futureTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "futureTask", "com/intellij/util/concurrency/BoundedTaskExecutor", "queueTask"));
        }
        if (this.myTaskQueue.offer(futureTask)) {
            this.processQueue();
            return futureTask;
        }
        return null;
    }

    protected void processQueue() {
        int count;
        do {
            if ((count = this.myInProgress.get()) < this.myMaxTasks) continue;
            return;
        } while (!this.myInProgress.compareAndSet(count, count + 1));
        this.myBackendExecutor.execute(this.USER_TASK_RUNNER);
    }
}

