/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.packages;

import com.android.annotations.NonNull;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.archives.Archive;
import com.android.sdklib.internal.repository.packages.BrokenPackage;
import com.android.sdklib.internal.repository.packages.IAndroidVersionProvider;
import com.android.sdklib.internal.repository.packages.MajorRevisionPackage;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.packages.PackageParserUtils;
import com.android.sdklib.internal.repository.sources.SdkSource;
import com.android.sdklib.io.IFileOp;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgDesc;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.w3c.dom.Node;

@Deprecated
public class SourcePackage
extends MajorRevisionPackage
implements IAndroidVersionProvider {
    private final AndroidVersion mVersion;
    private final IPkgDesc mPkgDesc;

    public SourcePackage(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        super(source, packageNode, nsUri, licenses);
        int apiLevel = PackageParserUtils.getXmlInt(packageNode, "api-level", 0);
        String codeName = PackageParserUtils.getXmlString(packageNode, "codename");
        if (codeName.length() == 0) {
            codeName = null;
        }
        this.mVersion = new AndroidVersion(apiLevel, codeName);
        this.mPkgDesc = this.setDescriptions(PkgDesc.Builder.newSource(this.mVersion, (MajorRevision)this.getRevision())).create();
    }

    protected SourcePackage(AndroidVersion platformVersion, int revision, Properties props, String localOsPath) {
        this(null, platformVersion, revision, props, localOsPath);
    }

    protected SourcePackage(SdkSource source, AndroidVersion platformVersion, int revision, Properties props, String localOsPath) {
        super(source, props, revision, null, null, null, localOsPath);
        this.mVersion = platformVersion;
        this.mPkgDesc = this.setDescriptions(PkgDesc.Builder.newSource(this.mVersion, (MajorRevision)this.getRevision())).create();
    }

    public static Package create(File srcDir, Properties props) {
        AndroidVersion version = null;
        String error = null;
        if (props == null) {
            error = String.format("Missing file %1$s", "source.properties");
        } else {
            try {
                version = new AndroidVersion(props);
                return new SourcePackage(version, 0, props, srcDir.getAbsolutePath());
            }
            catch (AndroidVersion.AndroidVersionException e) {
                error = String.format("Invalid file %1$s: %2$s", "source.properties", e.getMessage());
            }
        }
        if (version == null) {
            try {
                String platform = srcDir.getParentFile().getName();
                platform = platform.replaceAll("[^0-9]+", " ").trim();
                int pos = platform.indexOf(32);
                if (pos >= 0) {
                    platform = platform.substring(0, pos);
                }
                int apiLevel = Integer.parseInt(platform);
                version = new AndroidVersion(apiLevel, null);
            }
            catch (Exception platform) {
                // empty catch block
            }
        }
        StringBuilder sb = new StringBuilder("Broken Source Package");
        if (version != null) {
            sb.append(String.format(", API %1$s", version.getApiString()));
        }
        String shortDesc = sb.toString();
        if (error != null) {
            sb.append('\n').append(error);
        }
        String longDesc = sb.toString();
        IPkgDesc desc = PkgDesc.Builder.newSource(version != null ? version : new AndroidVersion(0, null), new MajorRevision(0)).setDescriptionShort(shortDesc).create();
        return new BrokenPackage(props, shortDesc, longDesc, 0, version == null ? 0 : version.getApiLevel(), srcDir.getAbsolutePath(), desc);
    }

    @Override
    @NonNull
    public IPkgDesc getPkgDesc() {
        return this.mPkgDesc;
    }

    @Override
    public void saveProperties(Properties props) {
        super.saveProperties(props);
        this.mVersion.saveProperties(props);
    }

    @Override
    @NonNull
    public AndroidVersion getAndroidVersion() {
        return this.mVersion;
    }

    @Override
    public String installId() {
        return "source-" + this.mVersion.getApiString();
    }

    @Override
    public String getListDescription() {
        String ld = this.getListDisplay();
        if (!ld.isEmpty()) {
            return String.format("%1$s%2$s", ld, this.isObsolete() ? " (Obsolete)" : "");
        }
        if (this.mVersion.isPreview()) {
            return String.format("Sources for Android '%1$s' Preview SDK%2$s", this.mVersion.getCodename(), this.isObsolete() ? " (Obsolete)" : "");
        }
        return String.format("Sources for Android SDK%2$s", this.mVersion.getApiLevel(), this.isObsolete() ? " (Obsolete)" : "");
    }

    @Override
    public String getShortDescription() {
        String ld = this.getListDisplay();
        if (!ld.isEmpty()) {
            return String.format("%1$s, revision %2$s%3$s", ld, this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
        }
        if (this.mVersion.isPreview()) {
            return String.format("Sources for Android '%1$s' Preview SDK, revision %2$s%3$s", this.mVersion.getCodename(), this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
        }
        return String.format("Sources for Android SDK, API %1$d, revision %2$s%3$s", this.mVersion.getApiLevel(), this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
    }

    @Override
    public String getLongDescription() {
        String s = this.getDescription();
        if (s == null || s.length() == 0) {
            s = this.getShortDescription();
        }
        if (s.indexOf("revision") == -1) {
            s = s + String.format("\nRevision %1$s%2$s", this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
        }
        return s;
    }

    @Override
    public File getInstallFolder(String osSdkRoot, SdkManager sdkManager) {
        File folder = new File(osSdkRoot, "sources");
        folder = new File(folder, "android-" + this.mVersion.getApiString());
        return folder;
    }

    @Override
    public void postUnzipFileHook(Archive archive, ITaskMonitor monitor, IFileOp fileOp, File unzippedFile, ZipArchiveEntry zipEntry) {
        super.postUnzipFileHook(archive, monitor, fileOp, unzippedFile, zipEntry);
        if (fileOp.isFile(unzippedFile) && !"source.properties".equals(unzippedFile.getName())) {
            fileOp.setReadOnly(unzippedFile);
        }
    }

    @Override
    public boolean sameItemAs(Package pkg) {
        if (pkg instanceof SourcePackage) {
            SourcePackage newPkg = (SourcePackage)pkg;
            return this.getAndroidVersion().equals(newPkg.getAndroidVersion());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.mVersion == null ? 0 : this.mVersion.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SourcePackage)) {
            return false;
        }
        SourcePackage other = (SourcePackage)obj;
        return !(this.mVersion == null ? other.mVersion != null : !this.mVersion.equals(other.mVersion));
    }
}

