/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gwt.build;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.BidirectionalMultiMap;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.execution.ParametersListUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.gwt.build.GwtBuildTarget;
import org.jetbrains.jps.gwt.build.GwtBuildTargetType;
import org.jetbrains.jps.gwt.build.GwtBuilderMessages;
import org.jetbrains.jps.gwt.build.GwtBuilderParameters;
import org.jetbrains.jps.gwt.build.GwtExternalCompilerProcessHandler;
import org.jetbrains.jps.gwt.build.JpsGwtClasspathUtil;
import org.jetbrains.jps.gwt.build.JpsGwtCompilerPaths;
import org.jetbrains.jps.gwt.index.JpsGwtModule;
import org.jetbrains.jps.gwt.index.JpsGwtModuleIndex;
import org.jetbrains.jps.gwt.model.GwtSdkPaths;
import org.jetbrains.jps.gwt.model.JpsGwtCompilerProjectExtension;
import org.jetbrains.jps.gwt.model.JpsGwtExtensionService;
import org.jetbrains.jps.gwt.model.JpsGwtModuleExtension;
import org.jetbrains.jps.gwt.model.impl.JpsGwtCompilerProjectExtensionImpl;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ExternalProcessUtil;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.TargetBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;

public class GwtBuilder
extends TargetBuilder<BuildRootDescriptor, GwtBuildTarget> {
    public static final String NAME = "GWT Compiler";

    public GwtBuilder() {
        super(Collections.singletonList(GwtBuildTargetType.INSTANCE));
    }

    public void build(@NotNull GwtBuildTarget target, @NotNull DirtyFilesHolder<BuildRootDescriptor, GwtBuildTarget> holder, @NotNull BuildOutputConsumer outputConsumer, @NotNull CompileContext context) throws ProjectBuildException, IOException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jps/gwt/build/GwtBuilder", "build"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/jps/gwt/build/GwtBuilder", "build"));
        }
        if (outputConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputConsumer", "org/jetbrains/jps/gwt/build/GwtBuilder", "build"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/gwt/build/GwtBuilder", "build"));
        }
        BuildDataPaths dataPaths = context.getProjectDescriptor().dataManager.getDataPaths();
        JpsGwtModuleIndex index = JpsGwtExtensionService.getInstance().getGwtModuleIndex(context.getProjectDescriptor().getModel(), dataPaths);
        JpsProject project = context.getProjectDescriptor().getProject();
        JpsJavaCompilerConfiguration compilerConfiguration = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(project);
        final BidirectionalMultiMap rootsToModules = new BidirectionalMultiMap((Map)new THashMap(FileUtil.FILE_HASHING_STRATEGY), (Map)new HashMap());
        JpsGwtModuleExtension extension = target.getExtension();
        String compileReportModuleName = extension.getModule().getName().equals(GwtBuilderParameters.getCompileReportModuleName(context)) ? GwtBuilderParameters.getCompileReportGwtModuleQualifiedName(context) : null;
        final LinkedHashSet<JpsGwtModule> modulesToRecompile = new LinkedHashSet<JpsGwtModule>();
        for (JpsGwtModule gwtModule : index.getModules(extension, true, false)) {
            if (compilerConfiguration.getCompilerExcludes().isExcluded(gwtModule.getModuleFile())) continue;
            if (gwtModule.getQualifiedName().equals(compileReportModuleName) && index.isCompilable(gwtModule, extension)) {
                modulesToRecompile.add(gwtModule);
            }
            GwtBuilder.collectModuleRoots(gwtModule, (BidirectionalMultiMap<File, JpsGwtModule>)rootsToModules, gwtModule);
            for (JpsGwtModule module : index.getInheritedModules(gwtModule)) {
                GwtBuilder.collectModuleRoots(module, (BidirectionalMultiMap<File, JpsGwtModule>)rootsToModules, gwtModule);
            }
        }
        holder.processDirtyFiles((FileProcessor)new FileProcessor<BuildRootDescriptor, GwtBuildTarget>(){

            public boolean apply(GwtBuildTarget target, File file, BuildRootDescriptor root) throws IOException {
                GwtBuilder.collectModulesToRecompile(file, root, (BidirectionalMultiMap<File, JpsGwtModule>)rootsToModules, modulesToRecompile);
                return true;
            }
        });
        Collection removedFiles = holder.getRemovedFiles((BuildTarget)target);
        for (String path : removedFiles) {
            GwtBuilder.collectModulesToRecompile(new File(path), null, (BidirectionalMultiMap<File, JpsGwtModule>)rootsToModules, modulesToRecompile);
        }
        for (JpsGwtModule module : modulesToRecompile) {
            if (!index.isCompilable(module, extension)) continue;
            GwtBuilder.compile(target, module, rootsToModules.getKeys((Object)module), module.getQualifiedName().equals(compileReportModuleName), outputConsumer, context);
        }
    }

    private static void collectModulesToRecompile(File file, @Nullable BuildRootDescriptor root, BidirectionalMultiMap<File, JpsGwtModule> modulesByRoots, Set<JpsGwtModule> modulesToRecompile) {
        File current = file;
        do {
            modulesToRecompile.addAll(modulesByRoots.getValues((Object)current));
        } while ((current = FileUtil.getParentFile((File)current)) != null && (root == null || !FileUtil.filesEqual((File)current, (File)root.getRootFile())));
    }

    private static void collectModuleRoots(JpsGwtModule moduleToGetRoots, BidirectionalMultiMap<File, JpsGwtModule> modulesByRoots, JpsGwtModule targetModule) {
        modulesByRoots.put((Object)moduleToGetRoots.getModuleFile(), (Object)targetModule);
        for (File root : moduleToGetRoots.getSourceRoots(false)) {
            modulesByRoots.put((Object)root, (Object)targetModule);
        }
        for (File root : moduleToGetRoots.getPublicRoots(false)) {
            modulesByRoots.put((Object)root, (Object)targetModule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compile(GwtBuildTarget target, final JpsGwtModule gwtModule, Set<File> roots, boolean generateReport, BuildOutputConsumer outputConsumer, final CompileContext context) throws IOException, ProjectBuildException {
        context.processMessage((BuildMessage)new ProgressMessage("Compiling GWT module '" + gwtModule.getQualifiedName() + "'"));
        JpsGwtModuleExtension extension = target.getExtension();
        JpsModule module = extension.getModule();
        JpsSdk sdk = JavaBuilderUtil.ensureModuleHasJdk((JpsModule)module, (CompileContext)context, (String)NAME);
        BuildDataPaths dataPaths = context.getProjectDescriptor().dataManager.getDataPaths();
        File outputDir = JpsGwtCompilerPaths.getCompilerOutputRoot(target, dataPaths);
        outputDir.mkdirs();
        if (context.getLoggingManager().getProjectBuilderLogger().isEnabled()) {
            context.getLoggingManager().getProjectBuilderLogger().logCompiledFiles(Collections.singletonList(gwtModule.getModuleFile()), NAME, "Compiling GWT modules:");
        }
        Collection<File> sourceRoots = JpsGwtClasspathUtil.getSourceRootsOfGwtModules(extension.getModule(), true);
        List<String> classpath = GwtBuilder.createClasspath(extension, sourceRoots);
        ArrayList<String> vmOptions = new ArrayList<String>();
        vmOptions.addAll(ParametersListUtil.parse((String)extension.getAdditionalCompilerVMParameters()));
        vmOptions.add("-Xmx" + extension.getCompilerMaximumHeapSize() + "m");
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.addAll(ParametersListUtil.parse((String)extension.getCompilerParameters()));
        File extraOutputRoot = JpsGwtCompilerPaths.getExtraOutputRoot(target, dataPaths);
        if (generateReport) {
            parameters.add("-compileReport");
            parameters.add("-extra");
            parameters.add(extraOutputRoot.getAbsolutePath());
        }
        parameters.addAll(Arrays.asList("-logLevel", "TRACE"));
        parameters.addAll(Arrays.asList("-war", outputDir.getAbsolutePath()));
        parameters.addAll(Arrays.asList("-style", extension.getOutputStyle().getId()));
        parameters.add(gwtModule.getQualifiedName());
        List commandLine = ExternalProcessUtil.buildJavaCommandLine((String)JpsJavaSdkType.getJavaExecutable((JpsSdk)sdk), (String)"com.google.gwt.dev.Compiler", Collections.emptyList(), classpath, vmOptions, parameters, (boolean)false);
        Process process = new ProcessBuilder(new String[0]).command(commandLine).directory(outputDir).start();
        String moduleFileUrl = JpsPathUtil.pathToUrl((String)FileUtil.toSystemIndependentName((String)gwtModule.getModuleFile().getAbsolutePath()));
        JpsGwtCompilerProjectExtension compilerProjectExtension = (JpsGwtCompilerProjectExtension)extension.getModule().getProject().getContainer().getChild(JpsGwtCompilerProjectExtensionImpl.ROLE);
        boolean showCompilerOutput = compilerProjectExtension != null && compilerProjectExtension.isShowCompilerOutput(extension);
        GwtExternalCompilerProcessHandler handler = new GwtExternalCompilerProcessHandler(process, moduleFileUrl, sourceRoots, context);
        if (showCompilerOutput) {
            GwtBuilderMessages.sendCompilationStartedMessage(context, gwtModule);
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(ProcessEvent event, Key outputType) {
                    GwtBuilderMessages.sendLogMessage(context, gwtModule, event.getText());
                }
            });
        }
        try {
            handler.startNotify();
            handler.waitForTerminationOrCancellation();
            context.checkCanceled();
            if (generateReport) {
                GwtBuilderMessages.sendCompileReportGenerated(context, gwtModule, new File(extraOutputRoot, gwtModule.getOutputName()).getAbsolutePath());
            }
        }
        finally {
            if (showCompilerOutput) {
                GwtBuilderMessages.sendCompilationFinishedMessage(context, gwtModule);
            }
        }
        ArrayList<String> sourceFiles = new ArrayList<String>();
        CollectPathsProcessor processor = new CollectPathsProcessor(sourceFiles);
        for (File root : roots) {
            FileUtil.processFilesRecursively((File)root, (Processor)processor);
        }
        outputConsumer.registerOutputDirectory(outputDir, sourceFiles);
    }

    private static List<String> createClasspath(JpsGwtModuleExtension extension, Collection<File> sourceRoots) {
        ArrayList<File> roots = new ArrayList<File>();
        roots.addAll(sourceRoots);
        roots.addAll(JpsJavaExtensionService.dependencies((JpsModule)extension.getModule()).productionOnly().recursively().classes().getRoots());
        ArrayList<String> classpath = new ArrayList<String>();
        GwtSdkPaths sdkPaths = extension.getSdkPaths();
        classpath.add(sdkPaths.getDevJarPath(true));
        for (File root : roots) {
            classpath.add(root.getAbsolutePath());
        }
        classpath.addAll(sdkPaths.getAdditionalCompilerJars());
        return classpath;
    }

    @NotNull
    public String getPresentableName() {
        if (NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/build/GwtBuilder", "getPresentableName"));
        }
        return NAME;
    }

    private static class CollectPathsProcessor
    implements Processor<File> {
        private final List<String> myResult;

        public CollectPathsProcessor(List<String> result) {
            this.myResult = result;
        }

        public boolean process(File file) {
            if (file.isFile()) {
                this.myResult.add(file.getAbsolutePath());
            }
            return true;
        }
    }
}

