/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.local.LocalSdk;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.android.model.JpsAndroidSdkProperties;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.library.sdk.JpsSdk;

public class AndroidPlatform {
    private final JpsSdk<JpsSimpleElement<JpsAndroidSdkProperties>> mySdk;
    private final IAndroidTarget myTarget;
    private final int myPlatformToolsRevision;
    private final int mySdkToolsRevision;
    private final LocalSdk myLocalSdk;

    public AndroidPlatform(@NotNull JpsSdk<JpsSimpleElement<JpsAndroidSdkProperties>> sdk, @NotNull IAndroidTarget target, @NotNull LocalSdk localSdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/jps/android/AndroidPlatform", "<init>"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jps/android/AndroidPlatform", "<init>"));
        }
        if (localSdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localSdk", "org/jetbrains/jps/android/AndroidPlatform", "<init>"));
        }
        this.mySdk = sdk;
        this.myTarget = target;
        String homePath = sdk.getHomePath();
        this.myPlatformToolsRevision = AndroidCommonUtils.parsePackageRevision(homePath, "platform-tools");
        this.mySdkToolsRevision = AndroidCommonUtils.parsePackageRevision(homePath, "tools");
        this.myLocalSdk = localSdk;
    }

    @NotNull
    public JpsSdk<JpsSimpleElement<JpsAndroidSdkProperties>> getSdk() {
        JpsSdk<JpsSimpleElement<JpsAndroidSdkProperties>> jpsSdk = this.mySdk;
        if (jpsSdk == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidPlatform", "getSdk"));
        }
        return jpsSdk;
    }

    @NotNull
    public IAndroidTarget getTarget() {
        IAndroidTarget iAndroidTarget = this.myTarget;
        if (iAndroidTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidPlatform", "getTarget"));
        }
        return iAndroidTarget;
    }

    public int getPlatformToolsRevision() {
        return this.myPlatformToolsRevision;
    }

    public int getSdkToolsRevision() {
        return this.mySdkToolsRevision;
    }

    public boolean needToAddAnnotationsJarToClasspath() {
        return this.myTarget.getVersion().getApiLevel() <= 15;
    }

    @NotNull
    public LocalSdk getLocalSdk() {
        LocalSdk localSdk = this.myLocalSdk;
        if (localSdk == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidPlatform", "getLocalSdk"));
        }
        return localSdk;
    }
}

