/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.build;

import com.intellij.lang.aspectj.build.AjAspectPathIndex;
import com.intellij.lang.aspectj.build.AjBuilderBase;
import com.intellij.lang.aspectj.build.AjJpsBundle;
import com.intellij.lang.aspectj.build.AjJpsCompiler;
import com.intellij.lang.aspectj.build.config.AjCompilerSettings;
import com.intellij.lang.aspectj.build.config.AjJpsModuleSettings;
import com.intellij.lang.aspectj.build.config.AjModuleSettings;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.impl.java.JavacCompilerTool;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.BuilderRegistry;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.fs.CompilationRound;
import org.jetbrains.jps.incremental.java.JavaBuilder;
import org.jetbrains.jps.model.module.JpsModule;

public class AjTranslatingBuilder
extends AjBuilderBase {
    public static final String AJC_MAIN_CLASS = "org.aspectj.tools.ajc.Main";
    private static final List<String> COMPILABLE_FILE_EXTENSIONS = Arrays.asList("java", "aj");
    private static final Set<String> SOURCE_EXTENSIONS = new THashSet(COMPILABLE_FILE_EXTENSIONS, FileUtil.PATH_HASHING_STRATEGY);
    private AjAspectPathIndex myIndex;

    public AjTranslatingBuilder() {
        super(BuilderCategory.TRANSLATOR, AJC_MAIN_CLASS);
    }

    public void buildStarted(CompileContext context) {
        try {
            File root = context.getProjectDescriptor().dataManager.getDataPaths().getDataStorageRoot();
            this.myIndex = (AjAspectPathIndex)AjAspectPathIndex.PROVIDER.createStorage(root);
            if (JavaBuilderUtil.isForcedRecompilationAllJavaModules((CompileContext)context)) {
                this.myIndex.clean();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void buildFinished(CompileContext context) {
        try {
            this.myIndex.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ModuleLevelBuilder.ExitCode doBuild(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> holder, @NotNull ModuleLevelBuilder.OutputConsumer consumer, @NotNull AjCompilerSettings settings) throws ProjectBuildException, IOException, AjBuilderBase.AjBuildException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/aspectj/build/AjTranslatingBuilder", "doBuild"));
        }
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "com/intellij/lang/aspectj/build/AjTranslatingBuilder", "doBuild"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/aspectj/build/AjTranslatingBuilder", "doBuild"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/aspectj/build/AjTranslatingBuilder", "doBuild"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/aspectj/build/AjTranslatingBuilder", "doBuild"));
        }
        LOG.debug("chunk: " + chunk);
        List<File> toCompile = AjTranslatingBuilder.collectFiles(holder);
        if (toCompile.isEmpty() && !holder.hasRemovedFiles()) {
            LOG.debug("no files");
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        Set modules = chunk.getModules();
        if (settings.delegateToJavac && AjTranslatingBuilder.canDelegate(modules)) {
            List builders = BuilderRegistry.getInstance().getBuilders(BuilderCategory.TRANSLATOR);
            for (ModuleLevelBuilder builder : builders) {
                if (!(builder instanceof JavaBuilder)) continue;
                LOG.info("delegating to Java builder");
                return ((JavaBuilder)builder).doBuild(context, chunk, holder, consumer, (JavaCompilingTool)new JavacCompilerTool());
            }
            LOG.error("no Java builder among " + builders);
            context.processMessage(AjTranslatingBuilder.error("Internal error: Java builder missing"));
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
        if (modules.size() > 1) {
            String names = ContainerUtilRt.map2List((Collection)modules, (Function)new Function<JpsModule, String>(){

                public String fun(JpsModule module) {
                    return module.getName();
                }
            }).toString();
            context.processMessage(AjTranslatingBuilder.error(AjJpsBundle.message("aj.too.many.modules", names)));
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
        ModuleLevelBuilder.ExitCode result = ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        for (ModuleBuildTarget target : chunk.getTargets()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("starting ajc for target: " + target);
            }
            ModuleLevelBuilder.ExitCode targetResult = new AjJpsCompiler(context, this.myIndex, chunk, toCompile, target, settings, consumer).build();
            if (LOG.isDebugEnabled()) {
                LOG.debug("finished ajc for target: " + target + ", result: " + targetResult);
            }
            if (targetResult.compareTo((Enum)result) > 0) {
                result = targetResult;
            }
            if (result != ModuleLevelBuilder.ExitCode.ABORT && result != ModuleLevelBuilder.ExitCode.CHUNK_REBUILD_REQUIRED) continue;
            break;
        }
        if (result == ModuleLevelBuilder.ExitCode.CHUNK_REBUILD_REQUIRED) {
            FSOperations.markDirtyRecursively((CompileContext)context, (CompilationRound)CompilationRound.NEXT, (ModuleChunk)chunk);
        }
        return result;
    }

    private static List<File> collectFiles(DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> holder) throws IOException {
        final List files = ContainerUtil.newSmartList();
        holder.processDirtyFiles((FileProcessor)new FileProcessor<JavaSourceRootDescriptor, ModuleBuildTarget>(){

            public boolean apply(ModuleBuildTarget target, File file, JavaSourceRootDescriptor sourceRoot) throws IOException {
                if (AjTranslatingBuilder.isSourceFile(file)) {
                    files.add(file);
                }
                return true;
            }
        });
        return files;
    }

    public static boolean isSourceFile(File file) {
        return SOURCE_EXTENSIONS.contains(FileUtilRt.getExtension((String)file.getName()));
    }

    private static boolean canDelegate(Set<JpsModule> modules) {
        for (JpsModule module : modules) {
            AjModuleSettings settings = AjJpsModuleSettings.getSettings(module);
            if (settings == null || settings.weaveOnly) continue;
            return false;
        }
        return true;
    }

    public List<String> getCompilableFileExtensions() {
        return COMPILABLE_FILE_EXTENSIONS;
    }
}

