/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.Function;
import com.intellij.util.containers.FilteredTraverser;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class JBSwingUtilities {
    public static final Key<Iterable<? extends Component>> NOT_IN_HIERARCHY_COMPONENTS = Key.create("NOT_IN_HIERARCHY_COMPONENTS");
    private static final boolean LEGACY_JDK = !SystemInfo.isJavaVersionAtLeast("1.8");
    private static final Function<Component, Iterable<Component>> COMPONENT_CHILDREN = new Function<Component, Iterable<Component>>(){

        @Override
        @NotNull
        public JBIterable<Component> fun(@NotNull Component c) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/ui/JBSwingUtilities$1", "fun"));
            }
            JBIterable<Object> result = c instanceof JMenu ? JBIterable.of(((JMenu)c).getMenuComponents()) : (c instanceof Container ? JBIterable.of(((Container)c).getComponents()) : JBIterable.empty());
            if (c instanceof JComponent) {
                JPopupMenu jpm;
                JComponent jc = (JComponent)c;
                Iterable<? extends Component> orphans = UIUtil.getClientProperty(jc, NOT_IN_HIERARCHY_COMPONENTS);
                if (orphans != null) {
                    result = result.append(orphans);
                }
                if ((jpm = jc.getComponentPopupMenu()) != null && jpm.isVisible() && jpm.getInvoker() == jc) {
                    result = result.append(Collections.singletonList(jpm));
                }
            }
            JBIterable<Component> jBIterable = result;
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/JBSwingUtilities$1", "fun"));
            }
            return jBIterable;
        }
    };

    public static boolean isLeftMouseButton(MouseEvent anEvent) {
        return LEGACY_JDK ? (anEvent.getModifiersEx() & 0x400) > 0 : SwingUtilities.isLeftMouseButton(anEvent);
    }

    public static boolean isMiddleMouseButton(MouseEvent anEvent) {
        return LEGACY_JDK ? (anEvent.getModifiersEx() & 0x800) > 0 : SwingUtilities.isMiddleMouseButton(anEvent);
    }

    public static boolean isRightMouseButton(MouseEvent anEvent) {
        return LEGACY_JDK ? (anEvent.getModifiersEx() & 0x1000) > 0 : SwingUtilities.isRightMouseButton(anEvent);
    }

    @NotNull
    public static FilteredTraverser<Component> uiTraverser() {
        FilteredTraverser<Component> filteredTraverser = new FilteredTraverser<Component>(COMPONENT_CHILDREN);
        if (filteredTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/JBSwingUtilities", "uiTraverser"));
        }
        return filteredTraverser;
    }
}

