/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cmdline;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class LogSetup {
    private static final String LOG_CONFIG_FILE_NAME = "build-log.properties";
    private static final String LOG_FILE_NAME = "build.log";
    private static final String DEFAULT_LOGGER_CONFIG = "defaultLogConfig.properties";
    private static final String LOG_FILE_MACRO = "$LOG_FILE_PATH$";

    public static void initLoggers() {
        try {
            String logDir = System.getProperty("jps.log.dir", null);
            File configFile = logDir != null ? new File(logDir, LOG_CONFIG_FILE_NAME) : new File(LOG_CONFIG_FILE_NAME);
            LogSetup.ensureLogConfigExists(configFile);
            String text = FileUtil.loadFile((File)configFile);
            String logFile = logDir != null ? new File(logDir, LOG_FILE_NAME).getAbsolutePath() : LOG_FILE_NAME;
            text = StringUtil.replace((String)text, (String)LOG_FILE_MACRO, (String)StringUtil.replace((String)logFile, (String)"\\", (String)"\\\\"));
            PropertyConfigurator.configure((InputStream)new ByteArrayInputStream(text.getBytes("UTF-8")));
        }
        catch (IOException e) {
            System.err.println("Failed to configure logging: ");
            e.printStackTrace(System.err);
        }
        com.intellij.openapi.diagnostic.Logger.setFactory(MyLoggerFactory.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureLogConfigExists(File logConfig) throws IOException {
        if (!logConfig.exists()) {
            FileUtil.createIfDoesntExist((File)logConfig);
            InputStream in = LogSetup.class.getResourceAsStream("/defaultLogConfig.properties");
            if (in != null) {
                try {
                    FileOutputStream out = new FileOutputStream(logConfig);
                    try {
                        FileUtil.copy((InputStream)in, (OutputStream)out);
                    }
                    finally {
                        out.close();
                    }
                }
                finally {
                    in.close();
                }
            }
        }
    }

    private static class MyLoggerFactory
    implements Logger.Factory {
        private MyLoggerFactory() {
        }

        public com.intellij.openapi.diagnostic.Logger getLoggerInstance(String category) {
            final Logger logger = Logger.getLogger((String)category);
            return new com.intellij.openapi.diagnostic.Logger(){

                public boolean isDebugEnabled() {
                    return logger.isDebugEnabled();
                }

                public void debug(@NonNls String message) {
                    logger.debug((Object)message);
                }

                public void debug(@Nullable Throwable t) {
                    logger.debug((Object)"", t);
                }

                public void debug(@NonNls String message, @Nullable Throwable t) {
                    logger.debug((Object)message, t);
                }

                public void error(@NonNls String message, @Nullable Throwable t, String ... details) {
                    if (details == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "org/jetbrains/jps/cmdline/LogSetup$MyLoggerFactory$1", "error"));
                    }
                    logger.error((Object)message, t);
                }

                public void info(@NonNls String message) {
                    logger.info((Object)message);
                }

                public void info(@NonNls String message, @Nullable Throwable t) {
                    logger.info((Object)message, t);
                }

                public void warn(@NonNls String message, @Nullable Throwable t) {
                    logger.warn((Object)message, t);
                }

                public void setLevel(Level level) {
                    logger.setLevel(level);
                }
            };
        }
    }
}

