/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.internal.PngCruncher;
import com.android.ide.common.internal.PngException;
import com.android.ide.common.res2.DataFile;
import com.android.ide.common.res2.MergeConsumer;
import com.android.ide.common.res2.MergeWriter;
import com.android.ide.common.res2.MergingException;
import com.android.ide.common.res2.NodeUtils;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MergedResourceWriter
extends MergeWriter<ResourceItem> {
    @NonNull
    private final PngCruncher mCruncher;
    private final File mPublicFile;
    private DocumentBuilderFactory mFactory;
    private boolean mInsertSourceMarkers = true;
    private final boolean mCrunchPng;
    private final boolean mProcess9Patch;
    private final int mCruncherKey;
    private ListMultimap<String, ResourceItem> mValuesResMap;
    private Set<String> mQualifierWithDeletedValues;

    public MergedResourceWriter(@NonNull File rootFolder, @NonNull PngCruncher pngRunner, boolean crunchPng, boolean process9Patch, @Nullable File publicFile) {
        super(rootFolder);
        this.mCruncher = pngRunner;
        this.mCruncherKey = this.mCruncher.start();
        this.mCrunchPng = crunchPng;
        this.mProcess9Patch = process9Patch;
        this.mPublicFile = publicFile;
    }

    public void setInsertSourceMarkers(boolean insertSourceMarkers) {
        this.mInsertSourceMarkers = insertSourceMarkers;
    }

    public boolean isInsertSourceMarkers() {
        return this.mInsertSourceMarkers;
    }

    @Override
    public void start(@NonNull DocumentBuilderFactory factory) throws MergeConsumer.ConsumerException {
        super.start(factory);
        this.mValuesResMap = ArrayListMultimap.create();
        this.mQualifierWithDeletedValues = Sets.newHashSet();
        this.mFactory = factory;
    }

    @Override
    public void end() throws MergeConsumer.ConsumerException {
        super.end();
        try {
            this.mCruncher.end(this.mCruncherKey);
        }
        catch (InterruptedException e) {
            throw new MergeConsumer.ConsumerException(e);
        }
        this.mValuesResMap = null;
        this.mQualifierWithDeletedValues = null;
        this.mFactory = null;
    }

    @Override
    public boolean ignoreItemInMerge(ResourceItem item) {
        return item.getIgnoredFromDiskMerge();
    }

    @Override
    public void addItem(final @NonNull ResourceItem item) throws MergeConsumer.ConsumerException {
        DataFile.FileType type = item.getSourceType();
        if (type == DataFile.FileType.MULTI) {
            this.mValuesResMap.put((Object)item.getQualifiers(), (Object)item);
        } else if (item.isTouched()) {
            this.getExecutor().execute(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ResourceFile resourceFile = (ResourceFile)item.getSource();
                    File file = resourceFile.getFile();
                    String filename = file.getName();
                    String folderName = MergedResourceWriter.getFolderName(item);
                    File typeFolder = new File(MergedResourceWriter.this.getRootFolder(), folderName);
                    try {
                        MergedResourceWriter.this.createDir(typeFolder);
                    }
                    catch (IOException ioe) {
                        throw MergingException.wrapException(ioe).withFile(typeFolder).build();
                    }
                    File outFile = new File(typeFolder, filename);
                    try {
                        if (item.getType() == ResourceType.RAW) {
                            Files.copy((File)file, (File)outFile);
                        } else if (filename.endsWith(".png")) {
                            if (MergedResourceWriter.this.mCrunchPng && MergedResourceWriter.this.mProcess9Patch) {
                                MergedResourceWriter.this.mCruncher.crunchPng(MergedResourceWriter.this.mCruncherKey, file, outFile);
                            } else if (MergedResourceWriter.this.mProcess9Patch && filename.endsWith(".9.png")) {
                                MergedResourceWriter.this.mCruncher.crunchPng(MergedResourceWriter.this.mCruncherKey, file, outFile);
                            } else {
                                Files.copy((File)file, (File)outFile);
                            }
                        } else if (MergedResourceWriter.this.mInsertSourceMarkers && filename.endsWith(".xml")) {
                            SdkUtils.copyXmlWithSourceReference((File)file, (File)outFile);
                        } else {
                            Files.copy((File)file, (File)outFile);
                        }
                    }
                    catch (PngException e) {
                        throw MergingException.wrapException(e).withFile(file).build();
                    }
                    catch (IOException ioe) {
                        throw MergingException.wrapException(ioe).withFile(file).build();
                    }
                    return null;
                }
            });
        }
    }

    @Override
    public void removeItem(@NonNull ResourceItem removedItem, @Nullable ResourceItem replacedBy) throws MergeConsumer.ConsumerException {
        DataFile.FileType replacedType;
        DataFile.FileType removedType = removedItem.getSourceType();
        DataFile.FileType fileType = replacedType = replacedBy != null ? replacedBy.getSourceType() : null;
        if (removedType == replacedType) {
            if (removedType == DataFile.FileType.MULTI) {
                this.mQualifierWithDeletedValues.add(removedItem.getQualifiers());
            }
        } else if (removedType == DataFile.FileType.SINGLE) {
            this.removeOutFile(removedItem);
        } else {
            this.mQualifierWithDeletedValues.add(removedItem.getQualifiers());
        }
    }

    @Override
    protected void postWriteAction() throws MergeConsumer.ConsumerException {
        for (String key : this.mValuesResMap.keySet()) {
            boolean mustWriteFile = this.mQualifierWithDeletedValues.remove(key);
            List items = this.mValuesResMap.get((Object)key);
            if (!mustWriteFile) {
                for (ResourceItem item : items) {
                    if (!item.isTouched()) continue;
                    mustWriteFile = true;
                    break;
                }
            }
            if (!mustWriteFile) continue;
            String folderName = key.isEmpty() ? ResourceFolderType.VALUES.getName() : ResourceFolderType.VALUES.getName() + "-" + key;
            File valuesFolder = new File(this.getRootFolder(), folderName);
            File outFile = new File(valuesFolder, folderName + ".xml");
            DataFile currentFile = null;
            try {
                boolean mkdirs;
                this.createDir(valuesFolder);
                DocumentBuilder builder = this.mFactory.newDocumentBuilder();
                Document document = builder.newDocument();
                String publicTag = ResourceType.PUBLIC.getName();
                ArrayList publicNodes = null;
                Element rootNode = document.createElement("resources");
                document.appendChild(rootNode);
                Collections.sort(items);
                for (ResourceItem item : items) {
                    Node nodeValue = item.getValue();
                    if (nodeValue != null && publicTag.equals(nodeValue.getNodeName())) {
                        if (publicNodes == null) {
                            publicNodes = Lists.newArrayList();
                        }
                        publicNodes.add(nodeValue);
                        continue;
                    }
                    rootNode.appendChild(document.createTextNode("\n    "));
                    ResourceFile source = (ResourceFile)item.getSource();
                    if (source != currentFile && source != null && this.mInsertSourceMarkers) {
                        currentFile = source;
                        File file = source.getFile();
                        rootNode.appendChild(document.createComment(SdkUtils.createPathComment((File)file, (boolean)true)));
                        rootNode.appendChild(document.createTextNode("\n    "));
                        rootNode.appendChild(document.createElement("eat-comment"));
                        rootNode.appendChild(document.createTextNode("\n    "));
                    }
                    Node adoptedNode = NodeUtils.adoptNode(document, nodeValue);
                    rootNode.appendChild(adoptedNode);
                }
                rootNode.appendChild(document.createTextNode("\n"));
                currentFile = null;
                String content = XmlUtils.toXml((Node)document, (boolean)true);
                Files.write((CharSequence)content, (File)outFile, (Charset)Charsets.UTF_8);
                if (publicNodes == null || this.mPublicFile == null) continue;
                int size = publicNodes.size();
                StringBuilder sb = new StringBuilder(size * 80);
                for (Node node : publicNodes) {
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    String name = element.getAttribute("name");
                    String type = element.getAttribute("type");
                    if (name.isEmpty() || type.isEmpty()) continue;
                    sb.append(type).append(' ').append(name).append('\n');
                }
                File parentFile = this.mPublicFile.getParentFile();
                if (!parentFile.exists() && !(mkdirs = parentFile.mkdirs())) {
                    throw new IOException("Could not create " + parentFile);
                }
                String text = sb.toString();
                Files.write((CharSequence)text, (File)this.mPublicFile, (Charset)Charsets.UTF_8);
            }
            catch (Throwable t) {
                MergeConsumer.ConsumerException exception = new MergeConsumer.ConsumerException(t, currentFile != null ? currentFile.getFile() : outFile);
                throw exception;
            }
        }
        for (String key : this.mQualifierWithDeletedValues) {
            String folderName = key != null && !key.isEmpty() ? ResourceFolderType.VALUES.getName() + "-" + key : ResourceFolderType.VALUES.getName();
            this.removeOutFile(folderName, folderName + ".xml");
        }
    }

    private boolean removeOutFile(ResourceItem resourceItem) {
        ResourceFile resourceFile = (ResourceFile)resourceItem.getSource();
        if (resourceFile.getType() == DataFile.FileType.MULTI) {
            throw new IllegalArgumentException("SourceFile cannot be a FileType.MULTI");
        }
        File file = resourceFile.getFile();
        String fileName = file.getName();
        String folderName = MergedResourceWriter.getFolderName(resourceItem);
        return this.removeOutFile(folderName, fileName);
    }

    private boolean removeOutFile(String folderName, String fileName) {
        File valuesFolder = new File(this.getRootFolder(), folderName);
        File outFile = new File(valuesFolder, fileName);
        return outFile.delete();
    }

    private synchronized void createDir(File folder) throws IOException {
        if (!folder.isDirectory() && !folder.mkdirs()) {
            throw new IOException("Failed to create directory: " + folder);
        }
    }

    @NonNull
    private static String getFolderName(ResourceItem resourceItem) {
        ResourceType itemType = resourceItem.getType();
        String folderName = itemType.getName();
        String qualifiers = ((ResourceFile)resourceItem.getSource()).getQualifiers();
        if (!qualifiers.isEmpty()) {
            folderName = folderName + "-" + qualifiers;
        }
        return folderName;
    }
}

