/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javaee.build;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.artifacts.builders.ArtifactLayoutCustomizationService;
import org.jetbrains.jps.incremental.artifacts.impl.JpsArtifactUtil;
import org.jetbrains.jps.javaee.model.app.EarArtifactType;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.elements.JpsArchivePackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsDirectoryPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElementFactory;
import org.jetbrains.jps.model.ex.JpsElementBase;

public class ExplodedEarLayoutCustomizationService
extends ArtifactLayoutCustomizationService {
    @Nullable
    public List<JpsPackagingElement> getCustomizedLayout(@NotNull JpsArtifact artifact, @NotNull Collection<JpsArtifact> parentArtifacts) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/jps/javaee/build/ExplodedEarLayoutCustomizationService", "getCustomizedLayout"));
        }
        if (parentArtifacts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentArtifacts", "org/jetbrains/jps/javaee/build/ExplodedEarLayoutCustomizationService", "getCustomizedLayout"));
        }
        if (!artifact.getArtifactType().equals((Object)EarArtifactType.EXPLODED) || !ExplodedEarLayoutCustomizationService.containsEarArtifact(parentArtifacts)) {
            return null;
        }
        ArrayList<JpsPackagingElement> result = new ArrayList<JpsPackagingElement>();
        for (JpsPackagingElement child : artifact.getRootElement().getChildren()) {
            JpsDirectoryPackagingElement directory;
            String directoryName;
            if (child instanceof JpsDirectoryPackagingElement && JpsArtifactUtil.isArchiveName((String)(directoryName = (directory = (JpsDirectoryPackagingElement)child).getDirectoryName()))) {
                JpsArchivePackagingElement archive = JpsPackagingElementFactory.getInstance().createArchive(directoryName);
                for (JpsPackagingElement element : directory.getChildren()) {
                    archive.addChild((JpsPackagingElement)((JpsElementBase)element).createCopy());
                }
                result.add((JpsPackagingElement)archive);
                ((JpsElementBase)archive).setParent((JpsElementBase)artifact);
                continue;
            }
            result.add(child);
        }
        return result;
    }

    private static boolean containsEarArtifact(Collection<JpsArtifact> artifacts) {
        for (JpsArtifact artifact : artifacts) {
            if (!artifact.getArtifactType().equals((Object)EarArtifactType.EAR)) continue;
            return true;
        }
        return false;
    }
}

