/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionAdapter;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamVisitor;
import io.netty.handler.codec.http2.PriorityStreamByteDistributor;
import io.netty.handler.codec.http2.StreamByteDistributor;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayDeque;
import java.util.Deque;

public class DefaultHttp2RemoteFlowController
implements Http2RemoteFlowController {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultHttp2RemoteFlowController.class);
    private static final int MIN_WRITABLE_CHUNK = 32768;
    private final Http2Connection connection;
    private final Http2Connection.PropertyKey stateKey;
    private final StreamByteDistributor streamByteDistributor;
    private final AbstractState connectionState;
    private int initialWindowSize = 65535;
    private WritabilityMonitor monitor;
    private ChannelHandlerContext ctx;

    public DefaultHttp2RemoteFlowController(Http2Connection connection) {
        this(connection, (Http2RemoteFlowController.Listener)null);
    }

    public DefaultHttp2RemoteFlowController(Http2Connection connection, StreamByteDistributor streamByteDistributor) {
        this(connection, streamByteDistributor, null);
    }

    public DefaultHttp2RemoteFlowController(Http2Connection connection, Http2RemoteFlowController.Listener listener) {
        this(connection, new PriorityStreamByteDistributor(connection), listener);
    }

    public DefaultHttp2RemoteFlowController(Http2Connection connection, StreamByteDistributor streamByteDistributor, Http2RemoteFlowController.Listener listener) {
        this.connection = ObjectUtil.checkNotNull(connection, "connection");
        this.streamByteDistributor = ObjectUtil.checkNotNull(streamByteDistributor, "streamWriteDistributor");
        this.stateKey = connection.newKey();
        this.connectionState = new DefaultState(connection.connectionStream(), this.initialWindowSize, this.initialWindowSize > 0 && this.isChannelWritable());
        connection.connectionStream().setProperty(this.stateKey, this.connectionState);
        this.listener(listener);
        connection.addListener(new Http2ConnectionAdapter(){

            @Override
            public void onStreamAdded(Http2Stream stream) {
                stream.setProperty(DefaultHttp2RemoteFlowController.this.stateKey, stream.state() == Http2Stream.State.IDLE ? new ReducedState(stream) : new DefaultState(stream, 0, DefaultHttp2RemoteFlowController.this.isWritable(DefaultHttp2RemoteFlowController.this.connection.connectionStream())));
            }

            @Override
            public void onStreamActive(Http2Stream stream) {
                AbstractState state = DefaultHttp2RemoteFlowController.this.state(stream);
                if (state.getClass() == DefaultState.class) {
                    state.window(DefaultHttp2RemoteFlowController.this.initialWindowSize);
                } else {
                    stream.setProperty(DefaultHttp2RemoteFlowController.this.stateKey, new DefaultState(state, DefaultHttp2RemoteFlowController.this.initialWindowSize));
                }
            }

            @Override
            public void onStreamClosed(Http2Stream stream) {
                AbstractState state = DefaultHttp2RemoteFlowController.this.state(stream);
                state.cancel();
                if (stream.prioritizableForTree() != 0) {
                    state = new ReducedState(state);
                    stream.setProperty(DefaultHttp2RemoteFlowController.this.stateKey, state);
                }
                DefaultHttp2RemoteFlowController.this.monitor.stateCancelled(state);
            }

            @Override
            public void onStreamHalfClosed(Http2Stream stream) {
                if (Http2Stream.State.HALF_CLOSED_LOCAL.equals((Object)stream.state())) {
                    AbstractState state = DefaultHttp2RemoteFlowController.this.state(stream);
                    state.cancel();
                    DefaultHttp2RemoteFlowController.this.monitor.stateCancelled(state);
                }
            }
        });
    }

    @Override
    public void channelHandlerContext(ChannelHandlerContext ctx) throws Http2Exception {
        this.ctx = ObjectUtil.checkNotNull(ctx, "ctx");
        this.channelWritabilityChanged();
        if (this.isChannelWritable()) {
            this.writePendingBytes();
        }
    }

    @Override
    public ChannelHandlerContext channelHandlerContext() {
        return this.ctx;
    }

    @Override
    public void initialWindowSize(int newWindowSize) throws Http2Exception {
        assert (this.ctx == null || this.ctx.executor().inEventLoop());
        this.monitor.initialWindowSize(newWindowSize);
    }

    @Override
    public int initialWindowSize() {
        return this.initialWindowSize;
    }

    @Override
    public int windowSize(Http2Stream stream) {
        return this.state(stream).windowSize();
    }

    @Override
    public boolean isWritable(Http2Stream stream) {
        return this.monitor.isWritable(this.state(stream));
    }

    @Override
    public void channelWritabilityChanged() throws Http2Exception {
        this.monitor.channelWritabilityChange();
    }

    private boolean isChannelWritable() {
        return this.ctx != null && this.isChannelWritable0();
    }

    private boolean isChannelWritable0() {
        return this.ctx.channel().isWritable();
    }

    @Override
    public void listener(Http2RemoteFlowController.Listener listener) {
        this.monitor = listener == null ? new DefaultWritabilityMonitor() : new ListenerWritabilityMonitor(listener);
    }

    @Override
    public int initialWindowSize(Http2Stream stream) {
        return this.state(stream).initialWindowSize();
    }

    @Override
    public void incrementWindowSize(Http2Stream stream, int delta) throws Http2Exception {
        assert (this.ctx == null || this.ctx.executor().inEventLoop());
        this.monitor.incrementWindowSize(this.state(stream), delta);
    }

    @Override
    public void addFlowControlled(Http2Stream stream, Http2RemoteFlowController.FlowControlled frame) {
        assert (this.ctx == null || this.ctx.executor().inEventLoop());
        ObjectUtil.checkNotNull(frame, "frame");
        try {
            this.monitor.enqueueFrame(this.state(stream), frame);
        }
        catch (Throwable t) {
            frame.error(this.ctx, t);
        }
    }

    private AbstractState state(Http2Stream stream) {
        return (AbstractState)ObjectUtil.checkNotNull(stream, "stream").getProperty(this.stateKey);
    }

    private int connectionWindowSize() {
        return this.connectionState.windowSize();
    }

    private int minUsableChannelBytes() {
        return Math.max(this.ctx.channel().config().getWriteBufferLowWaterMark(), 32768);
    }

    private int maxUsableChannelBytes() {
        int channelWritableBytes = (int)Math.min(Integer.MAX_VALUE, this.ctx.channel().bytesBeforeUnwritable());
        int useableBytes = channelWritableBytes > 0 ? Math.max(channelWritableBytes, this.minUsableChannelBytes()) : 0;
        return Math.min(this.connectionState.windowSize(), useableBytes);
    }

    private int writableBytes() {
        return Math.min(this.connectionWindowSize(), this.maxUsableChannelBytes());
    }

    @Override
    public void writePendingBytes() throws Http2Exception {
        this.monitor.writePendingBytes();
    }

    private final class ListenerWritabilityMonitor
    extends WritabilityMonitor {
        private final Http2RemoteFlowController.Listener listener;
        private final Http2StreamVisitor checkStreamWritabilityVisitor;
        private final StreamByteDistributor.Writer initialWindowSizeWriter;
        private final StreamByteDistributor.Writer writeAllocatedBytesWriter;

        ListenerWritabilityMonitor(Http2RemoteFlowController.Listener listener) {
            this.checkStreamWritabilityVisitor = new Http2StreamVisitor(){

                @Override
                public boolean visit(Http2Stream stream) throws Http2Exception {
                    AbstractState state = DefaultHttp2RemoteFlowController.this.state(stream);
                    if (ListenerWritabilityMonitor.this.isWritable(state) != state.markWritability()) {
                        ListenerWritabilityMonitor.this.notifyWritabilityChanged(state);
                    }
                    return true;
                }
            };
            this.initialWindowSizeWriter = new StreamByteDistributor.Writer(){

                @Override
                public void write(Http2Stream stream, int numBytes) {
                    AbstractState state = DefaultHttp2RemoteFlowController.this.state(stream);
                    ListenerWritabilityMonitor.this.writeAllocatedBytes(state, numBytes);
                    if (ListenerWritabilityMonitor.this.isWritable(state) != state.markWritability()) {
                        ListenerWritabilityMonitor.this.notifyWritabilityChanged(state);
                    }
                }
            };
            this.writeAllocatedBytesWriter = new StreamByteDistributor.Writer(){

                @Override
                public void write(Http2Stream stream, int numBytes) {
                    ListenerWritabilityMonitor.this.writeAllocatedBytes(DefaultHttp2RemoteFlowController.this.state(stream), numBytes);
                }
            };
            this.listener = listener;
        }

        @Override
        public void writePendingBytes() throws Http2Exception {
            this.writePendingBytes(this.writeAllocatedBytesWriter);
        }

        @Override
        public void incrementWindowSize(AbstractState state, int delta) throws Http2Exception {
            super.incrementWindowSize(state, delta);
            if (this.isWritable(state) != state.markWritability()) {
                if (state == DefaultHttp2RemoteFlowController.this.connectionState) {
                    this.checkAllWritabilityChanged();
                } else {
                    this.notifyWritabilityChanged(state);
                }
            }
        }

        @Override
        public void initialWindowSize(int newWindowSize) throws Http2Exception {
            if (this.initialWindowSize(newWindowSize, this.initialWindowSizeWriter) && this.isWritableConnection()) {
                this.checkAllWritabilityChanged();
            }
        }

        @Override
        public void enqueueFrame(AbstractState state, Http2RemoteFlowController.FlowControlled frame) throws Http2Exception {
            super.enqueueFrame(state, frame);
            this.checkConnectionThenStreamWritabilityChanged(state);
        }

        @Override
        public void stateCancelled(AbstractState state) {
            try {
                this.checkConnectionThenStreamWritabilityChanged(state);
            }
            catch (Http2Exception e) {
                logger.error("Caught unexpected exception from checkAllWritabilityChanged", e);
            }
        }

        @Override
        public void channelWritabilityChange() throws Http2Exception {
            if (DefaultHttp2RemoteFlowController.this.connectionState.markWritability() != DefaultHttp2RemoteFlowController.this.isChannelWritable()) {
                this.checkAllWritabilityChanged();
            }
        }

        private void notifyWritabilityChanged(AbstractState state) {
            state.markWritability(!state.markWritability());
            try {
                this.listener.writabilityChanged(state.stream);
            }
            catch (RuntimeException e) {
                logger.error("Caught unexpected exception from listener.writabilityChanged", e);
            }
        }

        private void checkConnectionThenStreamWritabilityChanged(AbstractState state) throws Http2Exception {
            if (this.isWritableConnection() != DefaultHttp2RemoteFlowController.this.connectionState.markWritability()) {
                this.checkAllWritabilityChanged();
            } else if (this.isWritable(state) != state.markWritability()) {
                this.notifyWritabilityChanged(state);
            }
        }

        private void checkAllWritabilityChanged() throws Http2Exception {
            DefaultHttp2RemoteFlowController.this.connectionState.markWritability(this.isWritableConnection());
            DefaultHttp2RemoteFlowController.this.connection.forEachActiveStream(this.checkStreamWritabilityVisitor);
        }

        private void writeAllocatedBytes(AbstractState state, int numBytes) {
            int written = state.writeAllocatedBytes(numBytes);
            if (written != -1) {
                this.listener.streamWritten(state.stream(), written);
            }
        }
    }

    private final class DefaultWritabilityMonitor
    extends WritabilityMonitor {
        private final StreamByteDistributor.Writer writer;

        private DefaultWritabilityMonitor() {
            this.writer = new StreamByteDistributor.Writer(){

                @Override
                public void write(Http2Stream stream, int numBytes) {
                    DefaultHttp2RemoteFlowController.this.state(stream).writeAllocatedBytes(numBytes);
                }
            };
        }

        @Override
        public void writePendingBytes() throws Http2Exception {
            this.writePendingBytes(this.writer);
        }

        @Override
        public void initialWindowSize(int newWindowSize) throws Http2Exception {
            this.initialWindowSize(newWindowSize, this.writer);
        }
    }

    private abstract class WritabilityMonitor {
        private long totalPendingBytes;

        private WritabilityMonitor() {
        }

        public abstract void initialWindowSize(int var1) throws Http2Exception;

        public abstract void writePendingBytes() throws Http2Exception;

        public void channelWritabilityChange() throws Http2Exception {
        }

        public void stateCancelled(AbstractState state) {
        }

        public void incrementWindowSize(AbstractState state, int delta) throws Http2Exception {
            state.incrementStreamWindow(delta);
        }

        public void enqueueFrame(AbstractState state, Http2RemoteFlowController.FlowControlled frame) throws Http2Exception {
            state.enqueueFrame(frame);
        }

        public final void incrementPendingBytes(int delta) {
            this.totalPendingBytes += (long)delta;
        }

        public final boolean isWritable(AbstractState state) {
            return this.isWritableConnection() && state.windowSize() - state.pendingBytes() > 0;
        }

        protected final void writePendingBytes(StreamByteDistributor.Writer writer) throws Http2Exception {
            int bytesToWrite = DefaultHttp2RemoteFlowController.this.writableBytes();
            while (DefaultHttp2RemoteFlowController.this.streamByteDistributor.distribute(bytesToWrite, writer) && (bytesToWrite = DefaultHttp2RemoteFlowController.this.writableBytes()) > 0 && DefaultHttp2RemoteFlowController.this.isChannelWritable0()) {
            }
        }

        protected final boolean initialWindowSize(int newWindowSize, StreamByteDistributor.Writer writer) throws Http2Exception {
            if (newWindowSize < 0) {
                throw new IllegalArgumentException("Invalid initial window size: " + newWindowSize);
            }
            final int delta = newWindowSize - DefaultHttp2RemoteFlowController.this.initialWindowSize;
            DefaultHttp2RemoteFlowController.this.initialWindowSize = newWindowSize;
            DefaultHttp2RemoteFlowController.this.connection.forEachActiveStream(new Http2StreamVisitor(){

                @Override
                public boolean visit(Http2Stream stream) throws Http2Exception {
                    DefaultHttp2RemoteFlowController.this.state(stream).incrementStreamWindow(delta);
                    return true;
                }
            });
            if (delta > 0) {
                this.writePendingBytes(writer);
                return false;
            }
            return true;
        }

        protected final boolean isWritableConnection() {
            return (long)DefaultHttp2RemoteFlowController.this.connectionState.windowSize() - this.totalPendingBytes > 0L && DefaultHttp2RemoteFlowController.this.isChannelWritable();
        }
    }

    private abstract class AbstractState
    implements StreamByteDistributor.StreamState {
        protected final Http2Stream stream;
        private boolean markedWritable;

        AbstractState(Http2Stream stream, boolean markedWritable) {
            this.stream = stream;
            this.markedWritable = markedWritable;
        }

        AbstractState(AbstractState existingState) {
            this.stream = existingState.stream();
            this.markedWritable = existingState.markWritability();
        }

        @Override
        public final Http2Stream stream() {
            return this.stream;
        }

        final boolean markWritability() {
            return this.markedWritable;
        }

        final void markWritability(boolean isWritable) {
            this.markedWritable = isWritable;
        }

        abstract int windowSize();

        abstract int initialWindowSize();

        abstract int writeAllocatedBytes(int var1);

        abstract int pendingBytes();

        abstract void cancel();

        abstract void window(int var1);

        abstract int incrementStreamWindow(int var1) throws Http2Exception;

        abstract void enqueueFrame(Http2RemoteFlowController.FlowControlled var1);
    }

    private final class ReducedState
    extends AbstractState {
        ReducedState(Http2Stream stream) {
            super(stream, false);
        }

        ReducedState(AbstractState existingState) {
            super(existingState);
        }

        @Override
        int windowSize() {
            return 0;
        }

        @Override
        int initialWindowSize() {
            return 0;
        }

        @Override
        public int streamableBytes() {
            return 0;
        }

        @Override
        int pendingBytes() {
            return 0;
        }

        @Override
        int writeAllocatedBytes(int allocated) {
            throw new UnsupportedOperationException();
        }

        @Override
        void cancel() {
        }

        @Override
        void window(int initialWindowSize) {
            throw new UnsupportedOperationException();
        }

        @Override
        int incrementStreamWindow(int delta) throws Http2Exception {
            return 0;
        }

        @Override
        void enqueueFrame(Http2RemoteFlowController.FlowControlled frame) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasFrame() {
            return false;
        }
    }

    private final class DefaultState
    extends AbstractState {
        private final Deque<Http2RemoteFlowController.FlowControlled> pendingWriteQueue;
        private int window;
        private int pendingBytes;
        private boolean writing;
        private boolean cancelled;

        DefaultState(Http2Stream stream, int initialWindowSize, boolean markedWritable) {
            super(stream, markedWritable);
            this.window(initialWindowSize);
            this.pendingWriteQueue = new ArrayDeque<Http2RemoteFlowController.FlowControlled>(2);
        }

        DefaultState(AbstractState existingState, int initialWindowSize) {
            super(existingState);
            this.window(initialWindowSize);
            this.pendingWriteQueue = new ArrayDeque<Http2RemoteFlowController.FlowControlled>(2);
        }

        @Override
        int windowSize() {
            return this.window;
        }

        @Override
        int initialWindowSize() {
            return DefaultHttp2RemoteFlowController.this.initialWindowSize;
        }

        @Override
        void window(int initialWindowSize) {
            this.window = initialWindowSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        int writeAllocatedBytes(int allocated) {
            try {
                int n = this.writeBytes(allocated);
                return n;
            }
            finally {
                DefaultHttp2RemoteFlowController.this.streamByteDistributor.updateStreamableBytes(this);
            }
        }

        @Override
        int incrementStreamWindow(int delta) throws Http2Exception {
            if (delta > 0 && Integer.MAX_VALUE - delta < this.window) {
                throw Http2Exception.streamError(this.stream.id(), Http2Error.FLOW_CONTROL_ERROR, "Window size overflow for stream: %d", this.stream.id());
            }
            this.window += delta;
            DefaultHttp2RemoteFlowController.this.streamByteDistributor.updateStreamableBytes(this);
            return this.window;
        }

        @Override
        public int streamableBytes() {
            return Math.max(0, Math.min(this.pendingBytes, this.window));
        }

        private int writableWindow() {
            return Math.min(this.window, DefaultHttp2RemoteFlowController.this.connectionWindowSize());
        }

        @Override
        int pendingBytes() {
            return this.pendingBytes;
        }

        @Override
        void enqueueFrame(Http2RemoteFlowController.FlowControlled frame) {
            this.incrementPendingBytes(frame.size());
            Http2RemoteFlowController.FlowControlled last = this.pendingWriteQueue.peekLast();
            if (last == null || !last.merge(DefaultHttp2RemoteFlowController.this.ctx, frame)) {
                this.pendingWriteQueue.offer(frame);
            }
        }

        @Override
        public boolean hasFrame() {
            return !this.pendingWriteQueue.isEmpty();
        }

        private Http2RemoteFlowController.FlowControlled peek() {
            return this.pendingWriteQueue.peek();
        }

        @Override
        void cancel() {
            this.cancel(null);
        }

        private void cancel(Throwable cause) {
            Http2RemoteFlowController.FlowControlled frame;
            this.cancelled = true;
            if (this.writing) {
                return;
            }
            while ((frame = this.pendingWriteQueue.poll()) != null) {
                this.writeError(frame, Http2Exception.streamError(this.stream.id(), Http2Error.INTERNAL_ERROR, cause, "Stream closed before write could take place", new Object[0]));
            }
            DefaultHttp2RemoteFlowController.this.streamByteDistributor.updateStreamableBytes(this);
        }

        int writeBytes(int bytes) {
            if (!this.hasFrame()) {
                return -1;
            }
            Http2RemoteFlowController.FlowControlled frame = this.peek();
            int maxBytes = Math.min(bytes, this.writableWindow());
            if (maxBytes <= 0 && frame.size() != 0) {
                return -1;
            }
            int originalBytes = bytes;
            bytes -= this.write(frame, maxBytes);
            while (this.hasFrame()) {
                frame = this.peek();
                maxBytes = Math.min(bytes, this.writableWindow());
                if (maxBytes <= 0 && frame.size() != 0) break;
                bytes -= this.write(frame, maxBytes);
            }
            return originalBytes - bytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int write(Http2RemoteFlowController.FlowControlled frame, int allowedBytes) {
            int writtenBytes;
            int before = frame.size();
            Throwable cause = null;
            try {
                assert (!this.writing);
                this.writing = true;
                frame.write(DefaultHttp2RemoteFlowController.this.ctx, Math.max(0, allowedBytes));
                if (!this.cancelled && frame.size() == 0) {
                    this.pendingWriteQueue.remove();
                    frame.writeComplete();
                }
            }
            catch (Throwable t) {
                this.cancelled = true;
                cause = t;
            }
            finally {
                this.writing = false;
                writtenBytes = before - frame.size();
                this.decrementFlowControlWindow(writtenBytes);
                this.decrementPendingBytes(writtenBytes);
                if (this.cancelled) {
                    this.cancel(cause);
                }
            }
            return writtenBytes;
        }

        private void incrementPendingBytes(int numBytes) {
            this.pendingBytes += numBytes;
            DefaultHttp2RemoteFlowController.this.streamByteDistributor.updateStreamableBytes(this);
            DefaultHttp2RemoteFlowController.this.monitor.incrementPendingBytes(numBytes);
        }

        private void decrementPendingBytes(int bytes) {
            this.incrementPendingBytes(-bytes);
        }

        private void decrementFlowControlWindow(int bytes) {
            try {
                int negativeBytes = -bytes;
                DefaultHttp2RemoteFlowController.this.connectionState.incrementStreamWindow(negativeBytes);
                this.incrementStreamWindow(negativeBytes);
            }
            catch (Http2Exception e) {
                throw new IllegalStateException("Invalid window state when writing frame: " + e.getMessage(), e);
            }
        }

        private void writeError(Http2RemoteFlowController.FlowControlled frame, Http2Exception cause) {
            assert (DefaultHttp2RemoteFlowController.this.ctx != null);
            this.decrementPendingBytes(frame.size());
            frame.error(DefaultHttp2RemoteFlowController.this.ctx, cause);
        }
    }
}

