/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javaee.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.javaee.model.JpsConfigFile;
import org.jetbrains.jps.javaee.model.JpsConfigFileCollectionElement;
import org.jetbrains.jps.javaee.model.JpsJavaeeExtensionReference;
import org.jetbrains.jps.javaee.model.JpsJavaeeFacetResourcesPackagingElement;
import org.jetbrains.jps.javaee.model.JpsJavaeeModuleExtension;
import org.jetbrains.jps.javaee.model.web.JpsWebModuleExtension;
import org.jetbrains.jps.javaee.model.web.JpsWebRoot;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.artifact.elements.JpsFileCopyPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElementFactory;
import org.jetbrains.jps.model.artifact.elements.ex.JpsComplexPackagingElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.util.JpsPathUtil;

public class JpsJavaeeFacetResourcesPackagingElementImpl
extends JpsComplexPackagingElementBase<JpsJavaeeFacetResourcesPackagingElementImpl>
implements JpsJavaeeFacetResourcesPackagingElement {
    private static final JpsElementChildRole<JpsJavaeeExtensionReference> REFERENCE_CHILD_ROLE = JpsElementChildRoleBase.create((String)"javaee extension reference");

    public JpsJavaeeFacetResourcesPackagingElementImpl(@NotNull JpsJavaeeExtensionReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/jps/javaee/model/impl/JpsJavaeeFacetResourcesPackagingElementImpl", "<init>"));
        }
        this.myContainer.setChild(REFERENCE_CHILD_ROLE, (JpsElement)reference);
    }

    private JpsJavaeeFacetResourcesPackagingElementImpl(JpsJavaeeFacetResourcesPackagingElementImpl original) {
        super((JpsComplexPackagingElementBase)original);
    }

    @NotNull
    public JpsJavaeeFacetResourcesPackagingElementImpl createCopy() {
        JpsJavaeeFacetResourcesPackagingElementImpl jpsJavaeeFacetResourcesPackagingElementImpl = new JpsJavaeeFacetResourcesPackagingElementImpl(this);
        if (jpsJavaeeFacetResourcesPackagingElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javaee/model/impl/JpsJavaeeFacetResourcesPackagingElementImpl", "createCopy"));
        }
        return jpsJavaeeFacetResourcesPackagingElementImpl;
    }

    @Override
    @NotNull
    public JpsJavaeeExtensionReference getExtensionReference() {
        JpsJavaeeExtensionReference jpsJavaeeExtensionReference = (JpsJavaeeExtensionReference)this.myContainer.getChild(REFERENCE_CHILD_ROLE);
        if (jpsJavaeeExtensionReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javaee/model/impl/JpsJavaeeFacetResourcesPackagingElementImpl", "getExtensionReference"));
        }
        return jpsJavaeeExtensionReference;
    }

    public List<JpsPackagingElement> getSubstitution() {
        JpsJavaeeModuleExtension extension = (JpsJavaeeModuleExtension)((JpsJavaeeExtensionReference)this.myContainer.getChild(REFERENCE_CHILD_ROLE)).resolve();
        if (extension == null) {
            return Collections.emptyList();
        }
        ArrayList<JpsPackagingElement> result = new ArrayList<JpsPackagingElement>();
        JpsPackagingElementFactory factory = JpsPackagingElementFactory.getInstance();
        if (extension instanceof JpsWebModuleExtension) {
            for (JpsWebRoot webRoot : ((JpsWebModuleExtension)extension).getWebRoots()) {
                String path = JpsPathUtil.urlToPath((String)webRoot.getUrl());
                result.add(factory.createParentDirectories(webRoot.getRelativePath(), (JpsPackagingElement)factory.createDirectoryCopy(path)));
            }
        }
        JpsJavaeeFacetResourcesPackagingElementImpl.addElementsForConfigFiles(extension, result);
        return result;
    }

    public static void addElementsForConfigFiles(JpsConfigFileCollectionElement collectionElement, List<JpsPackagingElement> result) {
        JpsPackagingElementFactory factory = JpsPackagingElementFactory.getInstance();
        for (JpsConfigFile configFile : collectionElement.getConfigFiles()) {
            String path = JpsPathUtil.urlToPath((String)configFile.getUrl());
            JpsFileCopyPackagingElement fileCopy = factory.createFileCopy(path, configFile.getMetaData().getFixedFileName());
            result.add(factory.createParentDirectories(configFile.getMetaData().getRelativeOutputPath(), (JpsPackagingElement)fileCopy));
        }
    }
}

