/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import java.util.Map;

public class Functions {
    private static final Function<Object, Class> TO_CLASS = new Function<Object, Class>(){

        @Override
        public Class fun(Object o) {
            return o.getClass();
        }
    };
    private static final Function PAIR_FIRST = new Function<Pair<?, ?>, Object>(){

        @Override
        public Object fun(Pair<?, ?> pair) {
            return Pair.getFirst(pair);
        }
    };
    private static final Function PAIR_SECOND = new Function<Pair<?, ?>, Object>(){

        @Override
        public Object fun(Pair<?, ?> pair) {
            return Pair.getSecond(pair);
        }
    };

    public static <A> Function.Mono<A> id() {
        return (Function.Mono)Function.ID;
    }

    public static <A, B> Function<A, B> constant(final B b) {
        return new Function<A, B>(){

            @Override
            public B fun(A a) {
                return b;
            }
        };
    }

    public static <A, B> Function<A, B> identity() {
        return Function.ID;
    }

    public static <A, B> Function<A, B> cast(Class<B> clazz) {
        return Function.ID;
    }

    public static <A> Function<A, String> TO_STRING() {
        return Function.TO_STRING;
    }

    public static <A, B> Function<A, B> fromMap(final Map<A, B> map) {
        return new Function<A, B>(){

            @Override
            public B fun(A a) {
                return map.get(a);
            }
        };
    }

    public static <T> Function<T, Class> TO_CLASS() {
        return TO_CLASS;
    }

    public static <A> Function<Pair<A, ?>, A> pairFirst() {
        return PAIR_FIRST;
    }

    public static <B> Function<Pair<?, B>, B> pairSecond() {
        return PAIR_SECOND;
    }

    public static Function.Mono<Integer> intIncrement() {
        return new Function.Mono<Integer>(){

            @Override
            public Integer fun(Integer integer) {
                return integer + 1;
            }
        };
    }
}

