/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gwt.model.impl.sdk;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.gwt.model.GwtSdkPaths;
import org.jetbrains.jps.gwt.model.impl.sdk.GwtSdkPathUtil;
import org.jetbrains.jps.util.JpsPathUtil;

public class GwtVaadinSdkPaths
implements GwtSdkPaths {
    public static final String TYPE_ID = "Vaadin";
    private final String myVaadinHome;

    public GwtVaadinSdkPaths(@NotNull String vaadinHome) {
        if (vaadinHome == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vaadinHome", "org/jetbrains/jps/gwt/model/impl/sdk/GwtVaadinSdkPaths", "<init>"));
        }
        this.myVaadinHome = vaadinHome;
    }

    @Override
    @NotNull
    public String getDevJarPath(boolean systemIndependent) {
        String string = this.findJarByBaseName("vaadin-client-compiler-");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtVaadinSdkPaths", "getDevJarPath"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getServletJarPath() {
        String string = this.findJarByBaseName("vaadin-server-");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtVaadinSdkPaths", "getServletJarPath"));
        }
        return string;
    }

    @NotNull
    private String findJarByBaseName(String namePrefix) {
        File home = new File(this.myVaadinHome);
        File[] children = home.listFiles();
        if (children != null) {
            for (File file : children) {
                String fileName = file.getName();
                if (!fileName.startsWith(namePrefix) || !fileName.endsWith(".jar") || !Character.isDigit(fileName.charAt(namePrefix.length()))) continue;
                String string = file.getAbsolutePath();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtVaadinSdkPaths", "findJarByBaseName"));
                }
                return string;
            }
        }
        String string = namePrefix + "snapshot";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtVaadinSdkPaths", "findJarByBaseName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getUserJarPath() {
        String string = this.findJarByBaseName("vaadin-client-");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtVaadinSdkPaths", "getUserJarPath"));
        }
        return string;
    }

    @Override
    public String getCodeServerJarPath() {
        return null;
    }

    @Override
    @NotNull
    public List<String> getAdditionalCompilerJars() {
        List<String> list = GwtSdkPathUtil.findValidationJars(new File(this.myVaadinHome, "lib"));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtVaadinSdkPaths", "getAdditionalCompilerJars"));
        }
        return list;
    }

    @Override
    @NotNull
    public String getHomeDirectoryUrl() {
        String string = JpsPathUtil.pathToUrl((String)FileUtil.toSystemIndependentName((String)this.myVaadinHome));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtVaadinSdkPaths", "getHomeDirectoryUrl"));
        }
        return string;
    }
}

