/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.ide.common.res2.DataFile;
import com.android.ide.common.res2.DataItem;
import com.android.ide.common.res2.DataSet;
import com.android.ide.common.res2.FileResourceNameValidator;
import com.android.ide.common.res2.GeneratedResourceItem;
import com.android.ide.common.res2.MergeConsumer;
import com.android.ide.common.res2.MergingException;
import com.android.ide.common.res2.NodeUtils;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.res2.ResourcePreprocessor;
import com.android.ide.common.res2.ValueResourceParser2;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.utils.ILogger;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceSet
extends DataSet<ResourceItem, ResourceFile> {
    private ResourceSet mGeneratedSet;
    private ResourcePreprocessor mPreprocessor;

    public ResourceSet(String name) {
        this(name, true);
    }

    public ResourceSet(String name, boolean validateEnabled) {
        super(name, validateEnabled);
    }

    public void setGeneratedSet(ResourceSet generatedSet) {
        this.mGeneratedSet = generatedSet;
    }

    public void setPreprocessor(ResourcePreprocessor preprocessor) {
        this.mPreprocessor = preprocessor;
    }

    @Override
    protected DataSet<ResourceItem, ResourceFile> createSet(String name) {
        return new ResourceSet(name);
    }

    @Override
    protected ResourceFile createFileAndItems(File sourceFolder, File file, ILogger logger) throws MergingException {
        FolderData folderData = this.getFolderData(file.getParentFile());
        if (folderData == null) {
            return null;
        }
        return this.createResourceFile(file, folderData, logger);
    }

    @Override
    protected ResourceFile createFileAndItemsFromXml(File file, Node fileNode) throws MergingException {
        String qualifier = (String)Objects.firstNonNull((Object)NodeUtils.getAttribute(fileNode, "qualifiers"), (Object)"");
        String typeAttr = NodeUtils.getAttribute(fileNode, "type");
        if (NodeUtils.getAttribute(fileNode, "preprocessing") != null) {
            NodeList childNodes = fileNode.getChildNodes();
            int childCount = childNodes.getLength();
            ArrayList resourceItems = Lists.newArrayListWithCapacity((int)childCount);
            for (int i = 0; i < childCount; ++i) {
                String qualifers;
                Node childNode = childNodes.item(i);
                String path = NodeUtils.getAttribute(childNode, "path");
                if (path == null) continue;
                File generatedFile = new File(path);
                String resourceType = NodeUtils.getAttribute(childNode, "type");
                if (resourceType == null || (qualifers = NodeUtils.getAttribute(childNode, "qualifiers")) == null) continue;
                resourceItems.add(new GeneratedResourceItem(ResourceSet.getNameForFile(generatedFile), generatedFile, (ResourceType)FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)ResourceFolderType.getTypeByName((String)resourceType)).get(0), qualifers));
            }
            return ResourceFile.generatedFiles(file, resourceItems, qualifier);
        }
        if (typeAttr == null) {
            ArrayList resourceList = Lists.newArrayList();
            NodeList resNodes = fileNode.getChildNodes();
            int nnn = resNodes.getLength();
            for (int iii = 0; iii < nnn; ++iii) {
                ResourceItem r;
                Node resNode = resNodes.item(iii);
                if (resNode.getNodeType() != 1 || (r = ValueResourceParser2.getResource(resNode, file)) == null) continue;
                resourceList.add(r);
                if (r.getType() != ResourceType.DECLARE_STYLEABLE) continue;
                try {
                    ValueResourceParser2.addStyleableItems(resNode, resourceList, null, file);
                    continue;
                }
                catch (MergingException ignored) {
                    assert (false) : file + ": " + ignored.getMessage();
                    continue;
                }
            }
            return new ResourceFile(file, resourceList, qualifier);
        }
        ResourceType type = ResourceType.getEnum((String)typeAttr);
        if (type == null) {
            return null;
        }
        String nameAttr = NodeUtils.getAttribute(fileNode, "name");
        if (nameAttr == null) {
            return null;
        }
        if (this.getValidateEnabled()) {
            FileResourceNameValidator.validate(file, type);
        }
        ResourceItem item = new ResourceItem(nameAttr, type, null);
        return new ResourceFile(file, item, qualifier);
    }

    @Override
    protected void readSourceFolder(File sourceFolder, ILogger logger) throws MergingException {
        ArrayList errors = Lists.newArrayList();
        File[] folders = sourceFolder.listFiles();
        if (folders != null) {
            for (File folder : folders) {
                FolderData folderData;
                if (!folder.isDirectory() || ResourceSet.isIgnored(folder) || (folderData = this.getFolderData(folder)) == null) continue;
                try {
                    this.parseFolder(sourceFolder, folder, folderData, logger);
                }
                catch (MergingException e) {
                    errors.addAll(e.getMessages());
                }
            }
        }
        MergingException.throwIfNonEmpty(errors);
    }

    @Override
    protected boolean isValidSourceFile(File sourceFolder, File file) {
        if (!super.isValidSourceFile(sourceFolder, file)) {
            return false;
        }
        File resFolder = file.getParentFile();
        return resFolder.getParentFile().equals(sourceFolder) && !ResourceSet.isIgnored(resFolder) && ResourceFolderType.getFolderType((String)resFolder.getName()) != null;
    }

    @Override
    protected boolean handleNewFile(File sourceFolder, File file, ILogger logger) throws MergingException {
        ResourceFile resourceFile = this.createFileAndItems(sourceFolder, file, logger);
        this.processNewResourceFile(sourceFolder, resourceFile);
        return true;
    }

    @Override
    protected boolean handleRemovedFile(File removedFile) {
        if (this.mGeneratedSet != null && this.mGeneratedSet.getDataFile(removedFile) != null) {
            return this.mGeneratedSet.handleRemovedFile(removedFile);
        }
        return super.handleRemovedFile(removedFile);
    }

    @Override
    protected boolean handleChangedFile(File sourceFolder, File changedFile, ILogger logger) throws MergingException {
        FolderData folderData = this.getFolderData(changedFile.getParentFile());
        if (folderData == null) {
            return true;
        }
        ResourceFile resourceFile = (ResourceFile)this.getDataFile(changedFile);
        if (this.mGeneratedSet == null) {
            this.doHandleChangedFile(changedFile, resourceFile);
            return true;
        }
        ResourceFile generatedSetResourceFile = (ResourceFile)this.mGeneratedSet.getDataFile(changedFile);
        boolean needsPreprocessing = this.needsPreprocessing(changedFile);
        if (resourceFile != null && generatedSetResourceFile == null && needsPreprocessing) {
            this.handleRemovedFile(changedFile);
            this.mGeneratedSet.handleNewFile(sourceFolder, changedFile, logger);
        } else if (resourceFile == null && generatedSetResourceFile != null && !needsPreprocessing) {
            this.mGeneratedSet.handleRemovedFile(changedFile);
            this.handleNewFile(sourceFolder, changedFile, logger);
        } else if (resourceFile == null && generatedSetResourceFile != null && needsPreprocessing) {
            this.mGeneratedSet.handleChangedFile(sourceFolder, changedFile, logger);
        } else if (resourceFile != null && !needsPreprocessing && generatedSetResourceFile == null) {
            this.doHandleChangedFile(changedFile, resourceFile);
        } else {
            throw MergingException.withMessage("In DataSet '%s', no data file for changedFile. This is an internal error in the incremental builds code; to work around it, try doing a full clean build.", this.getConfigName()).withFile(changedFile).build();
        }
        return true;
    }

    private void doHandleChangedFile(File changedFile, ResourceFile resourceFile) throws MergingException {
        switch (resourceFile.getType()) {
            case SINGLE_FILE: {
                ((ResourceItem)resourceFile.getItem()).setTouched();
                break;
            }
            case GENERATED_FILES: {
                this.handleChangedItems(resourceFile, this.getResourceItemsForGeneratedFiles(changedFile));
                break;
            }
            case XML_VALUES: {
                ValueResourceParser2 parser = new ValueResourceParser2(changedFile);
                List<ResourceItem> parsedItems = parser.parseFile();
                this.handleChangedItems(resourceFile, parsedItems);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void handleChangedItems(ResourceFile resourceFile, List<ResourceItem> currentItems) throws MergingException {
        HashMap oldItems = Maps.newHashMap(resourceFile.getItemMap());
        HashMap addedItems = Maps.newHashMap();
        for (ResourceItem resourceItem : currentItems) {
            resourceItem.setSource(resourceFile);
        }
        for (ResourceItem resourceItem : currentItems) {
            String newKey = resourceItem.getKey();
            ResourceItem oldItem = (ResourceItem)oldItems.get(newKey);
            if (oldItem == null) {
                resourceItem.setTouched();
                addedItems.put(newKey, resourceItem);
                continue;
            }
            oldItems.remove(oldItem.getKey());
            if (((ResourceFile)oldItem.getSource()).getType() == DataFile.FileType.XML_VALUES) {
                if (oldItem.compareValueWith(resourceItem)) continue;
                oldItem.setValue(resourceItem);
                continue;
            }
            oldItem.setTouched();
        }
        for (ResourceItem resourceItem : oldItems.values()) {
            resourceItem.setRemoved();
        }
        resourceFile.addItems(addedItems.values());
        for (Map.Entry entry : addedItems.entrySet()) {
            this.addItem((DataItem)entry.getValue(), (String)entry.getKey());
        }
    }

    private void parseFolder(File sourceFolder, File folder, FolderData folderData, ILogger logger) throws MergingException {
        File[] files = folder.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (!file.isFile() || ResourceSet.isIgnored(file)) continue;
                ResourceFile resourceFile = this.createResourceFile(file, folderData, logger);
                this.processNewResourceFile(sourceFolder, resourceFile);
            }
        }
    }

    private void processNewResourceFile(File sourceFolder, ResourceFile resourceFile) throws MergingException {
        if (resourceFile != null) {
            if (resourceFile.getType() == DataFile.FileType.GENERATED_FILES && this.mGeneratedSet != null) {
                this.mGeneratedSet.processNewDataFile(sourceFolder, resourceFile, true);
            } else {
                this.processNewDataFile(sourceFolder, resourceFile, true);
            }
        }
    }

    private ResourceFile createResourceFile(File file, FolderData folderData, ILogger logger) throws MergingException {
        if (folderData.type != null) {
            FileResourceNameValidator.validate(file, folderData.type);
            String name = ResourceSet.getNameForFile(file);
            if (this.needsPreprocessing(file)) {
                return ResourceFile.generatedFiles(file, this.getResourceItemsForGeneratedFiles(file), folderData.qualifiers);
            }
            return new ResourceFile(file, new ResourceItem(name, folderData.type, null), folderData.qualifiers);
        }
        try {
            ValueResourceParser2 parser = new ValueResourceParser2(file);
            List<ResourceItem> items = parser.parseFile();
            return new ResourceFile(file, items, folderData.qualifiers);
        }
        catch (MergingException e) {
            logger.error((Throwable)e, "Failed to parse %s", new Object[]{file.getAbsolutePath()});
            throw e;
        }
    }

    private boolean needsPreprocessing(File file) {
        return this.mPreprocessor != null && this.mPreprocessor.needsPreprocessing(file);
    }

    private List<ResourceItem> getResourceItemsForGeneratedFiles(File file) throws MergingException {
        ArrayList<ResourceItem> resourceItems = new ArrayList<ResourceItem>();
        for (File generatedFile : this.mPreprocessor.getFilesToBeGenerated(file)) {
            FolderData generatedFileFolderData = this.getFolderData(generatedFile.getParentFile());
            Preconditions.checkState((generatedFileFolderData != null ? 1 : 0) != 0, (String)"Can't determine folder type for %s", (Object[])new Object[]{generatedFile.getPath()});
            resourceItems.add(new GeneratedResourceItem(ResourceSet.getNameForFile(generatedFile), generatedFile, generatedFileFolderData.type, generatedFileFolderData.qualifiers));
        }
        return resourceItems;
    }

    private static String getNameForFile(File file) {
        String name = file.getName();
        int pos = name.indexOf(46);
        if (pos >= 0) {
            name = name.substring(0, pos);
        }
        return name;
    }

    private FolderData getFolderData(File folder) throws MergingException {
        FolderData fd = new FolderData();
        String folderName = folder.getName();
        int pos = folderName.indexOf("-");
        if (pos != -1) {
            fd.folderType = ResourceFolderType.getTypeByName((String)folderName.substring(0, pos));
            if (fd.folderType == null) {
                return null;
            }
            FolderConfiguration folderConfiguration = FolderConfiguration.getConfigForFolder(folderName);
            if (folderConfiguration == null) {
                throw MergingException.withMessage("Invalid resource directory name", new Object[0]).withFile(folder).build();
            }
            folderConfiguration.normalize();
            fd.qualifiers = folderConfiguration.getUniqueKey().substring(1);
        } else {
            fd.folderType = ResourceFolderType.getTypeByName((String)folderName);
        }
        if (fd.folderType != null && fd.folderType != ResourceFolderType.VALUES) {
            fd.type = (ResourceType)FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)fd.folderType).get(0);
        }
        return fd;
    }

    @Override
    void appendToXml(Node setNode, Document document, MergeConsumer<ResourceItem> consumer) {
        if (this.mGeneratedSet != null) {
            NodeUtils.addAttribute(document, setNode, null, "generated-set", this.mGeneratedSet.getConfigName());
        }
        super.appendToXml(setNode, document, consumer);
    }

    private static class FolderData {
        String qualifiers = "";
        ResourceType type = null;
        ResourceFolderType folderType = null;

        private FolderData() {
        }
    }
}

