/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoop;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.ReflectiveChannelFactory;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.handler.codec.dns.DatagramDnsQueryEncoder;
import io.netty.handler.codec.dns.DatagramDnsResponse;
import io.netty.handler.codec.dns.DatagramDnsResponseDecoder;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsResponse;
import io.netty.resolver.SimpleNameResolver;
import io.netty.resolver.dns.DnsCacheEntry;
import io.netty.resolver.dns.DnsNameResolverContext;
import io.netty.resolver.dns.DnsQueryContext;
import io.netty.resolver.dns.DnsServerAddressStream;
import io.netty.resolver.dns.DnsServerAddresses;
import io.netty.util.NetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.OneTimeTask;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.IDN;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class DnsNameResolver
extends SimpleNameResolver<InetSocketAddress> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DnsNameResolver.class);
    static final InetSocketAddress ANY_LOCAL_ADDR = new InetSocketAddress(0);
    private static final InternetProtocolFamily[] DEFAULT_RESOLVE_ADDRESS_TYPES = new InternetProtocolFamily[2];
    private static final DatagramDnsResponseDecoder DECODER;
    private static final DatagramDnsQueryEncoder ENCODER;
    final DnsServerAddresses nameServerAddresses;
    final ChannelFuture bindFuture;
    final DatagramChannel ch;
    final AtomicReferenceArray<DnsQueryContext> promises = new AtomicReferenceArray(65536);
    final ConcurrentMap<String, List<DnsCacheEntry>> resolveCache = PlatformDependent.newConcurrentHashMap();
    private final FastThreadLocal<DnsServerAddressStream> nameServerAddrStream = new FastThreadLocal<DnsServerAddressStream>(){

        @Override
        protected DnsServerAddressStream initialValue() throws Exception {
            return DnsNameResolver.this.nameServerAddresses.stream();
        }
    };
    private final DnsResponseHandler responseHandler = new DnsResponseHandler();
    private volatile long queryTimeoutMillis = 5000L;
    private volatile int minTtl;
    private volatile int maxTtl = Integer.MAX_VALUE;
    private volatile int negativeTtl;
    private volatile int maxQueriesPerResolve = 3;
    private volatile boolean traceEnabled = true;
    private volatile InternetProtocolFamily[] resolveAddressTypes = DEFAULT_RESOLVE_ADDRESS_TYPES;
    private volatile boolean recursionDesired = true;
    private volatile int maxPayloadSize;
    private volatile boolean optResourceEnabled = true;

    public DnsNameResolver(EventLoop eventLoop, Class<? extends DatagramChannel> channelType, DnsServerAddresses nameServerAddresses) {
        this(eventLoop, channelType, ANY_LOCAL_ADDR, nameServerAddresses);
    }

    public DnsNameResolver(EventLoop eventLoop, Class<? extends DatagramChannel> channelType, InetSocketAddress localAddress, DnsServerAddresses nameServerAddresses) {
        this(eventLoop, new ReflectiveChannelFactory<DatagramChannel>(channelType), localAddress, nameServerAddresses);
    }

    public DnsNameResolver(EventLoop eventLoop, ChannelFactory<? extends DatagramChannel> channelFactory, DnsServerAddresses nameServerAddresses) {
        this(eventLoop, channelFactory, ANY_LOCAL_ADDR, nameServerAddresses);
    }

    public DnsNameResolver(EventLoop eventLoop, ChannelFactory<? extends DatagramChannel> channelFactory, InetSocketAddress localAddress, DnsServerAddresses nameServerAddresses) {
        super(eventLoop);
        ObjectUtil.checkNotNull(channelFactory, "channelFactory");
        ObjectUtil.checkNotNull(nameServerAddresses, "nameServerAddresses");
        ObjectUtil.checkNotNull(localAddress, "localAddress");
        this.nameServerAddresses = nameServerAddresses;
        this.bindFuture = this.newChannel(channelFactory, localAddress);
        this.ch = (DatagramChannel)this.bindFuture.channel();
        this.setMaxPayloadSize(4096);
    }

    private ChannelFuture newChannel(ChannelFactory<? extends DatagramChannel> channelFactory, InetSocketAddress localAddress) {
        Bootstrap b = new Bootstrap();
        b.group(this.executor());
        b.channelFactory(channelFactory);
        b.handler(new ChannelInitializer<DatagramChannel>(){

            @Override
            protected void initChannel(DatagramChannel ch) throws Exception {
                ch.pipeline().addLast(DECODER, ENCODER, DnsNameResolver.this.responseHandler);
            }
        });
        ChannelFuture bindFuture = b.bind(localAddress);
        bindFuture.channel().closeFuture().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                DnsNameResolver.this.clearCache();
            }
        });
        return bindFuture;
    }

    public int minTtl() {
        return this.minTtl;
    }

    public int maxTtl() {
        return this.maxTtl;
    }

    public DnsNameResolver setTtl(int minTtl, int maxTtl) {
        if (minTtl < 0) {
            throw new IllegalArgumentException("minTtl: " + minTtl + " (expected: >= 0)");
        }
        if (maxTtl < 0) {
            throw new IllegalArgumentException("maxTtl: " + maxTtl + " (expected: >= 0)");
        }
        if (minTtl > maxTtl) {
            throw new IllegalArgumentException("minTtl: " + minTtl + ", maxTtl: " + maxTtl + " (expected: 0 <= minTtl <= maxTtl)");
        }
        this.maxTtl = maxTtl;
        this.minTtl = minTtl;
        return this;
    }

    public int negativeTtl() {
        return this.negativeTtl;
    }

    public DnsNameResolver setNegativeTtl(int negativeTtl) {
        if (negativeTtl < 0) {
            throw new IllegalArgumentException("negativeTtl: " + negativeTtl + " (expected: >= 0)");
        }
        this.negativeTtl = negativeTtl;
        return this;
    }

    public long queryTimeoutMillis() {
        return this.queryTimeoutMillis;
    }

    public DnsNameResolver setQueryTimeoutMillis(long queryTimeoutMillis) {
        if (queryTimeoutMillis < 0L) {
            throw new IllegalArgumentException("queryTimeoutMillis: " + queryTimeoutMillis + " (expected: >= 0)");
        }
        this.queryTimeoutMillis = queryTimeoutMillis;
        return this;
    }

    public List<InternetProtocolFamily> resolveAddressTypes() {
        return Arrays.asList(this.resolveAddressTypes);
    }

    InternetProtocolFamily[] resolveAddressTypesUnsafe() {
        return this.resolveAddressTypes;
    }

    public DnsNameResolver setResolveAddressTypes(InternetProtocolFamily ... resolveAddressTypes) {
        ObjectUtil.checkNotNull(resolveAddressTypes, "resolveAddressTypes");
        ArrayList<InternetProtocolFamily> list = new ArrayList<InternetProtocolFamily>(InternetProtocolFamily.values().length);
        for (InternetProtocolFamily f : resolveAddressTypes) {
            if (f == null) break;
            if (list.contains((Object)f)) continue;
            list.add(f);
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("no protocol family specified");
        }
        this.resolveAddressTypes = list.toArray(new InternetProtocolFamily[list.size()]);
        return this;
    }

    public DnsNameResolver setResolveAddressTypes(Iterable<InternetProtocolFamily> resolveAddressTypes) {
        ObjectUtil.checkNotNull(resolveAddressTypes, "resolveAddressTypes");
        ArrayList<InternetProtocolFamily> list = new ArrayList<InternetProtocolFamily>(InternetProtocolFamily.values().length);
        for (InternetProtocolFamily f : resolveAddressTypes) {
            if (f == null) break;
            if (list.contains((Object)f)) continue;
            list.add(f);
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("no protocol family specified");
        }
        this.resolveAddressTypes = list.toArray(new InternetProtocolFamily[list.size()]);
        return this;
    }

    public boolean isRecursionDesired() {
        return this.recursionDesired;
    }

    public DnsNameResolver setRecursionDesired(boolean recursionDesired) {
        this.recursionDesired = recursionDesired;
        return this;
    }

    public int maxQueriesPerResolve() {
        return this.maxQueriesPerResolve;
    }

    public DnsNameResolver setMaxQueriesPerResolve(int maxQueriesPerResolve) {
        if (maxQueriesPerResolve <= 0) {
            throw new IllegalArgumentException("maxQueriesPerResolve: " + maxQueriesPerResolve + " (expected: > 0)");
        }
        this.maxQueriesPerResolve = maxQueriesPerResolve;
        return this;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public DnsNameResolver setTraceEnabled(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
        return this;
    }

    public int maxPayloadSize() {
        return this.maxPayloadSize;
    }

    public DnsNameResolver setMaxPayloadSize(int maxPayloadSize) {
        if (maxPayloadSize <= 0) {
            throw new IllegalArgumentException("maxPayloadSize: " + maxPayloadSize + " (expected: > 0)");
        }
        if (this.maxPayloadSize == maxPayloadSize) {
            return this;
        }
        this.maxPayloadSize = maxPayloadSize;
        this.ch.config().setRecvByteBufAllocator(new FixedRecvByteBufAllocator(maxPayloadSize));
        return this;
    }

    public DnsNameResolver setOptResourceEnabled(boolean optResourceEnabled) {
        this.optResourceEnabled = optResourceEnabled;
        return this;
    }

    public boolean isOptResourceEnabled() {
        return this.optResourceEnabled;
    }

    public DnsNameResolver clearCache() {
        Iterator i = this.resolveCache.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, List<DnsCacheEntry>> e = i.next();
            i.remove();
            DnsNameResolver.cancelExpiration(e);
        }
        return this;
    }

    public boolean clearCache(String hostname) {
        boolean removed = false;
        Iterator i = this.resolveCache.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, List<DnsCacheEntry>> e = i.next();
            if (!((String)e.getKey()).equals(hostname)) continue;
            i.remove();
            DnsNameResolver.cancelExpiration(e);
            removed = true;
        }
        return removed;
    }

    private static void cancelExpiration(Map.Entry<String, List<DnsCacheEntry>> e) {
        List<DnsCacheEntry> entries = e.getValue();
        int numEntries = entries.size();
        for (int i = 0; i < numEntries; ++i) {
            entries.get(i).cancelExpiration();
        }
    }

    @Override
    public void close() {
        this.ch.close();
    }

    @Override
    protected EventLoop executor() {
        return (EventLoop)super.executor();
    }

    @Override
    protected boolean doIsResolved(InetSocketAddress address) {
        return !address.isUnresolved();
    }

    @Override
    protected void doResolve(InetSocketAddress unresolvedAddress, Promise<InetSocketAddress> promise) throws Exception {
        int port;
        byte[] bytes = NetUtil.createByteArrayFromIpAddressString(unresolvedAddress.getHostName());
        if (bytes != null) {
            promise.setSuccess(new InetSocketAddress(InetAddress.getByAddress(bytes), unresolvedAddress.getPort()));
            return;
        }
        String hostname = DnsNameResolver.hostname(unresolvedAddress);
        if (!this.doResolveCached(hostname, port = unresolvedAddress.getPort(), promise)) {
            this.doResolveUncached(hostname, port, promise);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doResolveCached(String hostname, int port, Promise<InetSocketAddress> promise) {
        List cachedEntries = (List)this.resolveCache.get(hostname);
        if (cachedEntries == null) {
            return false;
        }
        InetAddress address = null;
        Throwable cause = null;
        List list = cachedEntries;
        synchronized (list) {
            int numEntries = cachedEntries.size();
            assert (numEntries > 0);
            if (((DnsCacheEntry)cachedEntries.get(0)).cause() != null) {
                cause = ((DnsCacheEntry)cachedEntries.get(0)).cause();
            } else {
                block3: for (InternetProtocolFamily f : this.resolveAddressTypes) {
                    for (int i = 0; i < numEntries; ++i) {
                        DnsCacheEntry e = (DnsCacheEntry)cachedEntries.get(i);
                        if (!f.addressType().isInstance(e.address())) continue;
                        address = e.address();
                        continue block3;
                    }
                }
            }
        }
        if (address != null) {
            DnsNameResolver.setSuccess(promise, new InetSocketAddress(address, port));
        } else if (cause != null) {
            if (!promise.tryFailure(cause)) {
                logger.warn("Failed to notify failure to a promise: {}", (Object)promise, (Object)cause);
            }
        } else {
            return false;
        }
        return true;
    }

    private static void setSuccess(Promise<InetSocketAddress> promise, InetSocketAddress result) {
        if (!promise.trySuccess(result)) {
            logger.warn("Failed to notify success ({}) to a promise: {}", (Object)result, (Object)promise);
        }
    }

    private void doResolveUncached(String hostname, final int port, Promise<InetSocketAddress> promise) {
        DnsNameResolverContext<InetSocketAddress> ctx = new DnsNameResolverContext<InetSocketAddress>(this, hostname, promise){

            @Override
            protected boolean finishResolve(Class<? extends InetAddress> addressType, List<DnsCacheEntry> resolvedEntries) {
                int numEntries = resolvedEntries.size();
                for (int i = 0; i < numEntries; ++i) {
                    InetAddress a = resolvedEntries.get(i).address();
                    if (!addressType.isInstance(a)) continue;
                    DnsNameResolver.setSuccess(this.promise(), new InetSocketAddress(a, port));
                    return true;
                }
                return false;
            }
        };
        ctx.resolve();
    }

    @Override
    protected void doResolveAll(InetSocketAddress unresolvedAddress, Promise<List<InetSocketAddress>> promise) throws Exception {
        int port;
        byte[] bytes = NetUtil.createByteArrayFromIpAddressString(unresolvedAddress.getHostName());
        if (bytes != null) {
            promise.setSuccess(Collections.singletonList(new InetSocketAddress(InetAddress.getByAddress(bytes), unresolvedAddress.getPort())));
            return;
        }
        String hostname = DnsNameResolver.hostname(unresolvedAddress);
        if (!this.doResolveAllCached(hostname, port = unresolvedAddress.getPort(), promise)) {
            this.doResolveAllUncached(hostname, port, promise);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doResolveAllCached(String hostname, int port, Promise<List<InetSocketAddress>> promise) {
        List cachedEntries = (List)this.resolveCache.get(hostname);
        if (cachedEntries == null) {
            return false;
        }
        ArrayList<InetSocketAddress> result = null;
        Throwable cause = null;
        List list = cachedEntries;
        synchronized (list) {
            int numEntries = cachedEntries.size();
            assert (numEntries > 0);
            if (((DnsCacheEntry)cachedEntries.get(0)).cause() != null) {
                cause = ((DnsCacheEntry)cachedEntries.get(0)).cause();
            } else {
                for (InternetProtocolFamily f : this.resolveAddressTypes) {
                    for (int i = 0; i < numEntries; ++i) {
                        DnsCacheEntry e = (DnsCacheEntry)cachedEntries.get(i);
                        if (!f.addressType().isInstance(e.address())) continue;
                        if (result == null) {
                            result = new ArrayList<InetSocketAddress>(numEntries);
                        }
                        result.add(new InetSocketAddress(e.address(), port));
                    }
                }
            }
        }
        if (result != null) {
            promise.trySuccess(result);
        } else if (cause != null) {
            promise.tryFailure(cause);
        } else {
            return false;
        }
        return true;
    }

    private void doResolveAllUncached(String hostname, final int port, Promise<List<InetSocketAddress>> promise) {
        DnsNameResolverContext<List<InetSocketAddress>> ctx = new DnsNameResolverContext<List<InetSocketAddress>>(this, hostname, promise){

            @Override
            protected boolean finishResolve(Class<? extends InetAddress> addressType, List<DnsCacheEntry> resolvedEntries) {
                ArrayList<InetSocketAddress> result = null;
                int numEntries = resolvedEntries.size();
                for (int i = 0; i < numEntries; ++i) {
                    InetAddress a = resolvedEntries.get(i).address();
                    if (!addressType.isInstance(a)) continue;
                    if (result == null) {
                        result = new ArrayList<InetSocketAddress>(numEntries);
                    }
                    result.add(new InetSocketAddress(a, port));
                }
                if (result != null) {
                    this.promise().trySuccess(result);
                    return true;
                }
                return false;
            }
        };
        ctx.resolve();
    }

    private static String hostname(InetSocketAddress addr) {
        String hostname = PlatformDependent.javaVersion() < 7 ? addr.getHostName() : addr.getHostString();
        return IDN.toASCII(hostname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cache(String hostname, InetAddress address, long originalTtl) {
        int maxTtl = this.maxTtl();
        if (maxTtl == 0) {
            return;
        }
        int ttl = Math.max(this.minTtl(), (int)Math.min((long)maxTtl, originalTtl));
        List<DnsCacheEntry> entries = this.cachedEntries(hostname);
        DnsCacheEntry e = new DnsCacheEntry(hostname, address);
        List<DnsCacheEntry> list = entries;
        synchronized (list) {
            DnsCacheEntry firstEntry;
            if (!entries.isEmpty() && (firstEntry = entries.get(0)).cause() != null) {
                assert (entries.size() == 1);
                firstEntry.cancelExpiration();
                entries.clear();
            }
            entries.add(e);
        }
        this.scheduleCacheExpiration(entries, e, ttl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cache(String hostname, Throwable cause) {
        int negativeTtl = this.negativeTtl();
        if (negativeTtl == 0) {
            return;
        }
        List<DnsCacheEntry> entries = this.cachedEntries(hostname);
        DnsCacheEntry e = new DnsCacheEntry(hostname, cause);
        List<DnsCacheEntry> list = entries;
        synchronized (list) {
            int numEntries = entries.size();
            for (int i = 0; i < numEntries; ++i) {
                entries.get(i).cancelExpiration();
            }
            entries.clear();
            entries.add(e);
        }
        this.scheduleCacheExpiration(entries, e, negativeTtl);
    }

    private List<DnsCacheEntry> cachedEntries(String hostname) {
        ArrayList newEntries;
        ArrayList oldEntries = (ArrayList)this.resolveCache.get(hostname);
        ArrayList entries = oldEntries == null ? ((oldEntries = (List)this.resolveCache.putIfAbsent(hostname, newEntries = new ArrayList())) != null ? oldEntries : newEntries) : oldEntries;
        return entries;
    }

    private void scheduleCacheExpiration(final List<DnsCacheEntry> entries, final DnsCacheEntry e, int ttl) {
        e.scheduleExpiration(this.ch.eventLoop(), new OneTimeTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list = entries;
                synchronized (list) {
                    entries.remove(e);
                    if (entries.isEmpty()) {
                        DnsNameResolver.this.resolveCache.remove(e.hostname());
                    }
                }
            }
        }, ttl, TimeUnit.SECONDS);
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(DnsQuestion question) {
        return this.query(this.nextNameServerAddress(), question);
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(DnsQuestion question, Promise<AddressedEnvelope<? extends DnsResponse, InetSocketAddress>> promise) {
        return this.query(this.nextNameServerAddress(), question, promise);
    }

    private InetSocketAddress nextNameServerAddress() {
        return this.nameServerAddrStream.get().next();
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(InetSocketAddress nameServerAddr, DnsQuestion question) {
        return this.query0(ObjectUtil.checkNotNull(nameServerAddr, "nameServerAddr"), ObjectUtil.checkNotNull(question, "question"), this.ch.eventLoop().newPromise());
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(InetSocketAddress nameServerAddr, DnsQuestion question, Promise<AddressedEnvelope<? extends DnsResponse, InetSocketAddress>> promise) {
        return this.query0(ObjectUtil.checkNotNull(nameServerAddr, "nameServerAddr"), ObjectUtil.checkNotNull(question, "question"), ObjectUtil.checkNotNull(promise, "promise"));
    }

    private Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query0(InetSocketAddress nameServerAddr, DnsQuestion question, Promise<AddressedEnvelope<? extends DnsResponse, InetSocketAddress>> promise) {
        Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> castPromise = DnsNameResolver.cast(promise);
        try {
            new DnsQueryContext(this, nameServerAddr, question, castPromise).query();
            return castPromise;
        }
        catch (Exception e) {
            return castPromise.setFailure(e);
        }
    }

    private static Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> cast(Promise<?> promise) {
        return promise;
    }

    static {
        if ("true".equalsIgnoreCase(SystemPropertyUtil.get("java.net.preferIPv6Addresses"))) {
            DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES[0] = InternetProtocolFamily.IPv6;
            DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES[1] = InternetProtocolFamily.IPv4;
            logger.debug("-Djava.net.preferIPv6Addresses: true");
        } else {
            DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES[0] = InternetProtocolFamily.IPv4;
            DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES[1] = InternetProtocolFamily.IPv6;
            logger.debug("-Djava.net.preferIPv6Addresses: false");
        }
        DECODER = new DatagramDnsResponseDecoder();
        ENCODER = new DatagramDnsQueryEncoder();
    }

    private final class DnsResponseHandler
    extends ChannelInboundHandlerAdapter {
        private DnsResponseHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            try {
                DnsQueryContext qCtx;
                DatagramDnsResponse res = (DatagramDnsResponse)msg;
                int queryId = res.id();
                if (logger.isDebugEnabled()) {
                    logger.debug("{} RECEIVED: [{}: {}], {}", DnsNameResolver.this.ch, queryId, res.sender(), res);
                }
                if ((qCtx = DnsNameResolver.this.promises.get(queryId)) == null) {
                    if (logger.isWarnEnabled()) {
                        logger.warn("{} Received a DNS response with an unknown ID: {}", (Object)DnsNameResolver.this.ch, (Object)queryId);
                    }
                    return;
                }
                qCtx.finish(res);
            }
            finally {
                ReferenceCountUtil.safeRelease(msg);
            }
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            logger.warn("{} Unexpected exception: ", (Object)DnsNameResolver.this.ch, (Object)cause);
        }
    }
}

