/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.manifmerger.ActionRecorder;
import com.android.manifmerger.Actions;
import com.android.manifmerger.XmlDocument;
import com.android.utils.ILogger;
import com.google.common.base.CaseFormat;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;

public class MergingReport {
    private final Optional<XmlDocument> mMergedDocument;
    private final Result mResult;
    private final ImmutableList<Record> mRecords;
    private final ImmutableList<String> mIntermediaryStages;
    private final Actions mActions;

    private MergingReport(Optional<XmlDocument> mergedDocument, Result result, ImmutableList<Record> records, ImmutableList<String> intermediaryStages, Actions actions) {
        this.mMergedDocument = mergedDocument;
        this.mResult = result;
        this.mRecords = records;
        this.mIntermediaryStages = intermediaryStages;
        this.mActions = actions;
    }

    public void log(ILogger logger) {
        block5: for (Record record : this.mRecords) {
            switch (record.mSeverity) {
                case WARNING: {
                    logger.warning(record.toString(), new Object[0]);
                    continue block5;
                }
                case ERROR: {
                    logger.error(null, record.toString(), new Object[0]);
                    continue block5;
                }
                case INFO: {
                    logger.verbose(record.toString(), new Object[0]);
                    continue block5;
                }
            }
            logger.error(null, "Unhandled record type " + (Object)((Object)record.mSeverity), new Object[0]);
        }
        this.mActions.log(logger);
        if (!this.mResult.isSuccess()) {
            logger.warning("\nSee http://g.co/androidstudio/manifest-merger for more information about the manifest merger.\n", new Object[0]);
        }
    }

    public Optional<XmlDocument> getMergedDocument() {
        return this.mMergedDocument;
    }

    public ImmutableList<String> getIntermediaryStages() {
        return this.mIntermediaryStages;
    }

    public Result getResult() {
        return this.mResult;
    }

    public ImmutableList<Record> getLoggingRecords() {
        return this.mRecords;
    }

    public Actions getActions() {
        return this.mActions;
    }

    public String getReportString() {
        switch (this.mResult) {
            case SUCCESS: {
                return "Manifest merger executed successfully";
            }
            case WARNING: {
                return this.mRecords.size() > 1 ? "Manifest merger exited with warnings, see logs" : "Manifest merger warning : " + ((Record)this.mRecords.get(0)).mLog;
            }
            case ERROR: {
                return this.mRecords.size() > 1 ? "Manifest merger failed with multiple errors, see logs" : "Manifest merger failed : " + ((Record)this.mRecords.get(0)).mLog;
            }
        }
        return "Manifest merger returned an invalid result " + (Object)((Object)this.mResult);
    }

    static class Builder {
        private Optional<XmlDocument> mMergedDocument = Optional.absent();
        private ImmutableList.Builder<Record> mRecordBuilder = new ImmutableList.Builder();
        private ImmutableList.Builder<String> mIntermediaryStages = new ImmutableList.Builder();
        private boolean mHasWarnings = false;
        private boolean mHasErrors = false;
        private ActionRecorder mActionRecorder = new ActionRecorder();
        private final ILogger mLogger;

        Builder(ILogger logger) {
            this.mLogger = logger;
        }

        Builder setMergedDocument(XmlDocument mergedDocument) {
            this.mMergedDocument = Optional.of((Object)mergedDocument);
            return this;
        }

        Builder addMessage(SourceFile sourceFile, int line, int column, Record.Severity severity, String message) {
            return this.addMessage(new SourceFilePosition(sourceFile, new SourcePosition(line - 1, column - 1, -1)), severity, message);
        }

        Builder addMessage(SourceFile sourceFile, Record.Severity severity, String message) {
            return this.addMessage(new SourceFilePosition(sourceFile, SourcePosition.UNKNOWN), severity, message);
        }

        Builder addMessage(SourceFilePosition sourceFilePosition, Record.Severity severity, String message) {
            switch (severity) {
                case ERROR: {
                    this.mHasErrors = true;
                    break;
                }
                case WARNING: {
                    this.mHasWarnings = true;
                }
            }
            this.mRecordBuilder.add((Object)new Record(sourceFilePosition, severity, message));
            return this;
        }

        Builder addMergingStage(String xml) {
            this.mIntermediaryStages.add((Object)xml);
            return this;
        }

        boolean hasErrors() {
            return this.mHasErrors;
        }

        ActionRecorder getActionRecorder() {
            return this.mActionRecorder;
        }

        MergingReport build() {
            Result result = this.mHasErrors ? Result.ERROR : (this.mHasWarnings ? Result.WARNING : Result.SUCCESS);
            return new MergingReport(this.mMergedDocument, result, this.mRecordBuilder.build(), this.mIntermediaryStages.build(), this.mActionRecorder.build());
        }

        public ILogger getLogger() {
            return this.mLogger;
        }
    }

    public static class Record {
        private final Severity mSeverity;
        private final String mLog;
        private final SourceFilePosition mSourceLocation;

        private Record(SourceFilePosition sourceLocation, Severity severity, String mLog) {
            this.mSourceLocation = sourceLocation;
            this.mSeverity = severity;
            this.mLog = mLog;
        }

        public Severity getSeverity() {
            return this.mSeverity;
        }

        public String getMessage() {
            return this.mLog;
        }

        public String toString() {
            return this.mSourceLocation.toString() + " " + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.mSeverity.toString()) + ":\n\t" + this.mLog;
        }

        public static enum Severity {
            WARNING,
            ERROR,
            INFO;

        }
    }

    public static enum Result {
        SUCCESS,
        WARNING,
        ERROR;


        public boolean isSuccess() {
            return this == SUCCESS || this == WARNING;
        }

        public boolean isWarning() {
            return this == WARNING;
        }

        public boolean isError() {
            return this == ERROR;
        }
    }
}

