/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

public final class FileUtils {
    private static final Joiner PATH_JOINER = Joiner.on((char)File.separatorChar);
    private static final Joiner COMMA_SEPARATED_JOINER = Joiner.on((String)", ");
    private static final Joiner UNIX_NEW_LINE_JOINER = Joiner.on((char)'\n');
    private static final Function<File, String> GET_NAME = new Function<File, String>(){

        public String apply(File file) {
            return file.getName();
        }
    };

    public static void deleteFolder(File folder) throws IOException {
        if (!folder.exists()) {
            return;
        }
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                FileUtils.deleteFolder(file);
            }
        }
        if (!folder.delete()) {
            throw new IOException(String.format("Could not delete folder %s", folder));
        }
    }

    public static void emptyFolder(File folder) throws IOException {
        FileUtils.deleteFolder(folder);
        if (!folder.mkdirs()) {
            throw new IOException(String.format("Could not create empty folder %s", folder));
        }
    }

    public static void copy(File from, File toDir) throws IOException {
        File to = new File(toDir, from.getName());
        if (from.isDirectory()) {
            FileUtils.mkdirs(to);
            File[] children = from.listFiles();
            if (children != null) {
                for (File child : children) {
                    FileUtils.copy(child, to);
                }
            }
        } else if (from.isFile()) {
            Files.copy((File)from, (File)to);
        }
    }

    public static void mkdirs(File folder) {
        if (!folder.exists() && !folder.mkdirs()) {
            throw new RuntimeException("Cannot create directory " + folder);
        }
    }

    public static void delete(File file) throws IOException {
        boolean result = file.delete();
        if (!result) {
            throw new IOException("Failed to delete " + file.getAbsolutePath());
        }
    }

    public static void deleteIfExists(File file) throws IOException {
        boolean result = file.delete();
        if (!result && file.exists()) {
            throw new IOException("Failed to delete " + file.getAbsolutePath());
        }
    }

    public static File join(File dir, String ... paths) {
        if (paths.length == 0) {
            return dir;
        }
        return new File(dir, PATH_JOINER.join((Object[])paths));
    }

    public static File join(File dir, Iterable<String> paths) {
        return new File(dir, PATH_JOINER.join(paths));
    }

    public static String join(String ... paths) {
        return PATH_JOINER.join((Object[])paths);
    }

    public static String loadFileWithUnixLineSeparators(File file) throws IOException {
        return UNIX_NEW_LINE_JOINER.join((Iterable)Files.readLines((File)file, (Charset)Charsets.UTF_8));
    }

    public static String relativePath(File file, File dir) {
        Preconditions.checkArgument((boolean)file.isFile(), (String)"%s is not a file.", (Object[])new Object[]{file.getPath()});
        Preconditions.checkArgument((boolean)dir.isDirectory(), (String)"%s is not a directory.", (Object[])new Object[]{dir.getPath()});
        return FileUtils.relativePossiblyNonExistingPath(file, dir);
    }

    public static String relativePossiblyNonExistingPath(File file, File dir) {
        String path = dir.toURI().relativize(file.toURI()).getPath();
        if (File.separatorChar != '/') {
            path = path.replace('/', File.separatorChar);
        }
        return path;
    }

    public static String sha1(File file) throws IOException {
        return Hashing.sha1().hashBytes(Files.toByteArray((File)file)).toString();
    }

    public static FluentIterable<File> getAllFiles(File dir) {
        return Files.fileTreeTraverser().preOrderTraversal((Object)dir).filter(Files.isFile());
    }

    public static String getNamesAsCommaSeparatedList(Iterable<File> files) {
        return COMMA_SEPARATED_JOINER.join(Iterables.transform(files, GET_NAME));
    }
}

