/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.junit.segments;

import com.intellij.rt.execution.junit.segments.Packet;
import com.intellij.rt.execution.junit.segments.PacketProcessor;
import java.util.Collection;
import java.util.Hashtable;

public abstract class OutputObjectRegistry {
    private final Hashtable myKnownKeys = new Hashtable();
    private int myLastIndex = 0;
    private PacketProcessor myMainTransport;

    protected OutputObjectRegistry(PacketProcessor mainTransport, int lastIndex) {
        this.myLastIndex = lastIndex;
        this.myMainTransport = mainTransport;
    }

    public String referenceTo(Object test) {
        if (this.containsKey(test)) {
            return this.getKey(test);
        }
        return this.sendObject(test);
    }

    public String referenceTo(Object test, Collection packets) {
        if (this.containsKey(test)) {
            return this.getKey(test);
        }
        return this.sendObject(test, packets);
    }

    private boolean containsKey(Object test) {
        return this.myKnownKeys.containsKey(this.createObjectWrapper(test));
    }

    private String getKey(Object test) {
        return (String)this.myKnownKeys.get(this.createObjectWrapper(test));
    }

    private void putKey(Object test, String key) {
        this.myKnownKeys.put(this.createObjectWrapper(test), key);
    }

    public void forget(Object test) {
        this.myKnownKeys.remove(this.createObjectWrapper(test));
    }

    private String sendObject(Object test, Collection packets) {
        String key = String.valueOf(this.myLastIndex++);
        this.putKey(test, key);
        Packet packet = this.createPacket();
        packet.addString("O").addReference(key);
        this.addStringRepresentation(test, packet);
        packet.addLong(this.getTestCont(test));
        packet.addString(":");
        packets.add(packet);
        return key;
    }

    public Packet createPacket() {
        return new Packet(this.myMainTransport, this);
    }

    private String sendObject(Object test) {
        String key = String.valueOf(this.myLastIndex++);
        this.putKey(test, key);
        Packet packet = this.createPacket().addString("O").addReference(key);
        this.addStringRepresentation(test, packet);
        packet.addLong(this.getTestCont(test));
        packet.send();
        return key;
    }

    protected abstract int getTestCont(Object var1);

    protected abstract void addStringRepresentation(Object var1, Packet var2);

    protected static void addTestClass(Packet packet, String className) {
        packet.addLimitedString("TC").addLimitedString(className);
    }

    protected void addUnknownTest(Packet packet, Object test) {
        packet.addLimitedString("TU").addLong(this.getTestCont(test)).addLimitedString(test.getClass().getName());
    }

    protected static void addAllInPackage(Packet packet, String name) {
        packet.addLimitedString("TN").addLimitedString(name);
    }

    protected static void addTestMethod(Packet packet, String methodName, String className) {
        packet.addLimitedString("TM").addLimitedString(methodName).addLimitedString(className);
    }

    public int getKnownObject(Object description) {
        String o = this.getKey(description);
        if (o instanceof String) {
            return Integer.parseInt(o);
        }
        return 0;
    }

    protected Object createObjectWrapper(Object object) {
        return object;
    }
}

