/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import org.jetbrains.annotations.NotNull;

public class PathUtilRt {
    @NotNull
    public static String getFileName(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/PathUtilRt", "getFileName"));
        }
        if (path.length() == 0) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtilRt", "getFileName"));
            }
            return "";
        }
        char c = path.charAt(path.length() - 1);
        int end = c == '/' || c == '\\' ? path.length() - 1 : path.length();
        int start = Math.max(path.lastIndexOf(47, end - 1), path.lastIndexOf(92, end - 1)) + 1;
        String string = path.substring(start, end);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtilRt", "getFileName"));
        }
        return string;
    }

    @NotNull
    public static String getParentPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/PathUtilRt", "getParentPath"));
        }
        if (path.length() == 0) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtilRt", "getParentPath"));
            }
            return "";
        }
        int end = Math.max(path.lastIndexOf(47), path.lastIndexOf(92));
        if (end == path.length() - 1) {
            end = Math.max(path.lastIndexOf(47, end - 1), path.lastIndexOf(92, end - 1));
        }
        String string = end == -1 ? "" : path.substring(0, end);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtilRt", "getParentPath"));
        }
        return string;
    }

    @NotNull
    public static String suggestFileName(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/PathUtilRt", "suggestFileName"));
        }
        String string = PathUtilRt.suggestFileName(text, false, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtilRt", "suggestFileName"));
        }
        return string;
    }

    @NotNull
    public static String suggestFileName(@NotNull String text, boolean allowDots, boolean allowSpaces) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/PathUtilRt", "suggestFileName"));
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!PathUtilRt.isValidFileNameChar(c, true) || !allowDots && c == '.' || !allowSpaces && Character.isWhitespace(c)) {
                result.append('_');
                continue;
            }
            result.append(c);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtilRt", "suggestFileName"));
        }
        return string;
    }

    public static boolean isValidFileName(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/util/PathUtilRt", "isValidFileName"));
        }
        return PathUtilRt.isValidFileName(fileName, true);
    }

    public static boolean isValidFileName(@NotNull String fileName, boolean strict) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/util/PathUtilRt", "isValidFileName"));
        }
        if (fileName.length() == 0 || fileName.equals(".") || fileName.equals("..")) {
            return false;
        }
        for (int i = 0; i < fileName.length(); ++i) {
            if (PathUtilRt.isValidFileNameChar(fileName.charAt(i), strict)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidFileNameChar(char c, boolean strict) {
        if (c == '/' || c == '\\') {
            return false;
        }
        if (!strict) {
            return true;
        }
        return c != '\t' && c != '\n' && c != '\r' && c != ':' && c != ';' && c != '*' && c != '?' && c != '\"' && c != '\'' && c != '<' && c != '>';
    }
}

