/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Toolkit;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBUI {
    private static float SCALE_FACTOR = JBUI.calculateScaleFactor();

    private static float calculateScaleFactor() {
        if (SystemInfo.isMac) {
            return 1.0f;
        }
        if (SystemProperties.has("hidpi") && !SystemProperties.is("hidpi")) {
            return 1.0f;
        }
        if (SystemInfo.isLinux) {
            int dpi = JBUI.getSystemDPI();
            if (dpi < 120) {
                return 1.0f;
            }
            if (dpi < 144) {
                return 1.25f;
            }
            if (dpi < 168) {
                return 1.5f;
            }
            if (dpi < 192) {
                return 1.75f;
            }
            return 2.0f;
        }
        int size = -1;
        if (SystemInfo.isWindows) {
            UIUtil.initSystemFontData();
            Pair<String, Integer> fdata = UIUtil.getSystemFontData();
            if (fdata != null) {
                size = fdata.getSecond();
            }
        }
        if (size == -1) {
            size = Fonts.label().getSize();
        }
        if (size <= 13) {
            return 1.0f;
        }
        if (size <= 16) {
            return 1.25f;
        }
        if (size <= 18) {
            return 1.5f;
        }
        if (size < 24) {
            return 1.75f;
        }
        return 2.0f;
    }

    private static int getSystemDPI() {
        try {
            return Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (HeadlessException e) {
            return 96;
        }
    }

    public static void setScaleFactor(float scale) {
        if (SystemProperties.has("hidpi") && !SystemProperties.is("hidpi")) {
            return;
        }
        scale = scale < 1.25f ? 1.0f : (scale < 1.5f ? 1.25f : (scale < 1.75f ? 1.5f : (scale < 2.0f ? 1.75f : 2.0f)));
        if (SystemInfo.isLinux && scale == 1.25f) {
            scale = 1.0f;
        }
        SCALE_FACTOR = scale;
        IconLoader.setScale(scale);
    }

    public static int scale(int i) {
        return Math.round(SCALE_FACTOR * (float)i);
    }

    public static int scaleFontSize(int fontSize) {
        if (SCALE_FACTOR == 1.25f) {
            return (int)((float)fontSize * 1.34f);
        }
        if (SCALE_FACTOR == 1.75f) {
            return (int)((float)fontSize * 1.67f);
        }
        return JBUI.scale(fontSize);
    }

    public static JBDimension size(int width, int height) {
        return new JBDimension(width, height);
    }

    public static JBDimension size(int widthAndHeight) {
        return new JBDimension(widthAndHeight, widthAndHeight);
    }

    public static JBDimension size(Dimension size) {
        return size instanceof JBDimension ? (JBDimension)size : new JBDimension(size.width, size.height);
    }

    public static JBInsets insets(int top, int left, int bottom, int right) {
        return new JBInsets(top, left, bottom, right);
    }

    public static JBInsets insets(int all) {
        return JBUI.insets(all, all, all, all);
    }

    public static JBInsets insets(int topBottom, int leftRight) {
        return JBUI.insets(topBottom, leftRight, topBottom, leftRight);
    }

    public static JBInsets emptyInsets() {
        return new JBInsets(0, 0, 0, 0);
    }

    public static JBInsets insetsTop(int t) {
        return JBUI.insets(t, 0, 0, 0);
    }

    public static JBInsets insetsLeft(int l) {
        return JBUI.insets(0, l, 0, 0);
    }

    public static JBInsets insetsBottom(int b) {
        return JBUI.insets(0, 0, b, 0);
    }

    public static JBInsets insetsRight(int r) {
        return JBUI.insets(0, 0, 0, r);
    }

    public static EmptyIcon emptyIcon(int i) {
        return (EmptyIcon)EmptyIcon.create(JBUI.scale(i));
    }

    public static JBDimension emptySize() {
        return new JBDimension(0, 0);
    }

    public static float scale(float f) {
        return f * SCALE_FACTOR;
    }

    public static JBInsets insets(Insets insets) {
        return JBInsets.create(insets);
    }

    public static boolean isHiDPI() {
        return SCALE_FACTOR > 1.0f;
    }

    public static class Panels {
        public static BorderLayoutPanel simplePanel() {
            return new BorderLayoutPanel();
        }

        public static BorderLayoutPanel simplePanel(Component comp) {
            return Panels.simplePanel().addToCenter(comp);
        }

        public static BorderLayoutPanel simplePanel(int hgap, int vgap) {
            return new BorderLayoutPanel(hgap, vgap);
        }
    }

    public static class Borders {
        public static JBEmptyBorder empty(int top, int left, int bottom, int right) {
            return new JBEmptyBorder(top, left, bottom, right);
        }

        public static JBEmptyBorder empty(int topAndBottom, int leftAndRight) {
            return Borders.empty(topAndBottom, leftAndRight, topAndBottom, leftAndRight);
        }

        public static JBEmptyBorder emptyTop(int offset) {
            return Borders.empty(offset, 0, 0, 0);
        }

        public static JBEmptyBorder emptyLeft(int offset) {
            return Borders.empty(0, offset, 0, 0);
        }

        public static JBEmptyBorder emptyBottom(int offset) {
            return Borders.empty(0, 0, offset, 0);
        }

        public static JBEmptyBorder emptyRight(int offset) {
            return Borders.empty(0, 0, 0, offset);
        }

        public static JBEmptyBorder empty() {
            return Borders.empty(0, 0, 0, 0);
        }

        public static Border empty(int offsets) {
            return Borders.empty(offsets, offsets, offsets, offsets);
        }

        public static Border customLine(Color color, int top, int left, int bottom, int right) {
            return new CustomLineBorder(color, JBUI.insets(top, left, bottom, right));
        }

        public static Border customLine(Color color, int thickness) {
            return Borders.customLine(color, thickness, thickness, thickness, thickness);
        }

        public static Border merge(@Nullable Border source, @NotNull Border extra, boolean extraIsOutside) {
            if (extra == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extra", "com/intellij/util/ui/JBUI$Borders", "merge"));
            }
            if (source == null) {
                return extra;
            }
            return new CompoundBorder(extraIsOutside ? extra : source, extraIsOutside ? source : extra);
        }
    }

    public static class Fonts {
        public static JBFont label() {
            return JBFont.create(UIManager.getFont("Label.font"), false);
        }

        public static JBFont label(float size) {
            return Fonts.label().deriveFont(JBUI.scale(size));
        }

        public static JBFont smallFont() {
            return Fonts.label().deriveFont(UIUtil.getFontSize(UIUtil.FontSize.SMALL));
        }

        public static JBFont miniFont() {
            return Fonts.label().deriveFont(UIUtil.getFontSize(UIUtil.FontSize.MINI));
        }

        public static JBFont create(String fontFamily, int size) {
            return JBFont.create(new Font(fontFamily, 0, size));
        }
    }
}

